/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.handlers;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandlerWithState;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.HandlerEvent;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandler2;
import org.eclipse.core.commands.IHandlerListener;
import org.eclipse.core.commands.IStateListener;
import org.eclipse.core.commands.State;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.util.BundleUtility;
import org.eclipse.ui.internal.util.Util;
import org.eclipse.ui.menus.UIElement;
import org.eclipse.ui.services.IEvaluationReference;
import org.eclipse.ui.services.IEvaluationService;

public final class HandlerProxy
extends AbstractHandlerWithState
implements IElementUpdater {
    private static Map CEToProxyMap = new HashMap();
    private static final String PROP_ENABLED = "enabled";
    private IConfigurationElement configurationElement;
    private final Expression enabledWhenExpression;
    private IHandler handler = null;
    private final String handlerAttributeName;
    private IHandlerListener handlerListener;
    private IEvaluationService evaluationService;
    private IPropertyChangeListener enablementListener;
    private IEvaluationReference enablementRef;
    private boolean proxyEnabled;
    private String commandId;
    private State checkedState;
    private State radioState;
    private Exception loadException;

    public HandlerProxy(String string, IConfigurationElement iConfigurationElement, String string2) {
        this(string, iConfigurationElement, string2, null, null);
    }

    public HandlerProxy(String string, IConfigurationElement iConfigurationElement, String string2, Expression expression, IEvaluationService iEvaluationService) {
        if (iConfigurationElement == null) {
            throw new NullPointerException("The configuration element backing a handler proxy cannot be null");
        }
        if (string2 == null) {
            throw new NullPointerException("The attribute containing the handler class must be known");
        }
        if (expression != null && iEvaluationService == null) {
            throw new NullPointerException("We must have a handler service and evaluation service to support the enabledWhen expression");
        }
        this.commandId = string;
        this.configurationElement = iConfigurationElement;
        this.handlerAttributeName = string2;
        this.enabledWhenExpression = expression;
        this.evaluationService = iEvaluationService;
        if (expression != null) {
            this.setProxyEnabled(false);
            this.registerEnablement();
        } else {
            this.setProxyEnabled(true);
        }
        CEToProxyMap.put(iConfigurationElement, this);
    }

    public static void updateStaleCEs(IConfigurationElement[] iConfigurationElementArray) {
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            HandlerProxy handlerProxy = (HandlerProxy)CEToProxyMap.get(iConfigurationElementArray[n]);
            if (handlerProxy != null) {
                handlerProxy.configurationElement = iConfigurationElementArray[n];
            }
            ++n;
        }
    }

    private void registerEnablement() {
        this.enablementRef = this.evaluationService.addEvaluationListener(this.enabledWhenExpression, this.getEnablementListener(), PROP_ENABLED);
    }

    public void setEnabled(Object object) {
        if (!(object instanceof IEvaluationContext)) {
            return;
        }
        IEvaluationContext iEvaluationContext = (IEvaluationContext)object;
        if (this.enabledWhenExpression != null) {
            try {
                this.setProxyEnabled(this.enabledWhenExpression.evaluate(iEvaluationContext) == EvaluationResult.TRUE);
            }
            catch (CoreException coreException) {}
        }
        if (this.isOkToLoad() && this.loadHandler() && this.handler instanceof IHandler2) {
            ((IHandler2)this.handler).setEnabled(object);
        }
    }

    void setProxyEnabled(boolean bl) {
        this.proxyEnabled = bl;
    }

    boolean getProxyEnabled() {
        return this.proxyEnabled;
    }

    private IPropertyChangeListener getEnablementListener() {
        if (this.enablementListener == null) {
            this.enablementListener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (propertyChangeEvent.getProperty() == HandlerProxy.PROP_ENABLED) {
                        HandlerProxy.this.setProxyEnabled(propertyChangeEvent.getNewValue() == null ? false : (Boolean)propertyChangeEvent.getNewValue());
                        HandlerProxy.this.fireHandlerChanged(new HandlerEvent((IHandler)HandlerProxy.this, true, false));
                    }
                }
            };
        }
        return this.enablementListener;
    }

    public final void dispose() {
        if (this.handler != null) {
            if (this.handlerListener != null) {
                this.handler.removeHandlerListener(this.handlerListener);
                this.handlerListener = null;
            }
            this.handler.dispose();
            this.handler = null;
        }
        if (this.enablementListener != null) {
            this.evaluationService.removeEvaluationListener(this.enablementRef);
            this.enablementRef = null;
            this.enablementListener = null;
        }
    }

    public final Object execute(ExecutionEvent executionEvent) throws ExecutionException {
        if (this.loadHandler()) {
            if (!this.isEnabled()) {
                MessageDialog.openInformation((Shell)Util.getShellToParentOn(), (String)WorkbenchMessages.Information, (String)WorkbenchMessages.PluginAction_disabledMessage);
                return null;
            }
            return this.handler.execute(executionEvent);
        }
        if (this.loadException != null) {
            throw new ExecutionException("Exception occured when loading the handler", (Throwable)this.loadException);
        }
        return null;
    }

    public final boolean isEnabled() {
        if (this.enabledWhenExpression != null) {
            if (!this.getProxyEnabled()) {
                return false;
            }
            if (this.isOkToLoad() && this.loadHandler()) {
                return this.handler.isEnabled();
            }
            return true;
        }
        if (this.isOkToLoad() && this.loadHandler()) {
            return this.handler.isEnabled();
        }
        return true;
    }

    public final boolean isHandled() {
        if (this.configurationElement != null && this.handler == null) {
            return true;
        }
        if (this.isOkToLoad() && this.loadHandler()) {
            return this.handler.isHandled();
        }
        return false;
    }

    private final boolean loadHandler() {
        if (this.handler == null) {
            try {
                if (this.configurationElement != null) {
                    this.handler = (IHandler)this.configurationElement.createExecutableExtension(this.handlerAttributeName);
                    this.handler.addHandlerListener(this.getHandlerListener());
                    this.setEnabled(this.evaluationService == null ? null : this.evaluationService.getCurrentState());
                    this.refreshElements();
                    return true;
                }
            }
            catch (ClassCastException classCastException) {
                Status status = new Status(4, WorkbenchPlugin.PI_WORKBENCH, 0, "The proxied handler was the wrong class", (Throwable)classCastException);
                WorkbenchPlugin.log("The proxied handler was the wrong class", (IStatus)status);
                this.configurationElement = null;
                this.loadException = classCastException;
            }
            catch (CoreException coreException) {
                String string = "The proxied handler for '" + this.configurationElement.getAttribute(this.handlerAttributeName) + "' could not be loaded";
                Status status = new Status(4, WorkbenchPlugin.PI_WORKBENCH, 0, string, (Throwable)coreException);
                WorkbenchPlugin.log(string, (IStatus)status);
                this.configurationElement = null;
                this.loadException = coreException;
            }
            return false;
        }
        return true;
    }

    private IHandlerListener getHandlerListener() {
        if (this.handlerListener == null) {
            this.handlerListener = new IHandlerListener(){

                public void handlerChanged(HandlerEvent handlerEvent) {
                    HandlerProxy.this.fireHandlerChanged(new HandlerEvent((IHandler)HandlerProxy.this, handlerEvent.isEnabledChanged(), handlerEvent.isHandledChanged()));
                }
            };
        }
        return this.handlerListener;
    }

    public final String toString() {
        if (this.handler == null) {
            String string;
            if (this.configurationElement != null && (string = this.getConfigurationElementAttribute()) != null) {
                return string;
            }
            return "HandlerProxy()";
        }
        return this.handler.toString();
    }

    private String getConfigurationElementAttribute() {
        String string = this.configurationElement.getAttribute(this.handlerAttributeName);
        if (string == null) {
            IConfigurationElement[] iConfigurationElementArray = this.configurationElement.getChildren(this.handlerAttributeName);
            int n = 0;
            while (n < iConfigurationElementArray.length) {
                String string2 = iConfigurationElementArray[n].getAttribute("class");
                if (string2 != null) {
                    return string2;
                }
                ++n;
            }
        }
        return string;
    }

    private boolean isOkToLoad() {
        if (PlatformUI.getWorkbench().isClosing()) {
            return this.handler != null;
        }
        if (this.configurationElement != null && this.handler == null) {
            String string = this.configurationElement.getContributor().getName();
            return BundleUtility.isActive(string);
        }
        return true;
    }

    @Override
    public void updateElement(UIElement uIElement, Map map) {
        if (this.checkedState != null) {
            Boolean bl = (Boolean)this.checkedState.getValue();
            uIElement.setChecked(bl);
        } else if (this.radioState != null) {
            String string = (String)this.radioState.getValue();
            Object v = map.get("org.eclipse.ui.commands.radioStateParameter");
            uIElement.setChecked(string != null && string.equals(v));
        }
        if (this.handler != null && this.handler instanceof IElementUpdater) {
            ((IElementUpdater)this.handler).updateElement(uIElement, map);
        }
    }

    private void refreshElements() {
        if (this.commandId == null || !(this.handler instanceof IElementUpdater) && this.checkedState == null && this.radioState == null) {
            return;
        }
        ICommandService iCommandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        iCommandService.refreshElements(this.commandId, null);
    }

    public void handleStateChange(State state, Object object) {
        if (state.getId().equals("org.eclipse.ui.commands.toggleState")) {
            this.checkedState = state;
            this.refreshElements();
        } else if (state.getId().equals("org.eclipse.ui.commands.radioState")) {
            this.radioState = state;
            this.refreshElements();
        }
        if (this.handler instanceof IStateListener) {
            ((IStateListener)this.handler).handleStateChange(state, object);
        }
    }

    public IConfigurationElement getConfigurationElement() {
        return this.configurationElement;
    }

    public String getAttributeName() {
        return this.handlerAttributeName;
    }

    public IHandler getHandler() {
        return this.handler;
    }
}

