/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.handlers;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.handlers.HandlerProxy;
import org.eclipse.ui.internal.handlers.LegacyHandlerProxy;
import org.eclipse.ui.internal.handlers.LegacyHandlerWrapper;
import org.eclipse.ui.internal.services.RegistryPersistence;
import org.eclipse.ui.services.IEvaluationService;

public final class HandlerPersistence
extends RegistryPersistence {
    private static final int INDEX_COMMAND_DEFINITIONS = 0;
    private static final int INDEX_HANDLER_DEFINITIONS = 1;
    private static final int INDEX_HANDLER_SUBMISSIONS = 2;
    private final Collection handlerActivations = new ArrayList();
    private final IHandlerService handlerService;
    private IEvaluationService evaluationService;

    HandlerPersistence(IHandlerService iHandlerService, IEvaluationService iEvaluationService) {
        this.handlerService = iHandlerService;
        this.evaluationService = iEvaluationService;
    }

    private final void clearActivations(IHandlerService iHandlerService) {
        iHandlerService.deactivateHandlers(this.handlerActivations);
        for (IHandlerActivation iHandlerActivation : this.handlerActivations) {
            if (iHandlerActivation.getHandler() == null) continue;
            try {
                iHandlerActivation.getHandler().dispose();
            }
            catch (Exception exception) {
                WorkbenchPlugin.log("Failed to dispose handler for " + iHandlerActivation.getCommandId(), exception);
            }
            catch (LinkageError linkageError) {
                WorkbenchPlugin.log("Failed to dispose handler for " + iHandlerActivation.getCommandId(), linkageError);
            }
        }
        this.handlerActivations.clear();
    }

    @Override
    public final void dispose() {
        super.dispose();
        this.clearActivations(this.handlerService);
    }

    @Override
    protected final boolean isChangeImportant(IRegistryChangeEvent iRegistryChangeEvent) {
        return false;
    }

    public boolean handlersNeedUpdating(IRegistryChangeEvent iRegistryChangeEvent) {
        IExtensionDelta[] iExtensionDeltaArray;
        IExtensionDelta[] iExtensionDeltaArray2;
        IExtensionDelta[] iExtensionDeltaArray3 = iRegistryChangeEvent.getExtensionDeltas("org.eclipse.ui", "handlers");
        return iExtensionDeltaArray3.length != 0 || (iExtensionDeltaArray2 = iRegistryChangeEvent.getExtensionDeltas("org.eclipse.ui", "commands")).length != 0 || (iExtensionDeltaArray = iRegistryChangeEvent.getExtensionDeltas("org.eclipse.ui", "actionDefinitions")).length != 0;
    }

    @Override
    protected final void read() {
        super.read();
        this.reRead();
    }

    public final void reRead() {
        String string;
        IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        IConfigurationElement[][] iConfigurationElementArrayArray = new IConfigurationElement[3][];
        IConfigurationElement[] iConfigurationElementArray = iExtensionRegistry.getConfigurationElementsFor("org.eclipse.ui.commands");
        int n4 = 0;
        while (n4 < iConfigurationElementArray.length) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n4];
            string = iConfigurationElement.getName();
            if ("handlerSubmission".equals(string)) {
                HandlerPersistence.addElementToIndexedArray(iConfigurationElement, iConfigurationElementArrayArray, 2, n3++);
            } else if ("command".equals(string)) {
                HandlerPersistence.addElementToIndexedArray(iConfigurationElement, iConfigurationElementArrayArray, 0, n++);
            }
            ++n4;
        }
        IConfigurationElement[] iConfigurationElementArray2 = iExtensionRegistry.getConfigurationElementsFor("org.eclipse.ui.handlers");
        int n5 = 0;
        while (n5 < iConfigurationElementArray2.length) {
            string = iConfigurationElementArray2[n5];
            String string2 = string.getName();
            if ("handler".equals(string2)) {
                HandlerPersistence.addElementToIndexedArray((IConfigurationElement)string, iConfigurationElementArrayArray, 1, n2++);
            }
            ++n5;
        }
        this.clearActivations(this.handlerService);
        this.readDefaultHandlersFromRegistry(iConfigurationElementArrayArray[0], n);
        this.readHandlerSubmissionsFromRegistry(iConfigurationElementArrayArray[2], n3);
        this.readHandlersFromRegistry(iConfigurationElementArrayArray[1], n2);
    }

    private final void readDefaultHandlersFromRegistry(IConfigurationElement[] iConfigurationElementArray, int n) {
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
            String string = HandlerPersistence.readOptional(iConfigurationElement, "id");
            if (string != null && (iConfigurationElement.getAttribute("defaultHandler") != null || iConfigurationElement.getChildren("defaultHandler").length != 0)) {
                this.handlerActivations.add(this.handlerService.activateHandler(string, (IHandler)new HandlerProxy(string, iConfigurationElement, "defaultHandler")));
            }
            ++n2;
        }
    }

    private final void readHandlersFromRegistry(IConfigurationElement[] iConfigurationElementArray, int n) {
        ArrayList arrayList = new ArrayList(1);
        int n2 = 0;
        while (n2 < n) {
            Expression expression;
            Expression expression2;
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
            String string = HandlerPersistence.readRequired(iConfigurationElement, "commandId", arrayList, "Handlers need a command id");
            if (string != null && HandlerPersistence.checkClass(iConfigurationElement, arrayList, "Handlers need a class", string) && (expression2 = HandlerPersistence.readWhenElement(iConfigurationElement, "activeWhen", string, arrayList)) != ERROR_EXPRESSION && (expression = HandlerPersistence.readWhenElement(iConfigurationElement, "enabledWhen", string, arrayList)) != ERROR_EXPRESSION) {
                HandlerProxy handlerProxy = new HandlerProxy(string, iConfigurationElement, "class", expression, this.evaluationService);
                this.handlerActivations.add(this.handlerService.activateHandler(string, (IHandler)handlerProxy, expression2));
                String string2 = HandlerPersistence.readOptional(iConfigurationElement, "helpContextId");
                this.handlerService.setHelpContextId((IHandler)handlerProxy, string2);
            }
            ++n2;
        }
        HandlerPersistence.logWarnings(arrayList, "Warnings while parsing the handlers from the 'org.eclipse.ui.handlers' extension point.");
    }

    private final void readHandlerSubmissionsFromRegistry(IConfigurationElement[] iConfigurationElementArray, int n) {
        ArrayList arrayList = new ArrayList(1);
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
            String string = HandlerPersistence.readRequired(iConfigurationElement, "commandId", arrayList, "Handler submissions need a command id");
            if (string != null) {
                this.handlerActivations.add(this.handlerService.activateHandler(string, new LegacyHandlerWrapper(new LegacyHandlerProxy(iConfigurationElement))));
            }
            ++n2;
        }
        HandlerPersistence.logWarnings(arrayList, "Warnings while parsing the handler submissions from the 'org.eclipse.ui.commands' extension point.");
    }
}

