/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.handlers;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.util.Tracing;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISourceProvider;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.handlers.HandlerActivation;
import org.eclipse.ui.internal.misc.Policy;
import org.eclipse.ui.internal.services.EvaluationResultCacheComparator;
import org.eclipse.ui.internal.services.EvaluationService;
import org.eclipse.ui.internal.services.IEvaluationResultCache;
import org.eclipse.ui.services.IEvaluationService;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.ui.services.ISourceProviderService;

final class HandlerAuthority {
    private static final boolean DEBUG = Policy.DEBUG_HANDLERS;
    private static final boolean DEBUG_PERFORMANCE = Policy.DEBUG_HANDLERS_PERFORMANCE;
    private static final boolean DEBUG_VERBOSE = Policy.DEBUG_HANDLERS && Policy.DEBUG_HANDLERS_VERBOSE;
    private static final String DEBUG_VERBOSE_COMMAND_ID = Policy.DEBUG_HANDLERS_VERBOSE_COMMAND_ID;
    private static final String TRACING_COMPONENT = "HANDLERS";
    private static final String[] SELECTION_VARIABLES = new String[]{"selection", "activeFocusControlId", "activeFocusControl", "activeMenuEditorInput", "activeMenu", "activeMenuSelection"};
    private final ICommandService commandService;
    private final Map handlerActivationsByCommandId = new HashMap();
    private Set previousLogs = new HashSet();
    private IServiceLocator locator;
    private Collection changedCommandIds = new HashSet();
    private IPropertyChangeListener serviceListener;
    private IEvaluationService evalService = null;

    HandlerAuthority(ICommandService iCommandService, IServiceLocator iServiceLocator) {
        if (iCommandService == null) {
            throw new NullPointerException("The handler authority needs a command service");
        }
        this.commandService = iCommandService;
        this.locator = iServiceLocator;
    }

    private IEvaluationService getEvaluationService() {
        if (this.evalService == null) {
            this.evalService = (IEvaluationService)this.locator.getService(IEvaluationService.class);
            this.evalService.addServiceListener(this.getServiceListener());
        }
        return this.evalService;
    }

    private IPropertyChangeListener getServiceListener() {
        if (this.serviceListener == null) {
            this.serviceListener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if ("org.eclipse.ui.services.notifying".equals(propertyChangeEvent.getProperty()) && propertyChangeEvent.getNewValue() instanceof Boolean) {
                        boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                        if (bl) {
                            HandlerAuthority.this.changedCommandIds.clear();
                        } else {
                            HandlerAuthority.this.processChangedCommands();
                        }
                    }
                }
            };
        }
        return this.serviceListener;
    }

    public void dispose() {
        if (this.serviceListener != null) {
            this.getEvaluationService().removeServiceListener(this.serviceListener);
            this.serviceListener = null;
        }
    }

    final void activateHandler(IHandlerActivation iHandlerActivation) {
        HandlerPropertyListener handlerPropertyListener;
        Object object;
        HandlerActivation handlerActivation = (HandlerActivation)iHandlerActivation;
        String string = handlerActivation.getCommandId();
        MultiStatus multiStatus = new MultiStatus("org.eclipse.ui.workbench", 0, "A handler conflict occurred.  This may disable some commands.", null);
        Object v = this.handlerActivationsByCommandId.get(string);
        if (v instanceof SortedSet) {
            object = (IStatus[])v;
            if (!object.contains(handlerActivation)) {
                object.add(handlerActivation);
                if (handlerActivation.getExpression() != null) {
                    handlerPropertyListener = new HandlerPropertyListener(handlerActivation);
                    handlerActivation.setReference(this.getEvaluationService().addEvaluationListener(handlerActivation.getExpression(), handlerPropertyListener, handlerActivation.getCommandId()));
                }
                this.updateCommand(string, this.resolveConflicts(string, (SortedSet)object, multiStatus));
            }
        } else if (v instanceof IHandlerActivation) {
            if (v != handlerActivation) {
                object = new TreeSet(new EvaluationResultCacheComparator());
                object.add(v);
                object.add(handlerActivation);
                if (handlerActivation.getExpression() != null) {
                    handlerPropertyListener = new HandlerPropertyListener(handlerActivation);
                    handlerActivation.setReference(this.getEvaluationService().addEvaluationListener(handlerActivation.getExpression(), handlerPropertyListener, handlerActivation.getCommandId()));
                }
                this.handlerActivationsByCommandId.put(string, object);
                this.updateCommand(string, this.resolveConflicts(string, (SortedSet)object, multiStatus));
            }
        } else {
            this.handlerActivationsByCommandId.put(string, handlerActivation);
            if (handlerActivation.getExpression() != null) {
                object = new HandlerPropertyListener(handlerActivation);
                handlerActivation.setReference(this.getEvaluationService().addEvaluationListener(handlerActivation.getExpression(), (IPropertyChangeListener)object, handlerActivation.getCommandId()));
            }
            this.updateCommand(string, this.evaluate(handlerActivation) ? handlerActivation : null);
        }
        if (multiStatus.getSeverity() != 0) {
            object = multiStatus.getChildren();
            int n = 0;
            while (n < ((Object)object).length) {
                Object object2 = object[n];
                String string2 = object2.getMessage();
                if (string2.indexOf("com.deltawalker.ui.file.open") != -1 || string2.indexOf("com.deltawalker.ui.file.save") != -1) {
                    return;
                }
                ++n;
            }
        }
    }

    final void deactivateHandler(IHandlerActivation iHandlerActivation) {
        HandlerActivation handlerActivation = (HandlerActivation)iHandlerActivation;
        String string = handlerActivation.getCommandId();
        MultiStatus multiStatus = new MultiStatus("org.eclipse.ui.workbench", 0, "A handler conflict occurred.  This may disable some commands.", null);
        Object v = this.handlerActivationsByCommandId.get(string);
        if (v instanceof SortedSet) {
            SortedSet sortedSet = (SortedSet)v;
            if (sortedSet.contains(handlerActivation)) {
                sortedSet.remove(handlerActivation);
                if (handlerActivation.getReference() != null) {
                    this.getEvaluationService().removeEvaluationListener(handlerActivation.getReference());
                    handlerActivation.setReference(null);
                    handlerActivation.setListener(null);
                }
                if (sortedSet.isEmpty()) {
                    this.handlerActivationsByCommandId.remove(string);
                    this.updateCommand(string, null);
                } else if (sortedSet.size() == 1) {
                    IHandlerActivation iHandlerActivation2 = (IHandlerActivation)sortedSet.iterator().next();
                    this.handlerActivationsByCommandId.put(string, iHandlerActivation2);
                    this.updateCommand(string, this.evaluate(iHandlerActivation2) ? iHandlerActivation2 : null);
                } else {
                    this.updateCommand(string, this.resolveConflicts(string, sortedSet, multiStatus));
                }
            }
        } else if (v instanceof IHandlerActivation && v == handlerActivation) {
            if (handlerActivation.getReference() != null) {
                this.getEvaluationService().removeEvaluationListener(handlerActivation.getReference());
                handlerActivation.setReference(null);
                handlerActivation.setListener(null);
            }
            this.handlerActivationsByCommandId.remove(string);
            this.updateCommand(string, null);
        }
        if (multiStatus.getSeverity() != 0) {
            WorkbenchPlugin.log((IStatus)multiStatus);
        }
    }

    private final IHandlerActivation resolveConflicts(String string, SortedSet sortedSet, MultiStatus multiStatus) {
        if (sortedSet.isEmpty()) {
            return null;
        }
        Iterator iterator = sortedSet.iterator();
        IHandlerActivation iHandlerActivation = null;
        IHandlerActivation iHandlerActivation2 = null;
        boolean bl = false;
        while (iterator.hasNext()) {
            iHandlerActivation2 = (IHandlerActivation)iterator.next();
            if (!this.evaluate(iHandlerActivation2)) continue;
            if (DEBUG_VERBOSE && (DEBUG_VERBOSE_COMMAND_ID == null || DEBUG_VERBOSE_COMMAND_ID.equals(string))) {
                Tracing.printTrace((String)TRACING_COMPONENT, (String)("    resolveConflicts: eval: " + iHandlerActivation2));
            }
            if (iHandlerActivation == null) {
                iHandlerActivation = iHandlerActivation2;
                bl = false;
                continue;
            }
            int n = iHandlerActivation.compareTo(iHandlerActivation2);
            if (n < 0) {
                iHandlerActivation = iHandlerActivation2;
                bl = false;
                continue;
            }
            if (n != 0) break;
            if (iHandlerActivation2.getHandler() == iHandlerActivation.getHandler()) continue;
            bl = true;
            break;
        }
        if (DEBUG) {
            if (bl) {
                Tracing.printTrace((String)TRACING_COMPONENT, (String)("Unresolved conflict detected for '" + string + '\''));
            } else if (iHandlerActivation != null && DEBUG_VERBOSE && (DEBUG_VERBOSE_COMMAND_ID == null || DEBUG_VERBOSE_COMMAND_ID.equals(string))) {
                Tracing.printTrace((String)TRACING_COMPONENT, (String)"Resolved conflict detected.  The following activation won: ");
                Tracing.printTrace((String)TRACING_COMPONENT, (String)("    " + iHandlerActivation));
            }
        }
        if (bl) {
            if (this.previousLogs.add(string)) {
                StringWriter stringWriter = new StringWriter();
                BufferedWriter bufferedWriter = new BufferedWriter(stringWriter);
                try {
                    bufferedWriter.write("Conflict for '");
                    bufferedWriter.write(string);
                    bufferedWriter.write("':");
                    bufferedWriter.newLine();
                    bufferedWriter.write(iHandlerActivation.toString());
                    bufferedWriter.newLine();
                    bufferedWriter.write(iHandlerActivation2.toString());
                    bufferedWriter.flush();
                }
                catch (IOException iOException) {}
                Status status = new Status(2, "org.eclipse.ui.workbench", stringWriter.toString());
                multiStatus.add((IStatus)status);
            }
            return null;
        }
        return iHandlerActivation;
    }

    protected final void sourceChanged(int n) {
    }

    private final void updateCommand(String string, IHandlerActivation iHandlerActivation) {
        Command command = this.commandService.getCommand(string);
        if (iHandlerActivation == null) {
            command.setHandler(null);
        } else {
            command.setHandler(iHandlerActivation.getHandler());
            this.commandService.refreshElements(string, null);
        }
    }

    public final IHandler findHandler(String string, IEvaluationContext iEvaluationContext) {
        Object v = this.handlerActivationsByCommandId.get(string);
        if (v instanceof IHandlerActivation) {
            IHandlerActivation iHandlerActivation = (IHandlerActivation)v;
            try {
                if (this.eval(iEvaluationContext, iHandlerActivation)) {
                    return iHandlerActivation.getHandler();
                }
            }
            catch (CoreException coreException) {}
        } else if (v instanceof SortedSet) {
            SortedSet sortedSet = (SortedSet)v;
            IEvaluationResultCache iEvaluationResultCache = null;
            IHandlerActivation iHandlerActivation = null;
            Iterator iterator = sortedSet.iterator();
            while (iterator.hasNext() && iEvaluationResultCache == null) {
                IHandlerActivation iHandlerActivation2 = (IHandlerActivation)iterator.next();
                try {
                    if (!this.eval(iEvaluationContext, iHandlerActivation2)) continue;
                    iEvaluationResultCache = iHandlerActivation;
                    iHandlerActivation = iHandlerActivation2;
                }
                catch (CoreException coreException) {}
            }
            if (iHandlerActivation != null) {
                if (iEvaluationResultCache == null) {
                    return iHandlerActivation.getHandler();
                }
                if (iEvaluationResultCache.getSourcePriority() != iHandlerActivation.getSourcePriority()) {
                    return iEvaluationResultCache.getHandler();
                }
            }
        }
        return null;
    }

    private boolean eval(IEvaluationContext iEvaluationContext, IHandlerActivation iHandlerActivation) throws CoreException {
        Expression expression = iHandlerActivation.getExpression();
        if (expression == null) {
            return true;
        }
        return expression.evaluate(iEvaluationContext) == EvaluationResult.TRUE;
    }

    public IEvaluationContext createContextSnapshot(boolean bl) {
        IEvaluationContext iEvaluationContext = this.getCurrentState();
        EvaluationContext evaluationContext = null;
        if (bl) {
            evaluationContext = new EvaluationContext(null, iEvaluationContext.getDefaultVariable());
            int n = 0;
            while (n < SELECTION_VARIABLES.length) {
                this.copyVariable((IEvaluationContext)evaluationContext, iEvaluationContext, SELECTION_VARIABLES[n]);
                ++n;
            }
        } else {
            evaluationContext = new EvaluationContext(null, (Object)Collections.EMPTY_LIST);
        }
        ISourceProviderService iSourceProviderService = (ISourceProviderService)this.locator.getService(ISourceProviderService.class);
        ISourceProvider[] iSourceProviderArray = iSourceProviderService.getSourceProviders();
        int n = 0;
        while (n < iSourceProviderArray.length) {
            String[] stringArray = iSourceProviderArray[n].getProvidedSourceNames();
            int n2 = 0;
            while (n2 < stringArray.length) {
                if (!this.isSelectionVariable(stringArray[n2])) {
                    this.copyVariable((IEvaluationContext)evaluationContext, iEvaluationContext, stringArray[n2]);
                }
                ++n2;
            }
            ++n;
        }
        return evaluationContext;
    }

    private boolean isSelectionVariable(String string) {
        int n = 0;
        while (n < SELECTION_VARIABLES.length) {
            if (SELECTION_VARIABLES[n].equals(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private void copyVariable(IEvaluationContext iEvaluationContext, IEvaluationContext iEvaluationContext2, String string) {
        Object object = iEvaluationContext2.getVariable(string);
        if (object != null) {
            iEvaluationContext.addVariable(string, object);
        }
    }

    private void processChangedCommands() {
        long l = 0L;
        if (DEBUG_PERFORMANCE) {
            l = System.currentTimeMillis();
        }
        MultiStatus multiStatus = new MultiStatus("org.eclipse.ui.workbench", 0, "A handler conflict occurred.  This may disable some commands.", null);
        String[] stringArray = this.changedCommandIds.toArray(new String[this.changedCommandIds.size()]);
        this.changedCommandIds.clear();
        int n = 0;
        while (n < stringArray.length) {
            IHandlerActivation iHandlerActivation;
            String string = stringArray[n];
            Object v = this.handlerActivationsByCommandId.get(string);
            if (v instanceof IHandlerActivation) {
                iHandlerActivation = (IHandlerActivation)v;
                this.updateCommand(string, this.evaluate(iHandlerActivation) ? iHandlerActivation : null);
            } else if (v instanceof SortedSet) {
                iHandlerActivation = this.resolveConflicts(string, (SortedSet)v, multiStatus);
                this.updateCommand(string, iHandlerActivation);
            } else {
                this.updateCommand(string, null);
            }
            ++n;
        }
        if (multiStatus.getSeverity() != 0) {
            WorkbenchPlugin.log((IStatus)multiStatus);
        }
        if (DEBUG_PERFORMANCE) {
            long l2 = System.currentTimeMillis() - l;
            int n2 = this.changedCommandIds.size();
            if (n2 > 0) {
                Tracing.printTrace((String)TRACING_COMPONENT, (String)(String.valueOf(n2) + " command ids changed in " + l2 + "ms"));
            }
        }
    }

    protected final boolean evaluate(IEvaluationResultCache iEvaluationResultCache) {
        IEvaluationContext iEvaluationContext = this.getCurrentState();
        return iEvaluationResultCache.evaluate(iEvaluationContext);
    }

    public final IEvaluationContext getCurrentState() {
        return this.getEvaluationService().getCurrentState();
    }

    public void updateShellKludge() {
        ((EvaluationService)this.getEvaluationService()).updateShellKludge();
    }

    public void updateShellKludge(Shell shell) {
        ((EvaluationService)this.getEvaluationService()).updateShellKludge(shell);
    }

    private class HandlerPropertyListener
    implements IPropertyChangeListener {
        private HandlerActivation handler;

        public HandlerPropertyListener(HandlerActivation handlerActivation) {
            this.handler = handlerActivation;
            this.handler.setListener(this);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (this.handler.getCommandId().equals(propertyChangeEvent.getProperty())) {
                boolean bl = false;
                if (propertyChangeEvent.getNewValue() instanceof Boolean) {
                    bl = (Boolean)propertyChangeEvent.getNewValue();
                }
                this.handler.setResult(bl);
                HandlerAuthority.this.changedCommandIds.add(this.handler.getCommandId());
            }
        }
    }
}

