/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.handlers;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringWriter;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.services.EvaluationResultCache;
import org.eclipse.ui.services.IEvaluationReference;

final class HandlerActivation
extends EvaluationResultCache
implements IHandlerActivation {
    private final String commandId;
    private final int depth;
    private final IHandler handler;
    private final IHandlerService handlerService;
    private IEvaluationReference reference = null;
    private IPropertyChangeListener listener = null;

    HandlerActivation(String string, IHandler iHandler, Expression expression, int n, IHandlerService iHandlerService) {
        super(expression);
        if (string == null) {
            throw new NullPointerException("The command identifier for a handler activation cannot be null");
        }
        if (iHandlerService == null) {
            throw new NullPointerException("The handler service for an activation cannot be null");
        }
        this.commandId = string;
        this.depth = n;
        this.handler = iHandler;
        this.handlerService = iHandlerService;
    }

    @Override
    public final void clearActive() {
        this.clearResult();
    }

    public final int compareTo(Object object) {
        int n;
        IHandlerActivation iHandlerActivation = (IHandlerActivation)object;
        int n2 = this.getSourcePriority();
        int n3 = iHandlerActivation.getSourcePriority();
        int n4 = 0;
        int n5 = 0;
        if ((n2 & Integer.MIN_VALUE | n3 & Integer.MIN_VALUE) != 0) {
            n4 = n2 & 1;
            n2 = n2 >> 1 & Integer.MAX_VALUE;
            n5 = n3 & 1;
            n3 = n3 >> 1 & Integer.MAX_VALUE;
        }
        if ((n = n2 - n3) != 0) {
            return n;
        }
        n = n4 - n5;
        if (n != 0) {
            return n;
        }
        int n6 = this.getDepth();
        int n7 = iHandlerActivation.getDepth();
        n = n6 - n7;
        return n;
    }

    @Override
    public final String getCommandId() {
        return this.commandId;
    }

    @Override
    public final int getDepth() {
        return this.depth;
    }

    @Override
    public final IHandler getHandler() {
        return this.handler;
    }

    @Override
    public final IHandlerService getHandlerService() {
        return this.handlerService;
    }

    @Override
    public final boolean isActive(IEvaluationContext iEvaluationContext) {
        return this.evaluate(iEvaluationContext);
    }

    public final String toString() {
        StringWriter stringWriter = new StringWriter();
        BufferedWriter bufferedWriter = new BufferedWriter(stringWriter);
        try {
            bufferedWriter.write("HandlerActivation(commandId=");
            bufferedWriter.write(this.commandId);
            bufferedWriter.write(44);
            bufferedWriter.newLine();
            bufferedWriter.write("\thandler=");
            bufferedWriter.write(this.handler == null ? "" : this.handler.toString());
            bufferedWriter.write(44);
            bufferedWriter.newLine();
            bufferedWriter.write("\texpression=");
            Expression expression = this.getExpression();
            bufferedWriter.write(expression == null ? "" : expression.toString());
            bufferedWriter.write(",sourcePriority=");
            bufferedWriter.write(Integer.toString(this.getSourcePriority()));
            bufferedWriter.write(41);
            bufferedWriter.flush();
        }
        catch (IOException iOException) {}
        return stringWriter.toString();
    }

    public IEvaluationReference getReference() {
        return this.reference;
    }

    public void setReference(IEvaluationReference iEvaluationReference) {
        this.reference = iEvaluationReference;
    }

    public void setListener(IPropertyChangeListener iPropertyChangeListener) {
        this.listener = iPropertyChangeListener;
    }

    public IPropertyChangeListener getListener() {
        return this.listener;
    }
}

