/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.handlers;

import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.services.IEvaluationService;

public class DirtyStateTracker
implements IPartListener,
IWindowListener,
IPropertyListener {
    private final IWorkbench workbench = Workbench.getInstance();

    public DirtyStateTracker() {
        this.workbench.addWindowListener(this);
        IWorkbenchWindow iWorkbenchWindow = this.workbench.getActiveWorkbenchWindow();
        this.register(iWorkbenchWindow);
    }

    public void update() {
        IEvaluationService iEvaluationService = (IEvaluationService)this.workbench.getService(IEvaluationService.class);
        iEvaluationService.requestEvaluation("activePart");
    }

    private void register(IWorkbenchWindow iWorkbenchWindow) {
        if (iWorkbenchWindow == null) {
            return;
        }
        iWorkbenchWindow.getPartService().addPartListener(this);
    }

    @Override
    public void partActivated(IWorkbenchPart iWorkbenchPart) {
        if (iWorkbenchPart instanceof ISaveablePart) {
            iWorkbenchPart.addPropertyListener(this);
        }
    }

    @Override
    public void partBroughtToTop(IWorkbenchPart iWorkbenchPart) {
    }

    @Override
    public void partClosed(IWorkbenchPart iWorkbenchPart) {
        if (iWorkbenchPart instanceof ISaveablePart) {
            iWorkbenchPart.removePropertyListener(this);
        }
    }

    @Override
    public void partDeactivated(IWorkbenchPart iWorkbenchPart) {
    }

    @Override
    public void partOpened(IWorkbenchPart iWorkbenchPart) {
        if (iWorkbenchPart instanceof ISaveablePart) {
            iWorkbenchPart.addPropertyListener(this);
        }
    }

    @Override
    public void windowActivated(IWorkbenchWindow iWorkbenchWindow) {
        this.register(iWorkbenchWindow);
    }

    @Override
    public void windowDeactivated(IWorkbenchWindow iWorkbenchWindow) {
    }

    @Override
    public void windowClosed(IWorkbenchWindow iWorkbenchWindow) {
        iWorkbenchWindow.getPartService().removePartListener(this);
    }

    @Override
    public void windowOpened(IWorkbenchWindow iWorkbenchWindow) {
        this.register(iWorkbenchWindow);
    }

    @Override
    public void propertyChanged(Object object, int n) {
        if (object instanceof ISaveablePart && n == 257) {
            this.update();
        }
    }
}

