/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.handlers;

import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.internal.CycleBaseHandler;
import org.eclipse.ui.internal.PartSite;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.part.PageSwitcher;
import org.eclipse.ui.part.WorkbenchPart;

public class CyclePageHandler
extends CycleBaseHandler {
    private static final int TEXT_LIMIT = 65;
    private PageSwitcher pageSwitcher;
    private LocalResourceManager lrm;

    public CyclePageHandler(PageSwitcher pageSwitcher) {
        this.pageSwitcher = pageSwitcher;
    }

    @Override
    protected void addItems(Table table, WorkbenchPage workbenchPage) {
        Object[] objectArray = this.pageSwitcher.getPages();
        int n = 0;
        while (n < objectArray.length) {
            TableItem tableItem = null;
            tableItem = new TableItem(table, 0);
            ImageDescriptor imageDescriptor = this.pageSwitcher.getImageDescriptor(objectArray[n]);
            if (imageDescriptor != null) {
                if (this.lrm == null) {
                    this.lrm = new LocalResourceManager(JFaceResources.getResources());
                }
                tableItem.setImage(this.lrm.createImage(imageDescriptor));
            }
            tableItem.setData(objectArray[n]);
            String string = this.pageSwitcher.getName(objectArray[n]);
            if (string.length() > 65) {
                string = String.valueOf(string.substring(0, 65)) + "...";
            }
            tableItem.setText(string);
            ++n;
        }
    }

    @Override
    protected int getCurrentItemIndex() {
        return this.pageSwitcher.getCurrentPageIndex();
    }

    @Override
    protected ParameterizedCommand getBackwardCommand() {
        ICommandService iCommandService = (ICommandService)this.window.getWorkbench().getService(ICommandService.class);
        Command command = iCommandService.getCommand("org.eclipse.ui.part.previousPage");
        ParameterizedCommand parameterizedCommand = new ParameterizedCommand(command, null);
        return parameterizedCommand;
    }

    @Override
    protected ParameterizedCommand getForwardCommand() {
        ICommandService iCommandService = (ICommandService)this.window.getWorkbench().getService(ICommandService.class);
        Command command = iCommandService.getCommand("org.eclipse.ui.part.nextPage");
        ParameterizedCommand parameterizedCommand = new ParameterizedCommand(command, null);
        return parameterizedCommand;
    }

    @Override
    protected String getTableHeader(IWorkbenchPart iWorkbenchPart) {
        if (iWorkbenchPart instanceof WorkbenchPart) {
            return ((WorkbenchPart)iWorkbenchPart).getPartName();
        }
        return iWorkbenchPart.getTitle();
    }

    @Override
    public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
        this.gotoDirection = executionEvent.getCommand().getId().equals("org.eclipse.ui.part.nextPage");
        super.execute(executionEvent);
        if (this.lrm != null) {
            this.lrm.dispose();
            this.lrm = null;
        }
        return null;
    }

    @Override
    protected void setDialogLocation(Shell shell, IWorkbenchPart iWorkbenchPart) {
        WorkbenchPart workbenchPart;
        if (shell == null) {
            return;
        }
        Point point = Geometry.centerPoint((Rectangle)shell.getDisplay().getBounds());
        if (iWorkbenchPart != null) {
            workbenchPart = (WorkbenchPart)iWorkbenchPart;
            PartSite partSite = (PartSite)workbenchPart.getSite();
            Control control = partSite.getPane().getControl();
            Rectangle rectangle = control.getBounds();
            Point point2 = Geometry.centerPoint((Rectangle)rectangle);
            point = control.getParent().toDisplay(point2);
        }
        workbenchPart = shell.getBounds();
        point.x -= ((Rectangle)workbenchPart).width / 2;
        point.y -= ((Rectangle)workbenchPart).height / 2;
        shell.setLocation(point);
    }

    public void dispose() {
        super.dispose();
        this.pageSwitcher = null;
    }

    @Override
    protected void activate(IWorkbenchPage iWorkbenchPage, Object object) {
        if (object == null) {
            return;
        }
        this.pageSwitcher.activatePage(object);
    }
}

