/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class ContextMenuHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
        Shell shell = HandlerUtil.getActiveShell(executionEvent);
        Display display = shell == null ? Display.getCurrent() : shell.getDisplay();
        Control control = display.getFocusControl();
        if (control != null) {
            Point point = display.getCursorLocation();
            Event event = new Event();
            event.x = point.x;
            event.y = point.y;
            event.detail = 1;
            control.notifyListeners(35, event);
            if (control.isDisposed()) {
                return null;
            }
            if (!event.doit) {
                return null;
            }
            Menu menu = control.getMenu();
            if (menu != null && !menu.isDisposed()) {
                if (event.x != point.x || event.y != point.y) {
                    menu.setLocation(event.x, event.y);
                }
                menu.setVisible(true);
            } else {
                Point point2 = control.getSize();
                Point point3 = control.toDisplay(0, 0);
                Event event2 = new Event();
                event2.widget = control;
                if (event.x < point3.x || point3.x + point2.x <= event.x || event.y < point3.y || point3.y + point2.y <= event.y) {
                    Point point4 = control.toDisplay(Geometry.divide((Point)point2, (int)2));
                    event2.x = point4.x;
                    event2.y = point4.y;
                    event2.type = 5;
                    display.post(event2);
                } else {
                    event2.x = event.x;
                    event2.y = event.y;
                }
                event2.button = 3;
                event2.type = 3;
                display.post(event2);
                event2.type = 4;
                display.post(event2);
            }
        }
        return null;
    }
}

