/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.handlers;

import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.CommandEvent;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.ICommandListener;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.State;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.jface.action.AbstractAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.commands.RadioState;
import org.eclipse.jface.commands.ToggleState;
import org.eclipse.jface.menus.TextState;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.commands.ICommandImageService;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.internal.commands.CommandImageService;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.ui.services.IServiceLocator;

public final class CommandLegacyActionWrapper
extends AbstractAction {
    private ParameterizedCommand command;
    private final ICommandListener commandListener = new CommandListener();
    private boolean enabled = true;
    private String id;
    private final IServiceLocator serviceLocator;
    private final String style;

    public CommandLegacyActionWrapper(String string, ParameterizedCommand parameterizedCommand, String string2, IServiceLocator iServiceLocator) {
        if (parameterizedCommand == null) {
            throw new NullPointerException("An action proxy can't be created without a command");
        }
        if (iServiceLocator == null) {
            throw new NullPointerException("An action proxy can't be created without a service locator");
        }
        this.command = parameterizedCommand;
        this.id = string;
        this.style = string2;
        this.serviceLocator = iServiceLocator;
        parameterizedCommand.getCommand().addCommandListener(this.commandListener);
    }

    public final int getAccelerator() {
        KeySequence keySequence;
        KeyStroke[] keyStrokeArray;
        String string = this.getActionDefinitionId();
        IBindingService iBindingService = (IBindingService)this.serviceLocator.getService(IBindingService.class);
        TriggerSequence triggerSequence = iBindingService.getBestActiveBindingFor(string);
        if (triggerSequence instanceof KeySequence && (keyStrokeArray = (keySequence = (KeySequence)triggerSequence).getKeyStrokes()).length == 1) {
            KeyStroke keyStroke = keyStrokeArray[0];
            return keyStroke.getModifierKeys() | keyStroke.getNaturalKey();
        }
        return 0;
    }

    public final String getActionDefinitionId() {
        return this.command.getId();
    }

    public final String getDescription() {
        try {
            return this.command.getCommand().getDescription();
        }
        catch (NotDefinedException notDefinedException) {
            return null;
        }
    }

    public final ImageDescriptor getDisabledImageDescriptor() {
        String string = this.getActionDefinitionId();
        ICommandImageService iCommandImageService = (ICommandImageService)this.serviceLocator.getService(ICommandImageService.class);
        return iCommandImageService.getImageDescriptor(string, 1, this.style);
    }

    public final HelpListener getHelpListener() {
        return null;
    }

    public final ImageDescriptor getHoverImageDescriptor() {
        String string = this.getActionDefinitionId();
        ICommandImageService iCommandImageService = (ICommandImageService)this.serviceLocator.getService(ICommandImageService.class);
        return iCommandImageService.getImageDescriptor(string, 2, this.style);
    }

    public final String getId() {
        return this.id;
    }

    public final ImageDescriptor getImageDescriptor() {
        String string = this.getActionDefinitionId();
        ICommandImageService iCommandImageService = (ICommandImageService)this.serviceLocator.getService(ICommandImageService.class);
        return iCommandImageService.getImageDescriptor(string, this.style);
    }

    public final IMenuCreator getMenuCreator() {
        return null;
    }

    public final int getStyle() {
        State state = this.command.getCommand().getState("STYLE");
        if (state instanceof RadioState) {
            return 8;
        }
        if (state instanceof ToggleState) {
            return 2;
        }
        return 1;
    }

    public final String getText() {
        try {
            return this.command.getName();
        }
        catch (NotDefinedException notDefinedException) {
            return null;
        }
    }

    public final String getToolTipText() {
        return this.getDescription();
    }

    public final boolean isChecked() {
        State state = this.command.getCommand().getState("STYLE");
        if (state instanceof ToggleState) {
            Boolean bl = (Boolean)state.getValue();
            return bl;
        }
        return false;
    }

    public final boolean isEnabled() {
        Command command = this.command.getCommand();
        return command.isEnabled() && this.enabled;
    }

    public final boolean isEnabledDisregardingCommand() {
        return this.enabled;
    }

    public final boolean isHandled() {
        Command command = this.command.getCommand();
        return command.isHandled();
    }

    public final void run() {
        this.runWithEvent(null);
    }

    public final void runWithEvent(Event event) {
        Command command = this.command.getCommand();
        ExecutionEvent executionEvent = new ExecutionEvent(this.command.getCommand(), this.command.getParameterMap(), (Object)event, null);
        try {
            command.execute(executionEvent);
            this.firePropertyChange("result", null, Boolean.TRUE);
        }
        catch (NotHandledException notHandledException) {
            this.firePropertyChange("result", null, Boolean.FALSE);
        }
        catch (ExecutionException executionException) {
            this.firePropertyChange("result", null, Boolean.FALSE);
        }
    }

    public final void setAccelerator(int n) {
    }

    public final void setActionDefinitionId(String string) {
        boolean bl = this.isChecked();
        String string2 = this.getDescription();
        boolean bl2 = this.isEnabled();
        boolean bl3 = this.isHandled();
        ImageDescriptor imageDescriptor = this.getImageDescriptor();
        ImageDescriptor imageDescriptor2 = this.getDisabledImageDescriptor();
        ImageDescriptor imageDescriptor3 = this.getHoverImageDescriptor();
        String string3 = this.getText();
        Command command = this.command.getCommand();
        command.removeCommandListener(this.commandListener);
        ICommandService iCommandService = (ICommandService)this.serviceLocator.getService(ICommandService.class);
        Command command2 = iCommandService.getCommand(string);
        this.command = new ParameterizedCommand(command2, null);
        command2.addCommandListener(this.commandListener);
        boolean bl4 = this.isChecked();
        String string4 = this.getDescription();
        boolean bl5 = this.isEnabled();
        boolean bl6 = this.isHandled();
        ImageDescriptor imageDescriptor4 = this.getImageDescriptor();
        ImageDescriptor imageDescriptor5 = this.getDisabledImageDescriptor();
        ImageDescriptor imageDescriptor6 = this.getHoverImageDescriptor();
        String string5 = this.getText();
        if (bl4 != bl) {
            if (bl) {
                this.firePropertyChange("checked", Boolean.TRUE, Boolean.FALSE);
            } else {
                this.firePropertyChange("checked", Boolean.FALSE, Boolean.TRUE);
            }
        }
        if (!Util.equals((Object)string2, (Object)string4)) {
            this.firePropertyChange("description", string2, string4);
            this.firePropertyChange("toolTipText", string2, string4);
        }
        if (bl5 != bl2) {
            if (bl2) {
                this.firePropertyChange("enabled", Boolean.TRUE, Boolean.FALSE);
            } else {
                this.firePropertyChange("enabled", Boolean.FALSE, Boolean.TRUE);
            }
        }
        if (bl6 != bl3) {
            if (bl3) {
                this.firePropertyChange("handled", Boolean.TRUE, Boolean.FALSE);
            } else {
                this.firePropertyChange("handled", Boolean.FALSE, Boolean.TRUE);
            }
        }
        if (!Util.equals((Object)imageDescriptor, (Object)imageDescriptor4)) {
            this.firePropertyChange("image", imageDescriptor, imageDescriptor4);
        }
        if (!Util.equals((Object)imageDescriptor2, (Object)imageDescriptor5)) {
            this.firePropertyChange("image", imageDescriptor2, imageDescriptor5);
        }
        if (!Util.equals((Object)imageDescriptor3, (Object)imageDescriptor6)) {
            this.firePropertyChange("image", imageDescriptor3, imageDescriptor6);
        }
        if (!Util.equals((Object)string3, (Object)string5)) {
            this.firePropertyChange("text", string3, string5);
        }
    }

    public final void setChecked(boolean bl) {
        Boolean bl2;
        State state = this.command.getCommand().getState("STYLE");
        if (state instanceof ToggleState && bl != (bl2 = (Boolean)state.getValue())) {
            if (bl) {
                state.setValue((Object)Boolean.TRUE);
            } else {
                state.setValue((Object)Boolean.FALSE);
            }
        }
    }

    public final void setDescription(String string) {
        String string2;
        State state = this.command.getCommand().getState("DESCRIPTION");
        if (state instanceof TextState && !Util.equals((Object)string, (Object)(string2 = (String)state.getValue()))) {
            state.setValue((Object)string);
        }
    }

    public final void setDisabledImageDescriptor(ImageDescriptor imageDescriptor) {
        String string = this.getActionDefinitionId();
        ICommandImageService iCommandImageService = (ICommandImageService)this.serviceLocator.getService(ICommandImageService.class);
        if (iCommandImageService instanceof CommandImageService) {
            ((CommandImageService)iCommandImageService).bind(string, 1, this.style, imageDescriptor);
        }
    }

    public final void setEnabled(boolean bl) {
        if (bl != this.enabled) {
            Boolean bl2 = this.enabled ? Boolean.TRUE : Boolean.FALSE;
            Boolean bl3 = bl ? Boolean.TRUE : Boolean.FALSE;
            this.enabled = bl;
            this.firePropertyChange("enabled", bl2, bl3);
        }
    }

    public final void setHelpListener(HelpListener helpListener) {
    }

    public final void setHoverImageDescriptor(ImageDescriptor imageDescriptor) {
        String string = this.getActionDefinitionId();
        ICommandImageService iCommandImageService = (ICommandImageService)this.serviceLocator.getService(ICommandImageService.class);
        if (iCommandImageService instanceof CommandImageService) {
            ((CommandImageService)iCommandImageService).bind(string, 2, this.style, imageDescriptor);
        }
    }

    public final void setId(String string) {
        this.id = string;
    }

    public final void setImageDescriptor(ImageDescriptor imageDescriptor) {
        String string = this.getActionDefinitionId();
        ICommandImageService iCommandImageService = (ICommandImageService)this.serviceLocator.getService(ICommandImageService.class);
        if (iCommandImageService instanceof CommandImageService) {
            ((CommandImageService)iCommandImageService).bind(string, 0, this.style, imageDescriptor);
        }
    }

    public final void setMenuCreator(IMenuCreator iMenuCreator) {
    }

    public final void setText(String string) {
        String string2;
        State state = this.command.getCommand().getState("NAME");
        if (state instanceof TextState && !Util.equals((Object)string, (Object)(string2 = (String)state.getValue()))) {
            state.setValue((Object)string);
        }
    }

    public final void setToolTipText(String string) {
        this.setDescription(string);
    }

    private final class CommandListener
    implements ICommandListener {
        private CommandListener() {
        }

        public final void commandChanged(CommandEvent commandEvent) {
            String string;
            Command command = commandEvent.getCommand();
            if (commandEvent.isNameChanged()) {
                string = null;
                if (command.isDefined()) {
                    try {
                        string = command.getName();
                    }
                    catch (NotDefinedException notDefinedException) {}
                }
                CommandLegacyActionWrapper.this.firePropertyChange("text", null, string);
            }
            if (commandEvent.isDescriptionChanged()) {
                string = null;
                if (command.isDefined()) {
                    try {
                        string = command.getDescription();
                    }
                    catch (NotDefinedException notDefinedException) {}
                }
                CommandLegacyActionWrapper.this.firePropertyChange("description", null, string);
                CommandLegacyActionWrapper.this.firePropertyChange("toolTipText", null, string);
            }
            if (commandEvent.isHandledChanged()) {
                if (command.isHandled()) {
                    CommandLegacyActionWrapper.this.firePropertyChange("handled", Boolean.FALSE, Boolean.TRUE);
                } else {
                    CommandLegacyActionWrapper.this.firePropertyChange("handled", Boolean.TRUE, Boolean.FALSE);
                }
            }
        }
    }
}

