/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.handlers;

import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.internal.Perspective;
import org.eclipse.ui.internal.WorkbenchPage;

public class ClosePerspectiveHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
        WorkbenchPage workbenchPage;
        IWorkbenchWindow iWorkbenchWindow = HandlerUtil.getActiveWorkbenchWindow(executionEvent);
        if (iWorkbenchWindow != null && (workbenchPage = (WorkbenchPage)iWorkbenchWindow.getActivePage()) != null) {
            Map map = executionEvent.getParameters();
            String string = (String)map.get("org.eclipse.ui.window.closePerspective.perspectiveId");
            if (string == null) {
                workbenchPage.closePerspective(workbenchPage.getPerspective(), true, true);
            } else {
                IPerspectiveDescriptor iPerspectiveDescriptor = iWorkbenchWindow.getWorkbench().getPerspectiveRegistry().findPerspectiveWithId(string);
                if (iPerspectiveDescriptor != null) {
                    workbenchPage.closePerspective(iPerspectiveDescriptor, true, true);
                }
            }
        }
        return null;
    }

    public static void closePerspective(WorkbenchPage workbenchPage, Perspective perspective) {
        if (workbenchPage != null && perspective != null) {
            workbenchPage.closePerspective(perspective.getDesc(), true, true);
        }
    }
}

