/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.handlers;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionInfo;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.AbstractEvaluationHandler;
import org.eclipse.ui.internal.InternalHandlerUtil;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.util.Util;

public class CloseAllSavedHandler
extends AbstractEvaluationHandler {
    private Expression enabledWhen;
    private IWorkbenchPage page;

    @Override
    protected Expression getEnabledWhenExpression() {
        if (this.enabledWhen == null) {
            this.enabledWhen = new Expression(){

                public EvaluationResult evaluate(IEvaluationContext iEvaluationContext) {
                    return CloseAllSavedHandler.this.evaluate(iEvaluationContext);
                }

                public void collectExpressionInfo(ExpressionInfo expressionInfo) {
                    expressionInfo.addVariableNameAccess("activePart");
                }
            };
        }
        return this.enabledWhen;
    }

    private EvaluationResult evaluate(IEvaluationContext iEvaluationContext) {
        IWorkbenchWindow iWorkbenchWindow = InternalHandlerUtil.getActiveWorkbenchWindow(iEvaluationContext);
        this.setWindow(iWorkbenchWindow);
        return iWorkbenchWindow != null && iWorkbenchWindow.getActivePage() != null ? EvaluationResult.TRUE : EvaluationResult.FALSE;
    }

    private void setWindow(IWorkbenchWindow iWorkbenchWindow) {
        if (Util.equals(this.page, iWorkbenchWindow.getActivePage())) {
            return;
        }
        this.page = iWorkbenchWindow.getActivePage();
        this.update();
    }

    public IWorkbenchPage getActivePage() {
        return this.page;
    }

    public Object execute(ExecutionEvent executionEvent) {
        IWorkbenchPage iWorkbenchPage = this.getActivePage();
        if (iWorkbenchPage != null) {
            ((WorkbenchPage)iWorkbenchPage).closeAllSavedEditors();
        }
        return null;
    }

    protected void update() {
        IWorkbenchPage iWorkbenchPage = this.getActivePage();
        if (iWorkbenchPage == null) {
            this.setEnabled(false);
            return;
        }
        IEditorReference[] iEditorReferenceArray = iWorkbenchPage.getEditorReferences();
        int n = 0;
        while (n < iEditorReferenceArray.length) {
            if (!iEditorReferenceArray[n].isDirty()) {
                this.setEnabled(true);
                return;
            }
            ++n;
        }
        this.setEnabled(false);
    }
}

