/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.handlers;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.IHandler2;
import org.eclipse.core.commands.IHandlerListener;
import org.eclipse.core.commands.IObjectWithState;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.State;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IActionDelegate2;
import org.eclipse.ui.IActionDelegateWithEvent;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.INullSelectionListener;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.handlers.CommandLegacyActionWrapper;

public final class ActionDelegateHandlerProxy
implements ISelectionListener,
ISelectionChangedListener,
INullSelectionListener,
IHandler2,
IObjectWithState,
IPartListener2 {
    private CommandLegacyActionWrapper action;
    private String actionId;
    private ParameterizedCommand command;
    private ISelection currentSelection;
    private IActionDelegate delegate;
    private IEditorActionDelegate editorDelegate = null;
    private IViewActionDelegate viewDelegate = null;
    private IObjectActionDelegate objectDelegate = null;
    private IWorkbenchWindowActionDelegate windowDelegate = null;
    private IWorkbenchPart currentPart = null;
    private String delegateAttributeName;
    private IConfigurationElement element;
    private final Expression enabledWhenExpression;
    private transient ListenerList listenerList = null;
    private final String style;
    private final String viewId;
    private final IWorkbenchWindow window;

    public ActionDelegateHandlerProxy(IConfigurationElement iConfigurationElement, String string, String string2, ParameterizedCommand parameterizedCommand, IWorkbenchWindow iWorkbenchWindow, String string3, Expression expression, String string4) {
        if (iConfigurationElement == null) {
            throw new NullPointerException("The configuration element backing a handler proxy cannot be null");
        }
        if (string == null) {
            throw new NullPointerException("The attribute containing the action delegate must be known");
        }
        if (iWorkbenchWindow == null) {
            throw new NullPointerException("The workbench window for a delegate must not be null");
        }
        this.element = iConfigurationElement;
        this.enabledWhenExpression = expression;
        this.delegateAttributeName = string;
        this.window = iWorkbenchWindow;
        this.command = parameterizedCommand;
        this.actionId = string2;
        this.style = string3;
        this.viewId = string4;
    }

    public final void addHandlerListener(IHandlerListener iHandlerListener) {
        if (this.listenerList == null) {
            this.listenerList = new ListenerList(1);
        }
        this.listenerList.add((Object)iHandlerListener);
    }

    public void addState(String string, State state) {
    }

    public final void dispose() {
        this.disposeDelegate();
    }

    private void disposeDelegate() {
        IActionDelegate iActionDelegate = this.getDelegate();
        if (iActionDelegate instanceof IWorkbenchWindowActionDelegate) {
            IWorkbenchWindowActionDelegate iWorkbenchWindowActionDelegate = (IWorkbenchWindowActionDelegate)iActionDelegate;
            iWorkbenchWindowActionDelegate.dispose();
        } else if (iActionDelegate instanceof IActionDelegate2) {
            IActionDelegate2 iActionDelegate2 = (IActionDelegate2)iActionDelegate;
            iActionDelegate2.dispose();
        }
        this.delegate = null;
        this.editorDelegate = null;
        this.objectDelegate = null;
        this.viewDelegate = null;
        this.windowDelegate = null;
        this.currentSelection = null;
    }

    public final Object execute(ExecutionEvent executionEvent) {
        CommandLegacyActionWrapper commandLegacyActionWrapper = this.getAction();
        if (this.loadDelegate() && commandLegacyActionWrapper != null) {
            Object object;
            Object object2 = executionEvent.getTrigger();
            Object object3 = executionEvent.getApplicationContext();
            if (object3 instanceof IEvaluationContext) {
                object = (IEvaluationContext)object3;
                this.updateDelegate((IAction)commandLegacyActionWrapper, (IEvaluationContext)object);
            }
            if (this.delegate instanceof IActionDelegate2 && object2 instanceof Event) {
                object = (IActionDelegate2)this.delegate;
                Event event = (Event)object2;
                object.runWithEvent((IAction)commandLegacyActionWrapper, event);
            } else if (this.delegate instanceof IActionDelegateWithEvent && object2 instanceof Event) {
                object = (IActionDelegateWithEvent)((Object)this.delegate);
                Event event = (Event)object2;
                object.runWithEvent((IAction)commandLegacyActionWrapper, event);
            } else {
                this.delegate.run((IAction)commandLegacyActionWrapper);
            }
        }
        return null;
    }

    private void updateDelegate(IAction iAction, IEvaluationContext iEvaluationContext) {
        Object object;
        if (iAction == null || this.delegate == null) {
            return;
        }
        if (this.editorDelegate != null) {
            object = iEvaluationContext.getVariable("activeEditor");
            if (object != IEvaluationContext.UNDEFINED_VARIABLE) {
                this.editorDelegate.setActiveEditor(iAction, (IEditorPart)object);
            }
            this.updateActivePart(object == IEvaluationContext.UNDEFINED_VARIABLE ? null : (IWorkbenchPart)object);
        } else if (this.objectDelegate != null) {
            object = iEvaluationContext.getVariable("activePart");
            if (object != IEvaluationContext.UNDEFINED_VARIABLE) {
                this.objectDelegate.setActivePart(iAction, (IWorkbenchPart)object);
            }
            this.updateActivePart(object == IEvaluationContext.UNDEFINED_VARIABLE ? null : (IWorkbenchPart)object);
        }
        object = this.getCurrentSelection(iEvaluationContext);
        this.currentSelection = object instanceof ISelection ? (ISelection)object : null;
        if (this.delegate != null) {
            this.delegate.selectionChanged(iAction, this.currentSelection);
        }
    }

    private void updateActivePart(IWorkbenchPart iWorkbenchPart) {
        if (this.currentPart == iWorkbenchPart) {
            return;
        }
        if (this.currentPart != null) {
            this.currentPart.getSite().getPage().removePartListener(this);
        }
        if (iWorkbenchPart != null) {
            iWorkbenchPart.getSite().getPage().addPartListener(this);
        } else {
            this.selectionChanged((ISelection)StructuredSelection.EMPTY);
            this.disposeDelegate();
            if (this.action != null) {
                this.action.setEnabled(true);
            }
        }
        this.currentPart = iWorkbenchPart;
    }

    private Object getCurrentSelection(IEvaluationContext iEvaluationContext) {
        Object object = iEvaluationContext.getVariable("activeMenuEditorInput");
        if (!(object != null && object != IEvaluationContext.UNDEFINED_VARIABLE || (object = iEvaluationContext.getVariable("activeMenuSelection")) != null && object != IEvaluationContext.UNDEFINED_VARIABLE)) {
            object = iEvaluationContext.getVariable("selection");
        }
        return object;
    }

    private final CommandLegacyActionWrapper getAction() {
        if (this.action == null) {
            this.action = new CommandLegacyActionWrapper(this.actionId, this.command, this.style, this.window);
            this.action.addPropertyChangeListener(new IPropertyChangeListener(){

                public final void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                }
            });
        }
        return this.action;
    }

    private final IActionDelegate getDelegate() {
        return this.delegate;
    }

    public State getState(String string) {
        return null;
    }

    public String[] getStateIds() {
        return null;
    }

    public final void handleStateChange(State state, Object object) {
    }

    private final boolean initDelegate() {
        Object object;
        IEditorPart iEditorPart;
        IWorkbenchPart iWorkbenchPart;
        IWorkbenchPage iWorkbenchPage = this.window.getActivePage();
        if (iWorkbenchPage == null) {
            iWorkbenchPart = null;
            iEditorPart = null;
        } else {
            iWorkbenchPart = iWorkbenchPage.getActivePart();
            iEditorPart = iWorkbenchPage.getActiveEditor();
        }
        final IActionDelegate iActionDelegate = this.getDelegate();
        CommandLegacyActionWrapper commandLegacyActionWrapper = this.getAction();
        if (this.viewId != null && iWorkbenchPage != null && this.viewDelegate != null && (object = iWorkbenchPage.findView(this.viewId)) == null) {
            return false;
        }
        object = new ISafeRunnable((IAction)commandLegacyActionWrapper, iWorkbenchPart, iEditorPart, iWorkbenchPage){
            private final /* synthetic */ IAction val$action;
            private final /* synthetic */ IWorkbenchPart val$activePart;
            private final /* synthetic */ IEditorPart val$activeEditor;
            private final /* synthetic */ IWorkbenchPage val$page;
            {
                this.val$action = iAction;
                this.val$activePart = iWorkbenchPart;
                this.val$activeEditor = iEditorPart;
                this.val$page = iWorkbenchPage;
            }

            public final void handleException(Throwable throwable) {
            }

            public final void run() {
                Object object;
                if (iActionDelegate instanceof IActionDelegate2) {
                    object = (IActionDelegate2)iActionDelegate;
                    object.init(this.val$action);
                }
                if (ActionDelegateHandlerProxy.this.objectDelegate != null && this.val$activePart != null) {
                    ActionDelegateHandlerProxy.this.objectDelegate.setActivePart(this.val$action, this.val$activePart);
                    ActionDelegateHandlerProxy.this.updateActivePart(this.val$activePart);
                } else if (ActionDelegateHandlerProxy.this.editorDelegate != null) {
                    ActionDelegateHandlerProxy.this.editorDelegate.setActiveEditor(this.val$action, this.val$activeEditor);
                    ActionDelegateHandlerProxy.this.updateActivePart(this.val$activeEditor);
                } else if (ActionDelegateHandlerProxy.this.viewId != null && this.val$page != null && ActionDelegateHandlerProxy.this.viewDelegate != null) {
                    object = this.val$page.findView(ActionDelegateHandlerProxy.this.viewId);
                    ActionDelegateHandlerProxy.this.viewDelegate.init((IViewPart)object);
                } else if (ActionDelegateHandlerProxy.this.windowDelegate != null) {
                    ActionDelegateHandlerProxy.this.windowDelegate.init(ActionDelegateHandlerProxy.this.window);
                }
            }
        };
        SafeRunner.run((ISafeRunnable)object);
        return true;
    }

    public void setEnabled(Object object) {
        if (!(object instanceof IEvaluationContext)) {
            return;
        }
        IEvaluationContext iEvaluationContext = (IEvaluationContext)object;
        CommandLegacyActionWrapper commandLegacyActionWrapper = this.getAction();
        if (this.enabledWhenExpression != null) {
            try {
                EvaluationResult evaluationResult = this.enabledWhenExpression.evaluate(iEvaluationContext);
                if (commandLegacyActionWrapper != null) {
                    commandLegacyActionWrapper.setEnabled(evaluationResult != EvaluationResult.FALSE);
                }
            }
            catch (CoreException coreException) {
                StringBuffer stringBuffer = new StringBuffer("An exception occurred while evaluating the enabledWhen expression for ");
                if (this.delegate != null) {
                    stringBuffer.append(this.delegate);
                } else {
                    stringBuffer.append(this.element.getAttribute(this.delegateAttributeName));
                }
                stringBuffer.append("' could not be loaded");
                Status status = new Status(2, WorkbenchPlugin.PI_WORKBENCH, 0, coreException.getMessage(), (Throwable)coreException);
                WorkbenchPlugin.log(stringBuffer.toString(), (IStatus)status);
                return;
            }
        }
        this.updateDelegate((IAction)commandLegacyActionWrapper, iEvaluationContext);
    }

    public final boolean isEnabled() {
        return this.action == null || this.action.isEnabledDisregardingCommand();
    }

    public final boolean isHandled() {
        return true;
    }

    private final boolean isSafeToLoadDelegate() {
        return false;
    }

    private final boolean loadDelegate() {
        if (this.delegate == null) {
            Object object;
            block21: {
                Object object2;
                if (this.viewId != null) {
                    object2 = this.window.getActivePage();
                    if (object2 != null) {
                        object = object2.findView(this.viewId);
                        if (object == null) {
                            return false;
                        }
                    } else {
                        return false;
                    }
                }
                this.delegate = (IActionDelegate)this.element.createExecutableExtension(this.delegateAttributeName);
                object2 = this.element.getDeclaringExtension().getExtensionPointUniqueIdentifier();
                if ("org.eclipse.ui.actionSets".equals(object2) && this.delegate instanceof IWorkbenchWindowActionDelegate) {
                    this.windowDelegate = (IWorkbenchWindowActionDelegate)this.delegate;
                } else if ("org.eclipse.ui.editorActions".equals(object2) && this.delegate instanceof IEditorActionDelegate) {
                    this.editorDelegate = (IEditorActionDelegate)this.delegate;
                } else if ("org.eclipse.ui.viewActions".equals(object2) && this.delegate instanceof IViewActionDelegate) {
                    this.viewDelegate = (IViewActionDelegate)this.delegate;
                } else if ("org.eclipse.ui.popupMenus".equals(object2)) {
                    object = (IConfigurationElement)this.element.getParent();
                    if ("objectContribution".equals(object.getName()) && this.delegate instanceof IObjectActionDelegate) {
                        this.objectDelegate = (IObjectActionDelegate)this.delegate;
                    } else if (this.viewId == null && this.delegate instanceof IEditorActionDelegate) {
                        this.editorDelegate = (IEditorActionDelegate)this.delegate;
                    } else if (this.viewId != null && this.delegate instanceof IViewActionDelegate) {
                        this.viewDelegate = (IViewActionDelegate)this.delegate;
                    }
                }
                if (!this.initDelegate()) break block21;
                return true;
            }
            try {
                this.delegate = null;
                this.objectDelegate = null;
                this.viewDelegate = null;
                this.editorDelegate = null;
                this.windowDelegate = null;
                return false;
            }
            catch (ClassCastException classCastException) {
                object = new Status(4, WorkbenchPlugin.PI_WORKBENCH, 0, "The proxied delegate was the wrong class", (Throwable)classCastException);
                WorkbenchPlugin.log("The proxied delegate was the wrong class", (IStatus)object);
                return false;
            }
            catch (CoreException coreException) {
                object = "The proxied delegate for '" + this.element.getAttribute(this.delegateAttributeName) + "' could not be loaded";
                Status status = new Status(4, WorkbenchPlugin.PI_WORKBENCH, 0, (String)object, (Throwable)coreException);
                WorkbenchPlugin.log((String)object, (IStatus)status);
                return false;
            }
        }
        return true;
    }

    private final void refreshEnablement() {
        IActionDelegate iActionDelegate = this.getDelegate();
        CommandLegacyActionWrapper commandLegacyActionWrapper = this.getAction();
        if (iActionDelegate != null && commandLegacyActionWrapper != null) {
            iActionDelegate.selectionChanged((IAction)commandLegacyActionWrapper, this.currentSelection);
        }
    }

    public void removeHandlerListener(IHandlerListener iHandlerListener) {
        if (this.listenerList != null) {
            this.listenerList.remove((Object)iHandlerListener);
            if (this.listenerList.isEmpty()) {
                this.listenerList = null;
            }
        }
    }

    public void removeState(String string) {
    }

    private final void selectionChanged(ISelection iSelection) {
        IActionDelegate iActionDelegate;
        this.currentSelection = iSelection;
        if (this.currentSelection == null) {
            this.currentSelection = StructuredSelection.EMPTY;
        }
        if ((iActionDelegate = this.getDelegate()) == null && this.isSafeToLoadDelegate()) {
            this.loadDelegate();
        }
        this.refreshEnablement();
    }

    @Override
    public final void selectionChanged(IWorkbenchPart iWorkbenchPart, ISelection iSelection) {
        this.selectionChanged(iSelection);
    }

    public final void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        ISelection iSelection = selectionChangedEvent.getSelection();
        this.selectionChanged(iSelection);
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ActionDelegateHandlerProxy(");
        stringBuffer.append(this.getDelegate());
        if (this.element != null) {
            stringBuffer.append(',');
            try {
                String string = this.element.getAttribute(this.delegateAttributeName);
                stringBuffer.append(string);
            }
            catch (InvalidRegistryObjectException invalidRegistryObjectException) {
                stringBuffer.append(this.actionId);
            }
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    @Override
    public void partActivated(IWorkbenchPartReference iWorkbenchPartReference) {
    }

    @Override
    public void partBroughtToTop(IWorkbenchPartReference iWorkbenchPartReference) {
    }

    @Override
    public void partClosed(IWorkbenchPartReference iWorkbenchPartReference) {
        if (this.currentPart != null && iWorkbenchPartReference.getPart(false) == this.currentPart) {
            this.updateActivePart(null);
        }
    }

    @Override
    public void partDeactivated(IWorkbenchPartReference iWorkbenchPartReference) {
    }

    @Override
    public void partHidden(IWorkbenchPartReference iWorkbenchPartReference) {
    }

    @Override
    public void partInputChanged(IWorkbenchPartReference iWorkbenchPartReference) {
    }

    @Override
    public void partOpened(IWorkbenchPartReference iWorkbenchPartReference) {
    }

    @Override
    public void partVisible(IWorkbenchPartReference iWorkbenchPartReference) {
    }
}

