/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.handlers;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionInfo;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.internal.AbstractEvaluationHandler;
import org.eclipse.ui.internal.InternalHandlerUtil;
import org.eclipse.ui.internal.handlers.DirtyStateTracker;
import org.eclipse.ui.internal.util.Util;

public abstract class AbstractSaveHandler
extends AbstractEvaluationHandler {
    protected static DirtyStateTracker dirtyStateTracker;
    private Expression enabledWhen;

    public AbstractSaveHandler() {
        if (dirtyStateTracker == null) {
            dirtyStateTracker = new DirtyStateTracker();
        }
    }

    @Override
    protected Expression getEnabledWhenExpression() {
        if (this.enabledWhen == null) {
            this.enabledWhen = new Expression(){

                public EvaluationResult evaluate(IEvaluationContext iEvaluationContext) {
                    return AbstractSaveHandler.this.evaluate(iEvaluationContext);
                }

                public void collectExpressionInfo(ExpressionInfo expressionInfo) {
                    expressionInfo.addVariableNameAccess("activePart");
                }
            };
        }
        return this.enabledWhen;
    }

    protected abstract EvaluationResult evaluate(IEvaluationContext var1);

    protected ISaveablePart getSaveablePart(IEvaluationContext iEvaluationContext) {
        IWorkbenchPart iWorkbenchPart = InternalHandlerUtil.getActivePart(iEvaluationContext);
        if (iWorkbenchPart instanceof ISaveablePart) {
            return (ISaveablePart)((Object)iWorkbenchPart);
        }
        return InternalHandlerUtil.getActiveEditor(iEvaluationContext);
    }

    protected ISaveablePart getSaveablePart(ExecutionEvent executionEvent) {
        IWorkbenchPart iWorkbenchPart = HandlerUtil.getActivePart(executionEvent);
        if (iWorkbenchPart instanceof ISaveablePart) {
            return (ISaveablePart)((Object)iWorkbenchPart);
        }
        ISaveablePart iSaveablePart = (ISaveablePart)Util.getAdapter(iWorkbenchPart, ISaveablePart.class);
        if (iSaveablePart != null) {
            return iSaveablePart;
        }
        return HandlerUtil.getActiveEditor(executionEvent);
    }
}

