/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.expressions;

import java.util.Collection;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionInfo;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.expressions.WorkbenchWindowExpression;

public final class LegacyViewerContributionExpression
extends WorkbenchWindowExpression {
    private static final int HASH_INITIAL = LegacyViewerContributionExpression.class.getName().hashCode();
    private final Expression expression;
    private final String targetId;

    public LegacyViewerContributionExpression(String string, IWorkbenchWindow iWorkbenchWindow, Expression expression) {
        super(iWorkbenchWindow);
        if (string == null) {
            throw new NullPointerException("The targetId cannot be null");
        }
        this.targetId = string;
        this.expression = expression;
    }

    @Override
    public final void collectExpressionInfo(ExpressionInfo expressionInfo) {
        super.collectExpressionInfo(expressionInfo);
        expressionInfo.addVariableNameAccess("activeMenu");
        if (this.expression != null) {
            this.expression.collectExpressionInfo(expressionInfo);
        }
    }

    @Override
    protected final int computeHashCode() {
        int n = HASH_INITIAL * 89 + LegacyViewerContributionExpression.hashCode((Object)this.getWindow());
        n = n * 89 + LegacyViewerContributionExpression.hashCode((Object)this.expression);
        n = n * 89 + LegacyViewerContributionExpression.hashCode((Object)this.targetId);
        return n;
    }

    @Override
    public final boolean equals(Object object) {
        if (object instanceof LegacyViewerContributionExpression) {
            LegacyViewerContributionExpression legacyViewerContributionExpression = (LegacyViewerContributionExpression)((Object)object);
            return LegacyViewerContributionExpression.equals((Object)this.targetId, (Object)legacyViewerContributionExpression.targetId) && LegacyViewerContributionExpression.equals((Object)this.expression, (Object)legacyViewerContributionExpression.expression) && LegacyViewerContributionExpression.equals((Object)this.getWindow(), (Object)legacyViewerContributionExpression.getWindow());
        }
        return false;
    }

    @Override
    public final EvaluationResult evaluate(IEvaluationContext iEvaluationContext) throws CoreException {
        Collection collection;
        EvaluationResult evaluationResult = super.evaluate(iEvaluationContext);
        if (evaluationResult == EvaluationResult.FALSE) {
            return evaluationResult;
        }
        Object object = iEvaluationContext.getVariable("activeMenu");
        if (object instanceof String) {
            String string = (String)object;
            if (this.targetId.equals(string)) {
                if (this.expression == null) {
                    return EvaluationResult.TRUE;
                }
                return this.expression.evaluate(iEvaluationContext);
            }
        } else if (object instanceof Collection && (collection = (Collection)object).contains(this.targetId)) {
            if (this.expression == null) {
                return EvaluationResult.TRUE;
            }
            return this.expression.evaluate(iEvaluationContext);
        }
        return EvaluationResult.FALSE;
    }

    @Override
    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ViewerContributionExpression(");
        stringBuffer.append(this.targetId);
        stringBuffer.append(',');
        stringBuffer.append(this.expression);
        stringBuffer.append(',');
        stringBuffer.append(this.getWindow());
        stringBuffer.append(')');
        return stringBuffer.toString();
    }
}

