/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.expressions;

import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.ExpressionInfo;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.SelectionEnabler;
import org.eclipse.ui.internal.expressions.WorkbenchWindowExpression;

public final class LegacySelectionEnablerWrapper
extends WorkbenchWindowExpression {
    private static final int HASH_INITIAL = LegacySelectionEnablerWrapper.class.getName().hashCode();
    private final SelectionEnabler enabler;

    public LegacySelectionEnablerWrapper(SelectionEnabler selectionEnabler, IWorkbenchWindow iWorkbenchWindow) {
        super(iWorkbenchWindow);
        if (selectionEnabler == null) {
            throw new NullPointerException("There is no enabler");
        }
        this.enabler = selectionEnabler;
    }

    @Override
    public final void collectExpressionInfo(ExpressionInfo expressionInfo) {
        super.collectExpressionInfo(expressionInfo);
        expressionInfo.markDefaultVariableAccessed();
    }

    @Override
    protected final int computeHashCode() {
        int n = HASH_INITIAL * 89 + LegacySelectionEnablerWrapper.hashCode((Object)this.getWindow());
        n = n * 89 + LegacySelectionEnablerWrapper.hashCode((Object)this.enabler);
        return n;
    }

    @Override
    public final boolean equals(Object object) {
        if (object instanceof LegacySelectionEnablerWrapper) {
            LegacySelectionEnablerWrapper legacySelectionEnablerWrapper = (LegacySelectionEnablerWrapper)((Object)object);
            return LegacySelectionEnablerWrapper.equals((Object)this.enabler, (Object)legacySelectionEnablerWrapper.enabler) && LegacySelectionEnablerWrapper.equals((Object)this.getWindow(), (Object)legacySelectionEnablerWrapper.getWindow());
        }
        return false;
    }

    @Override
    public final EvaluationResult evaluate(IEvaluationContext iEvaluationContext) throws CoreException {
        ISelection iSelection;
        EvaluationResult evaluationResult = super.evaluate(iEvaluationContext);
        if (evaluationResult == EvaluationResult.FALSE) {
            return evaluationResult;
        }
        Object object = iEvaluationContext.getVariable("selection");
        if (object instanceof ISelection && this.enabler.isEnabledForSelection(iSelection = (ISelection)object)) {
            return EvaluationResult.TRUE;
        }
        return EvaluationResult.FALSE;
    }

    @Override
    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("LegacySelectionEnablerWrapper(");
        stringBuffer.append(this.enabler);
        stringBuffer.append(',');
        stringBuffer.append(this.getWindow());
        stringBuffer.append(')');
        return stringBuffer.toString();
    }
}

