/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.expressions;

import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.ExpressionInfo;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.expressions.WorkbenchWindowExpression;
import org.eclipse.ui.internal.registry.IActionSetDescriptor;

public final class LegacyActionSetExpression
extends WorkbenchWindowExpression {
    private static final int HASH_INITIAL = LegacyActionSetExpression.class.getName().hashCode();
    private final String actionSetId;

    public LegacyActionSetExpression(String string, IWorkbenchWindow iWorkbenchWindow) {
        super(iWorkbenchWindow);
        if (string == null) {
            throw new NullPointerException("The action set identifier cannot be null");
        }
        this.actionSetId = string;
    }

    @Override
    public final void collectExpressionInfo(ExpressionInfo expressionInfo) {
        super.collectExpressionInfo(expressionInfo);
        expressionInfo.addVariableNameAccess("activeActionSets");
    }

    protected final int computeHhashCode() {
        int n = HASH_INITIAL * 89 + LegacyActionSetExpression.hashCode((Object)this.getWindow());
        n = n * 89 + LegacyActionSetExpression.hashCode((Object)this.actionSetId);
        return n;
    }

    @Override
    public final boolean equals(Object object) {
        if (object instanceof LegacyActionSetExpression) {
            LegacyActionSetExpression legacyActionSetExpression = (LegacyActionSetExpression)((Object)object);
            return LegacyActionSetExpression.equals((Object)this.actionSetId, (Object)legacyActionSetExpression.actionSetId) && LegacyActionSetExpression.equals((Object)this.getWindow(), (Object)legacyActionSetExpression.getWindow());
        }
        return false;
    }

    @Override
    public final EvaluationResult evaluate(IEvaluationContext iEvaluationContext) throws CoreException {
        EvaluationResult evaluationResult = super.evaluate(iEvaluationContext);
        if (evaluationResult == EvaluationResult.FALSE) {
            return evaluationResult;
        }
        Object object = iEvaluationContext.getVariable("activeActionSets");
        if (object instanceof IActionSetDescriptor[]) {
            IActionSetDescriptor[] iActionSetDescriptorArray = (IActionSetDescriptor[])object;
            int n = 0;
            while (n < iActionSetDescriptorArray.length) {
                IActionSetDescriptor iActionSetDescriptor = iActionSetDescriptorArray[n];
                String string = iActionSetDescriptor.getId();
                if (this.actionSetId.equals(string)) {
                    return EvaluationResult.TRUE;
                }
                ++n;
            }
        }
        return EvaluationResult.FALSE;
    }

    @Override
    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ActionSetExpression(");
        stringBuffer.append(this.actionSetId);
        stringBuffer.append(',');
        stringBuffer.append(this.getWindow());
        stringBuffer.append(')');
        return stringBuffer.toString();
    }
}

