/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.expressions;

import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.ExpressionInfo;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.ActionExpression;
import org.eclipse.ui.internal.expressions.WorkbenchWindowExpression;

public final class LegacyActionExpressionWrapper
extends WorkbenchWindowExpression {
    private static final int HASH_INITIAL = LegacyActionExpressionWrapper.class.getName().hashCode();
    private final ActionExpression expression;

    public LegacyActionExpressionWrapper(ActionExpression actionExpression, IWorkbenchWindow iWorkbenchWindow) {
        super(iWorkbenchWindow);
        if (actionExpression == null) {
            throw new NullPointerException("The action expression cannot be null");
        }
        this.expression = actionExpression;
    }

    @Override
    public final void collectExpressionInfo(ExpressionInfo expressionInfo) {
        super.collectExpressionInfo(expressionInfo);
        expressionInfo.markDefaultVariableAccessed();
    }

    @Override
    protected final int computeHashCode() {
        int n = HASH_INITIAL * 89 + LegacyActionExpressionWrapper.hashCode((Object)this.getWindow());
        n = n * 89 + LegacyActionExpressionWrapper.hashCode((Object)this.expression);
        return n;
    }

    @Override
    public final boolean equals(Object object) {
        if (object instanceof LegacyActionExpressionWrapper) {
            LegacyActionExpressionWrapper legacyActionExpressionWrapper = (LegacyActionExpressionWrapper)((Object)object);
            return LegacyActionExpressionWrapper.equals((Object)this.expression, (Object)legacyActionExpressionWrapper.expression) && LegacyActionExpressionWrapper.equals((Object)this.getWindow(), (Object)legacyActionExpressionWrapper.getWindow());
        }
        return false;
    }

    @Override
    public final EvaluationResult evaluate(IEvaluationContext iEvaluationContext) throws CoreException {
        IStructuredSelection iStructuredSelection;
        EvaluationResult evaluationResult = super.evaluate(iEvaluationContext);
        if (evaluationResult == EvaluationResult.FALSE) {
            return evaluationResult;
        }
        Object object = iEvaluationContext.getVariable("selection");
        if (object instanceof IStructuredSelection ? this.expression.isEnabledFor(iStructuredSelection = (IStructuredSelection)object) : this.expression.isEnabledFor(object)) {
            return EvaluationResult.TRUE;
        }
        return EvaluationResult.FALSE;
    }

    @Override
    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("LegacyActionExpressionWrapper(");
        stringBuffer.append(this.expression);
        stringBuffer.append(',');
        stringBuffer.append(this.getWindow());
        stringBuffer.append(')');
        return stringBuffer.toString();
    }
}

