/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.expressions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionInfo;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;

public abstract class CompositeExpression
extends Expression {
    private static final Expression[] EMPTY_ARRAY = new Expression[0];
    protected List fExpressions;

    public void add(Expression expression) {
        if (this.fExpressions == null) {
            this.fExpressions = new ArrayList(2);
        }
        this.fExpressions.add(expression);
    }

    public Expression[] getChildren() {
        if (this.fExpressions == null) {
            return EMPTY_ARRAY;
        }
        return this.fExpressions.toArray(new Expression[this.fExpressions.size()]);
    }

    protected EvaluationResult evaluateAnd(IEvaluationContext iEvaluationContext) throws CoreException {
        if (this.fExpressions == null) {
            return EvaluationResult.TRUE;
        }
        EvaluationResult evaluationResult = EvaluationResult.TRUE;
        for (Expression expression : this.fExpressions) {
            if ((evaluationResult = evaluationResult.and(expression.evaluate(iEvaluationContext))) != EvaluationResult.FALSE) continue;
            return evaluationResult;
        }
        return evaluationResult;
    }

    protected EvaluationResult evaluateOr(IEvaluationContext iEvaluationContext) throws CoreException {
        if (this.fExpressions == null) {
            return EvaluationResult.TRUE;
        }
        EvaluationResult evaluationResult = EvaluationResult.FALSE;
        for (Expression expression : this.fExpressions) {
            if ((evaluationResult = evaluationResult.or(expression.evaluate(iEvaluationContext))) != EvaluationResult.TRUE) continue;
            return evaluationResult;
        }
        return evaluationResult;
    }

    public void collectExpressionInfo(ExpressionInfo expressionInfo) {
        if (this.fExpressions == null) {
            return;
        }
        for (Expression expression : this.fExpressions) {
            expression.collectExpressionInfo(expressionInfo);
        }
    }
}

