/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dnd;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.dnd.DragUtil;

public class SwtUtil {
    private SwtUtil() {
    }

    public static boolean isDisposed(Control control) {
        return control == null || control.isDisposed();
    }

    public static Control controlThatCovers(Control control) {
        return SwtUtil.controlThatCovers(control, DragUtil.getDisplayBounds(control));
    }

    private static Control controlThatCovers(Control control, Rectangle rectangle) {
        Composite composite = control.getParent();
        if (composite == null || control instanceof Shell) {
            return null;
        }
        Control[] controlArray = composite.getChildren();
        int n = 0;
        while (n < controlArray.length) {
            Rectangle rectangle2;
            Control control2 = controlArray[n];
            if (control2 == control) break;
            if (control2.isVisible() && (rectangle2 = DragUtil.getDisplayBounds(control2)).intersects(rectangle)) {
                return control2;
            }
            ++n;
        }
        return SwtUtil.controlThatCovers((Control)composite, rectangle);
    }

    public static boolean isChild(Control control, Control control2) {
        if (control2 == null) {
            return false;
        }
        if (control2 == control) {
            return true;
        }
        return SwtUtil.isChild(control, (Control)control2.getParent());
    }

    public static boolean isFocusAncestor(Control control) {
        if (control == null) {
            return false;
        }
        Control control2 = Display.getCurrent().getFocusControl();
        if (control2 == null) {
            return false;
        }
        return SwtUtil.isChild(control, control2);
    }

    public static Control findControl(Display display, Point point) {
        Shell[] shellArray = display.getShells();
        return SwtUtil.findControl((Control[])shellArray, point);
    }

    public static Control findControl(Control[] controlArray, Point point) {
        int n = controlArray.length - 1;
        while (n >= 0) {
            Rectangle rectangle;
            Control control = controlArray[n];
            if (!control.isDisposed() && control.isVisible() && (rectangle = DragUtil.getDisplayBounds(control)).contains(point)) {
                Control control2;
                if (control instanceof Composite && (control2 = SwtUtil.findControl((Composite)control, point)) != null) {
                    return control2;
                }
                return control;
            }
            --n;
        }
        return null;
    }

    public static Control[] getAncestors(Control control) {
        return SwtUtil.getAncestors(control, 1);
    }

    private static Control[] getAncestors(Control control, int n) {
        Control[] controlArray = control.getParent() == null ? new Control[n] : SwtUtil.getAncestors((Control)control.getParent(), n + 1);
        controlArray[controlArray.length - n] = control;
        return controlArray;
    }

    public static Control findCommonAncestor(Control control, Control control2) {
        Control[] controlArray = SwtUtil.getAncestors(control);
        Control[] controlArray2 = SwtUtil.getAncestors(control2);
        Control control3 = null;
        int n = 0;
        while (n < Math.min(controlArray.length, controlArray2.length)) {
            Control control4 = controlArray[n];
            if (control4 != controlArray2[n]) break;
            control3 = control4;
            ++n;
        }
        return control3;
    }

    public static Control findControl(Composite composite, Point point) {
        Control[] controlArray = composite.getChildren();
        return SwtUtil.findControl(controlArray, point);
    }

    public static boolean intersectsAnyMonitor(Display display, Rectangle rectangle) {
        Monitor[] monitorArray = display.getMonitors();
        int n = 0;
        while (n < monitorArray.length) {
            Monitor monitor = monitorArray[n];
            if (monitor.getClientArea().intersects(rectangle)) {
                return true;
            }
            ++n;
        }
        return false;
    }
}

