/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dnd;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.themes.ColorUtil;

public class InsertCaret {
    private static final int width = 6;
    private static final int pctInset = 10;
    private Canvas caretControl;
    private Canvas end1;
    private Canvas end2;
    private Color baseColor;
    private Color hilightColor;
    private boolean isHighlight;

    public InsertCaret(Composite composite, Rectangle rectangle, int n, int n2) {
        this.baseColor = composite.getDisplay().getSystemColor(26);
        RGB rGB = composite.getDisplay().getSystemColor(25).getRGB();
        RGB rGB2 = ColorUtil.blend(this.baseColor.getRGB(), rGB);
        this.hilightColor = new Color((Device)composite.getDisplay(), rGB2);
        this.createControl(composite, rectangle, n, n2);
    }

    private void createControl(Composite composite, Rectangle rectangle, int n, int n2) {
        int n3 = rectangle.width / 10;
        int n4 = rectangle.height / 10;
        this.caretControl = new Canvas((Composite)composite.getShell(), 2048);
        this.end1 = new Canvas((Composite)composite.getShell(), 2048);
        this.end1.setSize(6, 6);
        this.end2 = new Canvas((Composite)composite.getShell(), 2048);
        this.end2.setSize(6, 6);
        switch (n) {
            case 128: {
                this.caretControl.setSize(rectangle.width - 2 * n3, 6);
                this.caretControl.setLocation(rectangle.x + n3, rectangle.y + rectangle.height + n2);
                Rectangle rectangle2 = this.caretControl.getBounds();
                this.end1.setLocation(rectangle2.x, rectangle2.y - 6);
                this.end2.setLocation(rectangle2.x + rectangle2.width - 6, rectangle2.y - 6);
                break;
            }
            case 1024: {
                this.caretControl.setSize(rectangle.width - 2 * n3, 6);
                this.caretControl.setLocation(rectangle.x + n3, rectangle.y - n2);
                Rectangle rectangle3 = this.caretControl.getBounds();
                this.end1.setLocation(rectangle3.x, rectangle3.y + 6);
                this.end2.setLocation(rectangle3.x + rectangle3.width - 6, rectangle3.y + 6);
                break;
            }
            case 16384: {
                this.caretControl.setSize(6, rectangle.height - 2 * n4);
                this.caretControl.setLocation(rectangle.x + rectangle.width + n2, rectangle.y + n4);
                Rectangle rectangle4 = this.caretControl.getBounds();
                this.end1.setLocation(rectangle4.x - rectangle4.width, rectangle4.y);
                this.end2.setLocation(rectangle4.x - rectangle4.width, rectangle4.y + rectangle4.height - 6);
                break;
            }
            case 131072: {
                this.caretControl.setSize(6, rectangle.height - 2 * n4);
                this.caretControl.setLocation(rectangle.x - n2, rectangle.y + n4);
                Rectangle rectangle5 = this.caretControl.getBounds();
                this.end1.setLocation(rectangle5.x + rectangle5.width, rectangle5.y);
                this.end2.setLocation(rectangle5.x + rectangle5.width, rectangle5.y + rectangle5.height - 6);
            }
        }
        this.setHighlight(false);
        this.caretControl.moveAbove(null);
        this.end1.moveAbove(null);
        this.end2.moveAbove(null);
    }

    public void setHighlight(boolean bl) {
        this.isHighlight = bl;
        if (this.isHighlight) {
            this.caretControl.setBackground(this.hilightColor);
            this.end1.setBackground(this.hilightColor);
            this.end2.setBackground(this.hilightColor);
        } else {
            this.caretControl.setBackground(this.baseColor);
            this.end1.setBackground(this.baseColor);
            this.end2.setBackground(this.baseColor);
        }
    }

    public void dispose() {
        this.hilightColor.dispose();
        this.caretControl.dispose();
        this.end1.dispose();
        this.end2.dispose();
    }
}

