/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dnd;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tracker;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.DragCursors;
import org.eclipse.ui.internal.dnd.IDragOverListener;
import org.eclipse.ui.internal.dnd.IDropTarget;
import org.eclipse.ui.internal.dnd.IDropTarget2;
import org.eclipse.ui.internal.dnd.SwtUtil;
import org.eclipse.ui.internal.dnd.TestDropLocation;

public class DragUtil {
    private static final String DROP_TARGET_ID = "org.eclipse.ui.internal.dnd.dropTarget";
    private static TestDropLocation forcedDropTarget = null;
    private static List defaultTargets = new ArrayList();

    public static void addDragTarget(Control control, IDragOverListener iDragOverListener) {
        if (control == null) {
            defaultTargets.add(iDragOverListener);
        } else {
            ArrayList<IDragOverListener> arrayList = DragUtil.getTargetList(control);
            if (arrayList == null) {
                arrayList = new ArrayList<IDragOverListener>(1);
            }
            arrayList.add(iDragOverListener);
            control.setData(DROP_TARGET_ID, arrayList);
        }
    }

    private static List getTargetList(Control control) {
        List list = (List)control.getData(DROP_TARGET_ID);
        return list;
    }

    public static void removeDragTarget(Control control, IDragOverListener iDragOverListener) {
        if (control == null) {
            defaultTargets.remove(iDragOverListener);
        } else {
            List list = DragUtil.getTargetList(control);
            if (list != null) {
                list.remove(iDragOverListener);
                if (list.isEmpty()) {
                    control.setData(DROP_TARGET_ID, null);
                }
            }
        }
    }

    public static Rectangle getDisplayBounds(Control control) {
        Composite composite = control.getParent();
        if (composite == null || control instanceof Shell) {
            return control.getBounds();
        }
        return Geometry.toDisplay((Control)composite, (Rectangle)control.getBounds());
    }

    public static boolean performDrag(Object object, Rectangle rectangle, Point point, boolean bl) {
        IDropTarget iDropTarget = DragUtil.dragToTarget(object, rectangle, point, bl);
        if (iDropTarget == null) {
            return false;
        }
        iDropTarget.drop();
        if (iDropTarget != null && iDropTarget instanceof IDropTarget2) {
            ((IDropTarget2)iDropTarget).dragFinished(true);
        }
        return true;
    }

    public static boolean dragTo(Display display, Object object, Point point, Rectangle rectangle) {
        Control control = SwtUtil.findControl(display, point);
        IDropTarget iDropTarget = DragUtil.getDropTarget(control, object, point, rectangle);
        if (iDropTarget == null) {
            return false;
        }
        iDropTarget.drop();
        return true;
    }

    public static void forceDropLocation(TestDropLocation testDropLocation) {
        forcedDropTarget = testDropLocation;
    }

    static IDropTarget dragToTarget(final Object object, final Rectangle rectangle, final Point point, final boolean bl) {
        Rectangle rectangle2;
        final Display display = Display.getCurrent();
        if (forcedDropTarget != null) {
            Point point2 = forcedDropTarget.getLocation();
            Control control = SwtUtil.findControl((Control[])forcedDropTarget.getShells(), point2);
            return DragUtil.getDropTarget(control, object, point2, rectangle);
        }
        final Tracker tracker = new Tracker(display, 0);
        tracker.setStippled(true);
        tracker.addListener(10, new Listener(){

            public void handleEvent(final Event event) {
                display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        Point point2 = new Point(event.x, event.y);
                        IDropTarget iDropTarget = null;
                        Control control = display.getCursorControl();
                        iDropTarget = DragUtil.getDropTarget(control, object, point2, tracker.getRectangles()[0]);
                        Rectangle rectangle2 = null;
                        if (iDropTarget != null) {
                            rectangle2 = iDropTarget.getSnapRectangle();
                            tracker.setCursor(iDropTarget.getCursor());
                        } else {
                            tracker.setCursor(DragCursors.getCursor(0));
                        }
                        if (bl) {
                            Rectangle[] rectangleArray;
                            if (rectangle2 == null) {
                                rectangle2 = new Rectangle(rectangle.x + point2.x - point.x, rectangle.y + point2.y - point.y, rectangle.width, rectangle.height);
                            }
                            if ((rectangleArray = tracker.getRectangles()).length != 1 || !rectangleArray[0].equals((Object)rectangle2)) {
                                tracker.setRectangles(new Rectangle[]{rectangle2});
                            }
                        }
                    }
                });
            }
        });
        IDropTarget iDropTarget = null;
        Control control = display.getCursorControl();
        if (control != null && bl) {
            iDropTarget = DragUtil.getDropTarget(control, object, point, rectangle);
        }
        Rectangle rectangle3 = rectangle;
        if (iDropTarget != null) {
            rectangle2 = iDropTarget.getSnapRectangle();
            if (rectangle2 != null) {
                rectangle3 = rectangle2;
            }
            tracker.setCursor(iDropTarget.getCursor());
        }
        if (rectangle3 != null) {
            tracker.setRectangles(new Rectangle[]{Geometry.copy((Rectangle)rectangle3)});
        }
        if ((rectangle2 = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell()) != null) {
            rectangle2.setCapture(true);
        }
        boolean bl2 = tracker.open();
        if (rectangle2 != null) {
            rectangle2.setCapture(false);
        }
        IDropTarget iDropTarget2 = null;
        Point point3 = display.getCursorLocation();
        Control control2 = display.getCursorControl();
        iDropTarget2 = DragUtil.getDropTarget(control2, object, point3, tracker.getRectangles()[0]);
        tracker.dispose();
        if (bl2) {
            return iDropTarget2;
        }
        if (iDropTarget2 != null && iDropTarget2 instanceof IDropTarget2) {
            ((IDropTarget2)iDropTarget2).dragFinished(false);
        }
        return null;
    }

    private static IDropTarget getDropTarget(List list, Control control, Object object, Point point, Rectangle rectangle) {
        if (list == null) {
            return null;
        }
        for (IDragOverListener iDragOverListener : list) {
            IDropTarget iDropTarget = iDragOverListener.drag(control, object, point, rectangle);
            if (iDropTarget == null) continue;
            return iDropTarget;
        }
        return null;
    }

    public static IDropTarget getDropTarget(Control control, Object object, Point point, Rectangle rectangle) {
        Control control2 = control;
        while (control2 != null) {
            IDropTarget iDropTarget = DragUtil.getDropTarget(DragUtil.getTargetList(control2), control, object, point, rectangle);
            if (iDropTarget != null) {
                return iDropTarget;
            }
            if (control2 instanceof Shell) break;
            control2 = control2.getParent();
        }
        return DragUtil.getDropTarget(defaultTargets, control, object, point, rectangle);
    }

    public static Point getEventLoc(Event event) {
        Control control = (Control)event.widget;
        return control.toDisplay(new Point(event.x, event.y));
    }
}

