/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dnd;

import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.themes.ColorUtil;

public class DragBorder {
    private Composite clientControl = null;
    private Control dragControl = null;
    private Canvas border = null;
    private Color baseColor;
    private Color hilightColor;
    private boolean isHighlight;

    public DragBorder(Composite composite, Control control, boolean bl) {
        this.clientControl = composite;
        this.dragControl = control;
        Point point = control.getSize();
        this.border = new Canvas(this.dragControl.getParent(), 0);
        this.border.setSize(point.x + 2, point.y + 2);
        this.baseColor = this.border.getDisplay().getSystemColor(26);
        RGB rGB = this.border.getDisplay().getSystemColor(25).getRGB();
        RGB rGB2 = ColorUtil.blend(this.baseColor.getRGB(), rGB);
        this.hilightColor = new Color((Device)this.border.getDisplay(), rGB2);
        this.border.moveAbove(null);
        this.dragControl.moveAbove(null);
        if (bl) {
            this.border.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent paintEvent) {
                    if (DragBorder.this.isHighlight) {
                        paintEvent.gc.setForeground(DragBorder.this.hilightColor);
                    } else {
                        paintEvent.gc.setForeground(DragBorder.this.baseColor);
                    }
                    Rectangle rectangle = DragBorder.this.border.getBounds();
                    paintEvent.gc.drawRectangle(0, 0, rectangle.width - 1, rectangle.height - 1);
                }
            });
        }
    }

    public void setLocation(Point point, int n) {
        Point point2;
        if (n == 0x1000000) {
            point2 = this.border.getSize();
            this.border.setLocation(point.x - point2.x / 2, point.y - point2.y / 2);
        } else if (n == 128) {
            this.border.setLocation(point.x, point.y);
        } else {
            this.border.setLocation(point.x, point.y - this.border.getSize().y);
        }
        point2 = this.border.getBounds();
        Rectangle rectangle = this.clientControl.getClientArea();
        Geometry.moveInside((Rectangle)point2, (Rectangle)rectangle);
        this.border.moveAbove(null);
        this.dragControl.moveAbove(null);
        this.dragControl.setLocation(point2.x + 1, point2.y + 1);
        this.border.setBounds((Rectangle)point2);
    }

    public void setHighlight(boolean bl) {
        this.isHighlight = bl;
        this.border.redraw();
    }

    public void dispose() {
        this.hilightColor.dispose();
        this.border.dispose();
    }

    public Rectangle getBounds() {
        return this.border.getBounds();
    }
}

