/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.registry.WorkingSetDescriptor;

public class WorkingSetTypePage
extends WizardPage {
    private static final int SIZING_SELECTION_WIDGET_WIDTH = 50;
    private static final int SIZING_SELECTION_WIDGET_HEIGHT = 200;
    private TableViewer typesListViewer;
    private WorkingSetDescriptor[] descriptors;

    public WorkingSetTypePage() {
        this(WorkbenchPlugin.getDefault().getWorkingSetRegistry().getNewPageWorkingSetDescriptors());
    }

    public WorkingSetTypePage(WorkingSetDescriptor[] workingSetDescriptorArray) {
        super("workingSetTypeSelectionPage", WorkbenchMessages.WorkingSetTypePage_description, WorkbenchImages.getImageDescriptor("IMG_WIZBAN_WORKINGSET_WIZ"));
        this.descriptors = workingSetDescriptorArray;
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete();
    }

    public void createControl(Composite composite) {
        Font font = composite.getFont();
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout());
        composite2.setLayoutData((Object)new GridData(256));
        this.setControl((Control)composite2);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite2, "org.eclipse.ui.working_set_type_page");
        Label label = new Label(composite2, 0);
        label.setText(WorkbenchMessages.WorkingSetTypePage_typesLabel);
        GridData gridData = new GridData(768);
        label.setLayoutData((Object)gridData);
        label.setFont(font);
        this.typesListViewer = new TableViewer(composite2, 2052);
        gridData = new GridData(1808);
        gridData.heightHint = 200;
        gridData.widthHint = 50;
        this.typesListViewer.getTable().setLayoutData((Object)gridData);
        this.typesListViewer.getTable().setFont(font);
        this.typesListViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                WorkingSetTypePage.this.handleSelectionChanged();
            }
        });
        this.typesListViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent doubleClickEvent) {
                WorkingSetTypePage.this.handleDoubleClick();
            }
        });
        this.typesListViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.typesListViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){
            private ResourceManager images = new LocalResourceManager(JFaceResources.getResources());

            public String getText(Object object) {
                return ((WorkingSetDescriptor)object).getName();
            }

            public void dispose() {
                this.images.dispose();
                super.dispose();
            }

            public Image getImage(Object object) {
                ImageDescriptor imageDescriptor = ((WorkingSetDescriptor)object).getIcon();
                return imageDescriptor == null ? null : (Image)this.images.get((DeviceResourceDescriptor)imageDescriptor);
            }
        });
        this.typesListViewer.setInput((Object)this.descriptors);
        this.setPageComplete(false);
    }

    public void dispose() {
        super.dispose();
    }

    public String getSelection() {
        WorkingSetDescriptor workingSetDescriptor = this.getSelectedWorkingSet();
        if (workingSetDescriptor != null) {
            return workingSetDescriptor.getId();
        }
        return null;
    }

    private WorkingSetDescriptor getSelectedWorkingSet() {
        ISelection iSelection = this.typesListViewer.getSelection();
        boolean bl = iSelection != null && !iSelection.isEmpty();
        WorkingSetDescriptor workingSetDescriptor = null;
        if (bl && iSelection instanceof IStructuredSelection) {
            workingSetDescriptor = (WorkingSetDescriptor)((IStructuredSelection)iSelection).getFirstElement();
        }
        return workingSetDescriptor;
    }

    private void handleDoubleClick() {
        this.handleSelectionChanged();
        this.getContainer().showPage(this.getNextPage());
    }

    private void handleSelectionChanged() {
        ISelection iSelection = this.typesListViewer.getSelection();
        boolean bl = iSelection != null && !iSelection.isEmpty();
        WorkingSetDescriptor workingSetDescriptor = this.getSelectedWorkingSet();
        this.setDescription(workingSetDescriptor == null ? "" : workingSetDescriptor.getDescription());
        this.setPageComplete(bl);
    }
}

