/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.AggregateWorkingSet;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.dialogs.AbstractWorkingSetDialog;
import org.eclipse.ui.internal.dialogs.WorkingSetFilter;
import org.eclipse.ui.internal.dialogs.WorkingSetLabelProvider;
import org.eclipse.ui.internal.util.Util;
import org.eclipse.ui.model.WorkbenchViewerComparator;

public class WorkingSetSelectionDialog
extends AbstractWorkingSetDialog {
    private static final int SIZING_SELECTION_WIDGET_HEIGHT = 200;
    private static final int SIZING_SELECTION_WIDGET_WIDTH = 50;
    private ILabelProvider labelProvider;
    private IStructuredContentProvider contentProvider;
    private CheckboxTableViewer listViewer;
    private boolean multiSelect;
    private IWorkbenchWindow workbenchWindow;
    private Button buttonWindowSet;
    private Button buttonNoSet;
    private Button buttonSelectedSets;

    public WorkingSetSelectionDialog(Shell shell, boolean bl, String[] stringArray) {
        super(shell, stringArray, true);
        this.initWorkbenchWindow();
        this.contentProvider = new ArrayContentProvider();
        this.labelProvider = new WorkingSetLabelProvider();
        this.multiSelect = bl;
        if (this.multiSelect) {
            this.setTitle(WorkbenchMessages.WorkingSetSelectionDialog_title_multiSelect);
            this.setMessage(WorkbenchMessages.WorkingSetSelectionDialog_message_multiSelect);
        } else {
            this.setTitle(WorkbenchMessages.WorkingSetSelectionDialog_title);
            this.setMessage(WorkbenchMessages.WorkingSetSelectionDialog_message);
        }
    }

    private void initWorkbenchWindow() {
        Shell shell = this.getShell();
        this.workbenchWindow = Util.getWorkbenchWindowForShell(shell);
    }

    protected void cancelPressed() {
        this.restoreAddedWorkingSets();
        this.restoreChangedWorkingSets();
        this.restoreRemovedWorkingSets();
        this.setSelection(null);
        super.cancelPressed();
    }

    @Override
    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.ui.working_set_selection_dialog_context");
    }

    protected Control createDialogArea(Composite composite) {
        this.initializeDialogUnits((Control)composite);
        Composite composite2 = (Composite)super.createDialogArea(composite);
        this.createMessageArea(composite2);
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                WorkingSetSelectionDialog.this.updateButtonAvailability();
            }
        };
        this.buttonWindowSet = new Button(composite2, 16);
        this.buttonWindowSet.setText(WorkbenchMessages.WindowWorkingSets);
        this.buttonWindowSet.setLayoutData((Object)new GridData(768));
        this.buttonWindowSet.addSelectionListener((SelectionListener)selectionAdapter);
        this.buttonNoSet = new Button(composite2, 16);
        this.buttonNoSet.setText(WorkbenchMessages.NoWorkingSet);
        this.buttonNoSet.setLayoutData((Object)new GridData(768));
        this.buttonNoSet.addSelectionListener((SelectionListener)selectionAdapter);
        this.buttonSelectedSets = new Button(composite2, 16);
        this.buttonSelectedSets.setText(WorkbenchMessages.SelectedWorkingSets);
        this.buttonSelectedSets.addSelectionListener((SelectionListener)selectionAdapter);
        switch (this.getInitialRadioSelection()) {
            case 0: {
                this.buttonWindowSet.setSelection(true);
                break;
            }
            case 1: {
                this.buttonNoSet.setSelection(true);
                break;
            }
            case 2: {
                this.buttonSelectedSets.setSelection(true);
            }
        }
        this.buttonSelectedSets.setLayoutData((Object)new GridData(768));
        Composite composite3 = new Composite(composite2, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        gridLayout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        composite3.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(1808);
        gridData.heightHint = 200;
        gridData.widthHint = 350;
        composite3.setLayoutData((Object)gridData);
        this.listViewer = CheckboxTableViewer.newCheckList((Composite)composite3, (int)2050);
        gridData = new GridData(1808);
        gridData.heightHint = 200;
        gridData.widthHint = 50;
        this.listViewer.getTable().setLayoutData((Object)gridData);
        this.listViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.listViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.listViewer.setComparator((ViewerComparator)new WorkbenchViewerComparator());
        this.listViewer.addFilter((ViewerFilter)new WorkingSetFilter(this.getSupportedWorkingSetIds()));
        this.listViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                WorkingSetSelectionDialog.this.handleSelectionChanged();
            }
        });
        this.listViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent doubleClickEvent) {
                Object object = ((IStructuredSelection)WorkingSetSelectionDialog.this.listViewer.getSelection()).getFirstElement();
                WorkingSetSelectionDialog.this.listViewer.setCheckedElements(new Object[]{object});
                WorkingSetSelectionDialog.this.buttonWindowSet.setSelection(false);
                WorkingSetSelectionDialog.this.buttonNoSet.setSelection(false);
                WorkingSetSelectionDialog.this.buttonSelectedSets.setSelection(true);
                WorkingSetSelectionDialog.this.okPressed();
            }
        });
        this.listViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent checkStateChangedEvent) {
                WorkingSetSelectionDialog.this.buttonWindowSet.setSelection(false);
                WorkingSetSelectionDialog.this.buttonNoSet.setSelection(false);
                WorkingSetSelectionDialog.this.buttonSelectedSets.setSelection(true);
            }
        });
        this.addModifyButtons(composite3);
        this.addSelectionButtons(composite2);
        this.listViewer.setInput(Arrays.asList(WorkbenchPlugin.getDefault().getWorkingSetManager().getWorkingSets()));
        List list = this.getInitialElementSelections();
        if (this.multiSelect) {
            this.listViewer.setCheckedElements(list.toArray());
        } else if (!list.isEmpty()) {
            IWorkingSet iWorkingSet = (IWorkingSet)list.get(0);
            if (iWorkingSet instanceof AggregateWorkingSet) {
                AggregateWorkingSet aggregateWorkingSet = (AggregateWorkingSet)iWorkingSet;
                this.listViewer.setCheckedElements((Object[])aggregateWorkingSet.getComponents());
            } else {
                this.listViewer.setCheckedElements(list.toArray());
            }
        }
        this.availableWorkingSetsChanged();
        Dialog.applyDialogFont((Control)composite2);
        return composite2;
    }

    private int getInitialRadioSelection() {
        IWorkingSet iWorkingSet = this.workbenchWindow.getActivePage().getAggregateWorkingSet();
        int n = this.getSelection() != null && this.getSelection().length > 0 ? (iWorkingSet.equals(this.getSelection()[0]) ? 0 : 2) : 1;
        return n;
    }

    protected Control createContents(Composite composite) {
        Control control = super.createContents(composite);
        List list = this.getInitialElementSelections();
        if (!list.isEmpty()) {
            this.listViewer.setSelection((ISelection)new StructuredSelection(list), true);
        }
        this.updateButtonAvailability();
        return control;
    }

    @Override
    protected List getSelectedWorkingSets() {
        ISelection iSelection = this.listViewer.getSelection();
        if (iSelection instanceof IStructuredSelection) {
            return ((IStructuredSelection)iSelection).toList();
        }
        return null;
    }

    void handleSelectionChanged() {
        this.updateButtonAvailability();
    }

    protected void okPressed() {
        if (this.buttonWindowSet.getSelection()) {
            IWorkingSet[] iWorkingSetArray = new IWorkingSet[]{this.workbenchWindow.getActivePage().getAggregateWorkingSet()};
            this.setSelection(iWorkingSetArray);
            this.setResult(Arrays.asList(this.getSelection()));
        } else if (this.buttonNoSet.getSelection()) {
            this.setSelection(new IWorkingSet[0]);
            this.setResult(Arrays.asList(this.getSelection()));
        } else if (this.buttonSelectedSets.getSelection()) {
            Object[] objectArray = this.listViewer.getCheckedElements();
            IWorkingSet[] iWorkingSetArray = new IWorkingSet[objectArray.length];
            System.arraycopy(objectArray, 0, iWorkingSetArray, 0, objectArray.length);
            if (this.multiSelect || iWorkingSetArray.length <= 1) {
                this.setSelection(iWorkingSetArray);
                this.setResult(Arrays.asList(iWorkingSetArray));
            } else {
                String string = this.getAggregateIdForSets(iWorkingSetArray);
                IWorkingSetManager iWorkingSetManager = this.workbenchWindow.getWorkbench().getWorkingSetManager();
                IWorkingSet iWorkingSet = iWorkingSetManager.getWorkingSet(string);
                if (iWorkingSet != null) {
                    iWorkingSetManager.removeWorkingSet(iWorkingSet);
                }
                iWorkingSet = iWorkingSetManager.createAggregateWorkingSet(string, WorkbenchMessages.WorkbenchPage_workingSet_multi_label, iWorkingSetArray);
                iWorkingSetManager.addWorkingSet(iWorkingSet);
                this.setSelection(new IWorkingSet[]{iWorkingSet});
                this.setResult(Collections.singletonList(iWorkingSet));
            }
        }
        super.okPressed();
    }

    private String getAggregateIdForSets(IWorkingSet[] iWorkingSetArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Aggregate:");
        int n = 0;
        while (n < iWorkingSetArray.length) {
            stringBuffer.append(iWorkingSetArray[n].getName()).append(':');
            ++n;
        }
        return stringBuffer.toString();
    }

    private void restoreAddedWorkingSets() {
        IWorkingSetManager iWorkingSetManager = WorkbenchPlugin.getDefault().getWorkingSetManager();
        Iterator iterator = this.getAddedWorkingSets().iterator();
        while (iterator.hasNext()) {
            iWorkingSetManager.removeWorkingSet((IWorkingSet)iterator.next());
        }
    }

    private void restoreChangedWorkingSets() {
        for (IWorkingSet iWorkingSet : this.getEditedWorkingSets().keySet()) {
            IWorkingSet iWorkingSet2 = (IWorkingSet)this.getEditedWorkingSets().get(iWorkingSet);
            if (!iWorkingSet.getName().equals(iWorkingSet2.getName())) {
                iWorkingSet.setName(iWorkingSet2.getName());
            }
            if (iWorkingSet.getElements().equals(iWorkingSet2.getElements())) continue;
            iWorkingSet.setElements(iWorkingSet2.getElements());
        }
    }

    private void restoreRemovedWorkingSets() {
        IWorkingSetManager iWorkingSetManager = WorkbenchPlugin.getDefault().getWorkingSetManager();
        Iterator iterator = this.getRemovedWorkingSets().iterator();
        while (iterator.hasNext()) {
            iWorkingSetManager.addWorkingSet((IWorkingSet)iterator.next());
        }
        iterator = this.getRemovedMRUWorkingSets().iterator();
        while (iterator.hasNext()) {
            iWorkingSetManager.addRecentWorkingSet((IWorkingSet)iterator.next());
        }
    }

    @Override
    public void setSelection(IWorkingSet[] iWorkingSetArray) {
        super.setSelection(iWorkingSetArray);
        this.setInitialSelections(iWorkingSetArray == null ? new Object[]{} : iWorkingSetArray);
    }

    @Override
    protected void availableWorkingSetsChanged() {
        this.listViewer.setInput((Object)PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSets());
        super.availableWorkingSetsChanged();
    }

    @Override
    protected void selectAllSets() {
        this.listViewer.setCheckedElements((Object[])PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSets());
        this.buttonWindowSet.setSelection(false);
        this.buttonNoSet.setSelection(false);
        this.buttonSelectedSets.setSelection(true);
        this.updateButtonAvailability();
    }

    @Override
    protected void deselectAllSets() {
        this.listViewer.setCheckedElements(new Object[0]);
        this.buttonWindowSet.setSelection(false);
        this.buttonNoSet.setSelection(false);
        this.buttonSelectedSets.setSelection(true);
        this.updateButtonAvailability();
    }
}

