/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.dialogs.IWorkingSetNewWizard;
import org.eclipse.ui.dialogs.IWorkingSetPage;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.dialogs.WorkingSetTypePage;
import org.eclipse.ui.internal.registry.WorkingSetDescriptor;
import org.eclipse.ui.internal.registry.WorkingSetRegistry;

public class WorkingSetNewWizard
extends Wizard
implements IWorkingSetNewWizard {
    private WorkingSetTypePage workingSetTypePage;
    private IWorkingSetPage workingSetEditPage;
    private String editPageId;
    private IWorkingSet workingSet;
    private WorkingSetDescriptor[] descriptors;

    public WorkingSetNewWizard(WorkingSetDescriptor[] workingSetDescriptorArray) {
        Assert.isTrue((workingSetDescriptorArray != null && workingSetDescriptorArray.length > 0 ? 1 : 0) != 0);
        this.descriptors = workingSetDescriptorArray;
        this.setWindowTitle(WorkbenchMessages.WorkingSetNewWizard_title);
    }

    public void addPages() {
        Object object;
        super.addPages();
        WorkingSetRegistry workingSetRegistry = WorkbenchPlugin.getDefault().getWorkingSetRegistry();
        if (this.descriptors.length > 1) {
            object = this.workingSetTypePage = new WorkingSetTypePage(this.descriptors);
        } else {
            this.editPageId = this.descriptors[0].getId();
            this.workingSetEditPage = workingSetRegistry.getWorkingSetPage(this.editPageId);
            object = this.workingSetEditPage;
        }
        object.setWizard(this);
        this.addPage((IWizardPage)object);
        this.setForcePreviousAndNextButtons(this.descriptors.length > 1);
    }

    public boolean canFinish() {
        return this.workingSetEditPage != null && this.workingSetEditPage.isPageComplete();
    }

    public IWizardPage getNextPage(IWizardPage iWizardPage) {
        String string;
        if (this.workingSetTypePage != null && iWizardPage == this.workingSetTypePage && (string = this.workingSetTypePage.getSelection()) != null) {
            if (this.workingSetEditPage == null || string != this.editPageId) {
                WorkingSetRegistry workingSetRegistry = WorkbenchPlugin.getDefault().getWorkingSetRegistry();
                this.workingSetEditPage = workingSetRegistry.getWorkingSetPage(string);
                this.addPage(this.workingSetEditPage);
                this.editPageId = string;
            }
            return this.workingSetEditPage;
        }
        return null;
    }

    @Override
    public IWorkingSet getSelection() {
        return this.workingSet;
    }

    public boolean performFinish() {
        this.workingSetEditPage.finish();
        this.workingSet = this.workingSetEditPage.getSelection();
        this.workingSet.setId(this.editPageId);
        return true;
    }
}

