/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.IWizardNode;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardSelectionPage;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.activities.ITriggerPoint;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.dialogs.WorkbenchWizardElement;
import org.eclipse.ui.model.AdaptableList;

public abstract class WorkbenchWizardSelectionPage
extends WizardSelectionPage {
    protected IWorkbench workbench;
    protected AdaptableList wizardElements;
    public TableViewer wizardSelectionViewer;
    protected IStructuredSelection currentResourceSelection;
    protected String triggerPointId;

    public WorkbenchWizardSelectionPage(String string, IWorkbench iWorkbench, IStructuredSelection iStructuredSelection, AdaptableList adaptableList, String string2) {
        super(string);
        this.wizardElements = adaptableList;
        this.currentResourceSelection = iStructuredSelection;
        this.workbench = iWorkbench;
        this.triggerPointId = string2;
        this.setTitle(WorkbenchMessages.Select);
    }

    protected WorkbenchWizardElement findWizard(String string) {
        Object[] objectArray = this.wizardElements.getChildren();
        int n = 0;
        while (n < objectArray.length) {
            WorkbenchWizardElement workbenchWizardElement = (WorkbenchWizardElement)objectArray[n];
            if (workbenchWizardElement.getId().equals(string)) {
                return workbenchWizardElement;
            }
            ++n;
        }
        return null;
    }

    public IStructuredSelection getCurrentResourceSelection() {
        return this.currentResourceSelection;
    }

    public IWorkbench getWorkbench() {
        return this.workbench;
    }

    public void selectWizardNode(IWizardNode iWizardNode) {
        this.setSelectedNode(iWizardNode);
    }

    public IWizardPage getNextPage() {
        ITriggerPoint iTriggerPoint = this.getWorkbench().getActivitySupport().getTriggerPointManager().getTriggerPoint(this.triggerPointId);
        if (iTriggerPoint == null || WorkbenchActivityHelper.allowUseOf(iTriggerPoint, this.getSelectedNode())) {
            return super.getNextPage();
        }
        return null;
    }
}

