/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardNode;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.dialogs.WorkbenchWizardSelectionPage;
import org.eclipse.ui.internal.util.Util;
import org.eclipse.ui.statushandlers.StatusAdapter;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.wizards.IWizardDescriptor;

public abstract class WorkbenchWizardNode
implements IWizardNode,
IPluginContribution {
    protected WorkbenchWizardSelectionPage parentWizardPage;
    protected IWizard wizard;
    protected IWizardDescriptor wizardElement;

    public WorkbenchWizardNode(WorkbenchWizardSelectionPage workbenchWizardSelectionPage, IWizardDescriptor iWizardDescriptor) {
        this.parentWizardPage = workbenchWizardSelectionPage;
        this.wizardElement = iWizardDescriptor;
    }

    public abstract IWorkbenchWizard createWizard() throws CoreException;

    public void dispose() {
    }

    protected IStructuredSelection getCurrentResourceSelection() {
        return this.parentWizardPage.getCurrentResourceSelection();
    }

    public Point getExtent() {
        return new Point(-1, -1);
    }

    @Override
    public String getLocalId() {
        IPluginContribution iPluginContribution = (IPluginContribution)Util.getAdapter(this.wizardElement, IPluginContribution.class);
        if (iPluginContribution != null) {
            return iPluginContribution.getLocalId();
        }
        return this.wizardElement.getId();
    }

    @Override
    public String getPluginId() {
        IPluginContribution iPluginContribution = (IPluginContribution)Util.getAdapter(this.wizardElement, IPluginContribution.class);
        if (iPluginContribution != null) {
            return iPluginContribution.getPluginId();
        }
        return null;
    }

    public IWizard getWizard() {
        if (this.wizard != null) {
            return this.wizard;
        }
        final IWorkbenchWizard[] iWorkbenchWizardArray = new IWorkbenchWizard[1];
        final IStatus[] iStatusArray = new IStatus[1];
        BusyIndicator.showWhile((Display)this.parentWizardPage.getShell().getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                    public void handleException(Throwable throwable) {
                        IPluginContribution iPluginContribution = (IPluginContribution)Util.getAdapter((this).WorkbenchWizardNode.this.wizardElement, IPluginContribution.class);
                        iStatusArray[0] = new Status(4, iPluginContribution != null ? iPluginContribution.getPluginId() : WorkbenchPlugin.PI_WORKBENCH, 0, WorkbenchMessages.WorkbenchWizard_errorMessage, throwable);
                    }

                    public void run() {
                        try {
                            iWorkbenchWizardArray[0] = WorkbenchWizardNode.this.createWizard();
                        }
                        catch (CoreException coreException) {
                            IPluginContribution iPluginContribution = (IPluginContribution)Util.getAdapter((this).WorkbenchWizardNode.this.wizardElement, IPluginContribution.class);
                            iStatusArray[0] = new Status(4, iPluginContribution != null ? iPluginContribution.getPluginId() : WorkbenchPlugin.PI_WORKBENCH, 0, WorkbenchMessages.WorkbenchWizard_errorMessage, (Throwable)coreException);
                        }
                    }
                });
            }
        });
        if (iStatusArray[0] != null) {
            this.parentWizardPage.setErrorMessage(WorkbenchMessages.WorkbenchWizard_errorMessage);
            StatusAdapter statusAdapter = new StatusAdapter(iStatusArray[0]);
            statusAdapter.addAdapter(Shell.class, this.parentWizardPage.getShell());
            statusAdapter.setProperty(StatusAdapter.TITLE_PROPERTY, WorkbenchMessages.WorkbenchWizard_errorTitle);
            StatusManager.getManager().handle(statusAdapter, 2);
            return null;
        }
        IStructuredSelection iStructuredSelection = this.getCurrentResourceSelection();
        iStructuredSelection = this.wizardElement.adaptedSelection(iStructuredSelection);
        iWorkbenchWizardArray[0].init(this.getWorkbench(), iStructuredSelection);
        this.wizard = iWorkbenchWizardArray[0];
        return this.wizard;
    }

    public IWizardDescriptor getWizardElement() {
        return this.wizardElement;
    }

    protected IWorkbench getWorkbench() {
        return this.parentWizardPage.getWorkbench();
    }

    public boolean isContentCreated() {
        return this.wizard != null;
    }
}

