/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.IWizardNode;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.dialogs.DialogUtil;
import org.eclipse.ui.internal.dialogs.WizardContentProvider;
import org.eclipse.ui.internal.dialogs.WorkbenchWizardElement;
import org.eclipse.ui.internal.dialogs.WorkbenchWizardSelectionPage;
import org.eclipse.ui.model.AdaptableList;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.model.WorkbenchViewerComparator;

public abstract class WorkbenchWizardListSelectionPage
extends WorkbenchWizardSelectionPage
implements ISelectionChangedListener,
IDoubleClickListener {
    private static final String DIALOG_SETTING_SECTION_NAME = "WizardListSelectionPage.";
    private static final int SIZING_LISTS_HEIGHT = 200;
    private static final String STORE_SELECTED_WIZARD_ID = "WizardListSelectionPage.STORE_SELECTED_WIZARD_ID";
    private TableViewer viewer;
    private String message;

    protected WorkbenchWizardListSelectionPage(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection, AdaptableList adaptableList, String string, String string2) {
        super("singleWizardSelectionPage", iWorkbench, iStructuredSelection, adaptableList, string2);
        this.setDescription(WorkbenchMessages.WizardList_description);
        this.message = string;
    }

    public void createControl(Composite composite) {
        Font font = composite.getFont();
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout());
        composite2.setLayoutData((Object)new GridData(272));
        composite2.setFont(font);
        Label label = new Label(composite2, 0);
        label.setText(this.message);
        label.setFont(font);
        this.createViewer(composite2);
        this.layoutTopControl(this.viewer.getControl());
        this.restoreWidgetValues();
        this.setControl((Control)composite2);
    }

    private void createViewer(Composite composite) {
        Table table = new Table(composite, 2048);
        table.setFont(composite.getFont());
        this.viewer = new TableViewer(table);
        this.viewer.setContentProvider((IContentProvider)new WizardContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.viewer.setComparator((ViewerComparator)new WorkbenchViewerComparator());
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.viewer.addDoubleClickListener((IDoubleClickListener)this);
        this.viewer.setInput((Object)this.wizardElements);
    }

    protected abstract IWizardNode createWizardNode(WorkbenchWizardElement var1);

    public void doubleClick(DoubleClickEvent doubleClickEvent) {
        this.selectionChanged(new SelectionChangedEvent((ISelectionProvider)doubleClickEvent.getViewer(), doubleClickEvent.getViewer().getSelection()));
        this.getContainer().showPage(this.getNextPage());
    }

    private void layoutTopControl(Control control) {
        GridData gridData = new GridData(1808);
        int n = DialogUtil.availableRows(control.getParent());
        gridData.heightHint = n > 50 ? 200 : n * 3;
        control.setLayoutData((Object)gridData);
    }

    private void restoreWidgetValues() {
        IDialogSettings iDialogSettings = this.getDialogSettings();
        if (iDialogSettings == null) {
            return;
        }
        String string = iDialogSettings.get(STORE_SELECTED_WIZARD_ID);
        WorkbenchWizardElement workbenchWizardElement = this.findWizard(string);
        if (workbenchWizardElement == null) {
            return;
        }
        StructuredSelection structuredSelection = new StructuredSelection((Object)workbenchWizardElement);
        this.viewer.setSelection((ISelection)structuredSelection);
    }

    public void saveWidgetValues() {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.viewer.getSelection();
        if (iStructuredSelection.size() > 0) {
            WorkbenchWizardElement workbenchWizardElement = (WorkbenchWizardElement)iStructuredSelection.getFirstElement();
            this.getDialogSettings().put(STORE_SELECTED_WIZARD_ID, workbenchWizardElement.getId());
        }
    }

    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        this.setErrorMessage(null);
        IStructuredSelection iStructuredSelection = (IStructuredSelection)selectionChangedEvent.getSelection();
        WorkbenchWizardElement workbenchWizardElement = (WorkbenchWizardElement)iStructuredSelection.getFirstElement();
        if (workbenchWizardElement == null) {
            this.setMessage(null);
            this.setSelectedNode(null);
            return;
        }
        this.setSelectedNode(this.createWizardNode(workbenchWizardElement));
        this.setMessage(workbenchWizardElement.getDescription());
    }
}

