/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.SelectionEnabler;
import org.eclipse.ui.internal.ISelectionConversionService;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.dialogs.WizardCollectionElement;
import org.eclipse.ui.internal.registry.KeywordRegistry;
import org.eclipse.ui.internal.registry.RegistryReader;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.model.IWorkbenchAdapter2;
import org.eclipse.ui.model.IWorkbenchAdapter3;
import org.eclipse.ui.model.WorkbenchAdapter;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.wizards.IWizardCategory;
import org.eclipse.ui.wizards.IWizardDescriptor;

public class WorkbenchWizardElement
extends WorkbenchAdapter
implements IAdaptable,
IPluginContribution,
IWizardDescriptor {
    private String id;
    private ImageDescriptor imageDescriptor;
    private SelectionEnabler selectionEnabler;
    private IConfigurationElement configurationElement;
    private ImageDescriptor descriptionImage;
    private WizardCollectionElement parentCategory;
    public static final String TAG_PROJECT = "project";
    private static final String[] EMPTY_TAGS = new String[0];
    private static final String[] PROJECT_TAGS = new String[]{"project"};
    private String[] keywordLabels;

    public WorkbenchWizardElement(IConfigurationElement iConfigurationElement) {
        this.configurationElement = iConfigurationElement;
        this.id = iConfigurationElement.getAttribute("id");
    }

    public boolean canHandleSelection(IStructuredSelection iStructuredSelection) {
        return this.getSelectionEnabler().isEnabledForSelection((ISelection)iStructuredSelection);
    }

    @Override
    public IStructuredSelection adaptedSelection(IStructuredSelection iStructuredSelection) {
        if (this.canHandleSelection(iStructuredSelection)) {
            return iStructuredSelection;
        }
        IStructuredSelection iStructuredSelection2 = this.convertToResources(iStructuredSelection);
        if (this.canHandleSelection(iStructuredSelection2)) {
            return iStructuredSelection2;
        }
        return StructuredSelection.EMPTY;
    }

    public Object createExecutableExtension() throws CoreException {
        return WorkbenchPlugin.createExtension(this.configurationElement, "class");
    }

    public Object getAdapter(Class clazz) {
        if (clazz == IWorkbenchAdapter.class || clazz == IWorkbenchAdapter2.class || clazz == IWorkbenchAdapter3.class) {
            return this;
        }
        if (clazz == IPluginContribution.class) {
            return this;
        }
        if (clazz == IConfigurationElement.class) {
            return this.configurationElement;
        }
        return Platform.getAdapterManager().getAdapter((Object)this, clazz);
    }

    public IConfigurationElement getConfigurationElement() {
        return this.configurationElement;
    }

    @Override
    public String getDescription() {
        return RegistryReader.getDescription(this.configurationElement);
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        if (this.imageDescriptor == null) {
            String string = this.configurationElement.getAttribute("icon");
            if (string == null) {
                return null;
            }
            this.imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin(this.configurationElement.getNamespaceIdentifier(), string);
        }
        return this.imageDescriptor;
    }

    @Override
    public ImageDescriptor getImageDescriptor(Object object) {
        return this.getImageDescriptor();
    }

    @Override
    public String getLabel(Object object) {
        return this.configurationElement.getAttribute("name");
    }

    protected SelectionEnabler getSelectionEnabler() {
        if (this.selectionEnabler == null) {
            this.selectionEnabler = new SelectionEnabler(this.configurationElement);
        }
        return this.selectionEnabler;
    }

    private IStructuredSelection convertToResources(IStructuredSelection iStructuredSelection) {
        Object object = PlatformUI.getWorkbench().getService(ISelectionConversionService.class);
        if (object == null || iStructuredSelection == null) {
            return StructuredSelection.EMPTY;
        }
        return ((ISelectionConversionService)object).convertToResources(iStructuredSelection);
    }

    @Override
    public String getLocalId() {
        return this.getId();
    }

    @Override
    public String getPluginId() {
        return this.configurationElement != null ? this.configurationElement.getNamespaceIdentifier() : null;
    }

    @Override
    public ImageDescriptor getDescriptionImage() {
        if (this.descriptionImage == null) {
            String string = this.configurationElement.getAttribute("descriptionImage");
            if (string == null) {
                return null;
            }
            this.descriptionImage = AbstractUIPlugin.imageDescriptorFromPlugin(this.configurationElement.getNamespaceIdentifier(), string);
        }
        return this.descriptionImage;
    }

    @Override
    public String getHelpHref() {
        return this.configurationElement.getAttribute("helpHref");
    }

    @Override
    public IWorkbenchWizard createWizard() throws CoreException {
        return (IWorkbenchWizard)this.createExecutableExtension();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getLabel() {
        return this.getLabel(this);
    }

    @Override
    public IWizardCategory getCategory() {
        return (IWizardCategory)this.getParent(this);
    }

    public WizardCollectionElement getCollectionElement() {
        return (WizardCollectionElement)this.getParent(this);
    }

    @Override
    public String[] getTags() {
        String string = this.configurationElement.getAttribute(TAG_PROJECT);
        if (Boolean.valueOf(string).booleanValue()) {
            return PROJECT_TAGS;
        }
        return EMPTY_TAGS;
    }

    @Override
    public Object getParent(Object object) {
        return this.parentCategory;
    }

    public void setParent(WizardCollectionElement wizardCollectionElement) {
        this.parentCategory = wizardCollectionElement;
    }

    @Override
    public boolean canFinishEarly() {
        return Boolean.valueOf(this.configurationElement.getAttribute("canFinishEarly"));
    }

    @Override
    public boolean hasPages() {
        String string = this.configurationElement.getAttribute("hasPages");
        if (string == null) {
            return true;
        }
        return Boolean.valueOf(string);
    }

    public String[] getKeywordLabels() {
        if (this.keywordLabels == null) {
            IConfigurationElement[] iConfigurationElementArray = this.configurationElement.getChildren("keywordReference");
            this.keywordLabels = new String[iConfigurationElementArray.length];
            KeywordRegistry keywordRegistry = KeywordRegistry.getInstance();
            int n = 0;
            while (n < iConfigurationElementArray.length) {
                String string = iConfigurationElementArray[n].getAttribute("id");
                this.keywordLabels[n] = keywordRegistry.getKeywordLabel(string);
                ++n;
            }
        }
        return this.keywordLabels;
    }
}

