/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.util.PrefUtil;

public class WorkbenchPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Button stickyCycleButton;
    private Button doubleClickButton;
    private Button singleClickButton;
    private Button selectOnHoverButton;
    private Button openAfterDelayButton;
    private Button showUserDialogButton;
    private boolean openOnSingleClick;
    private boolean selectOnHover;
    private boolean openAfterDelay;
    private Button showHeapStatusButton;

    protected Control createContents(Composite composite) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.ui.workbench_preference_page_context");
        Composite composite2 = this.createComposite(composite);
        this.createButtons(composite2);
        WorkbenchPreferencePage.createSpace(composite2);
        this.createOpenModeGroup(composite2);
        this.applyDialogFont(composite2);
        return composite2;
    }

    protected void createButtons(Composite composite) {
        this.createShowUserDialogPref(composite);
        this.createStickyCyclePref(composite);
        this.createHeapStatusPref(composite);
    }

    protected void createShowUserDialogPref(Composite composite) {
        this.showUserDialogButton = new Button(composite, 32);
        this.showUserDialogButton.setText(WorkbenchMessages.WorkbenchPreference_RunInBackgroundButton);
        this.showUserDialogButton.setToolTipText(WorkbenchMessages.WorkbenchPreference_RunInBackgroundToolTip);
        this.showUserDialogButton.setSelection(WorkbenchPlugin.getDefault().getPreferenceStore().getBoolean("RUN_IN_BACKGROUND"));
    }

    protected void createHeapStatusPref(Composite composite) {
        this.showHeapStatusButton = new Button(composite, 32);
        this.showHeapStatusButton.setText(WorkbenchMessages.WorkbenchPreference_HeapStatusButton);
        this.showHeapStatusButton.setToolTipText(WorkbenchMessages.WorkbenchPreference_HeapStatusButtonToolTip);
        this.showHeapStatusButton.setSelection(PrefUtil.getAPIPreferenceStore().getBoolean("SHOW_MEMORY_MONITOR"));
    }

    protected Composite createComposite(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(272));
        return composite2;
    }

    protected void createStickyCyclePref(Composite composite) {
        this.stickyCycleButton = new Button(composite, 32);
        this.stickyCycleButton.setText(WorkbenchMessages.WorkbenchPreference_stickyCycleButton);
        this.stickyCycleButton.setSelection(this.getPreferenceStore().getBoolean("STICKY_CYCLE"));
    }

    protected void createOpenModeGroup(Composite composite) {
        Font font = composite.getFont();
        Group group = new Group(composite, 16384);
        GridLayout gridLayout = new GridLayout();
        group.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(768);
        group.setLayoutData((Object)gridData);
        group.setText(WorkbenchMessages.WorkbenchPreference_openMode);
        String string = WorkbenchMessages.WorkbenchPreference_doubleClick;
        this.doubleClickButton = WorkbenchPreferencePage.createRadioButton((Composite)group, string);
        this.doubleClickButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                WorkbenchPreferencePage.this.selectClickMode(WorkbenchPreferencePage.this.singleClickButton.getSelection());
            }
        });
        this.doubleClickButton.setSelection(!this.openOnSingleClick);
        string = WorkbenchMessages.WorkbenchPreference_singleClick;
        this.singleClickButton = WorkbenchPreferencePage.createRadioButton((Composite)group, string);
        this.singleClickButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                WorkbenchPreferencePage.this.selectClickMode(WorkbenchPreferencePage.this.singleClickButton.getSelection());
            }
        });
        this.singleClickButton.setSelection(this.openOnSingleClick);
        string = WorkbenchMessages.WorkbenchPreference_singleClick_SelectOnHover;
        this.selectOnHoverButton = new Button((Composite)group, 16416);
        this.selectOnHoverButton.setText(string);
        this.selectOnHoverButton.setEnabled(this.openOnSingleClick);
        this.selectOnHoverButton.setSelection(this.selectOnHover);
        this.selectOnHoverButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                WorkbenchPreferencePage.this.selectOnHover = WorkbenchPreferencePage.this.selectOnHoverButton.getSelection();
            }
        });
        gridData = new GridData();
        gridData.horizontalIndent = 20;
        this.selectOnHoverButton.setLayoutData((Object)gridData);
        string = WorkbenchMessages.WorkbenchPreference_singleClick_OpenAfterDelay;
        this.openAfterDelayButton = new Button((Composite)group, 16416);
        this.openAfterDelayButton.setText(string);
        this.openAfterDelayButton.setEnabled(this.openOnSingleClick);
        this.openAfterDelayButton.setSelection(this.openAfterDelay);
        this.openAfterDelayButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                WorkbenchPreferencePage.this.openAfterDelay = WorkbenchPreferencePage.this.openAfterDelayButton.getSelection();
            }
        });
        gridData = new GridData();
        gridData.horizontalIndent = 20;
        this.openAfterDelayButton.setLayoutData((Object)gridData);
        this.createNoteComposite(font, (Composite)group, WorkbenchMessages.Preference_note, WorkbenchMessages.WorkbenchPreference_noEffectOnAllViews);
    }

    private void selectClickMode(boolean bl) {
        this.openOnSingleClick = bl;
        this.selectOnHoverButton.setEnabled(this.openOnSingleClick);
        this.openAfterDelayButton.setEnabled(this.openOnSingleClick);
    }

    protected static Button createRadioButton(Composite composite, String string) {
        Button button = new Button(composite, 16400);
        button.setText(string);
        return button;
    }

    protected static Combo createCombo(Composite composite) {
        Combo combo = new Combo(composite, 8);
        GridData gridData = new GridData(768);
        gridData.widthHint = 200;
        combo.setLayoutData((Object)gridData);
        return combo;
    }

    protected static Label createLabel(Composite composite, String string) {
        Label label = new Label(composite, 16384);
        label.setText(string);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 4;
        label.setLayoutData((Object)gridData);
        return label;
    }

    protected static void createSpace(Composite composite) {
        Label label = new Label(composite, 16384);
        GridData gridData = new GridData();
        gridData = new GridData();
        gridData.horizontalAlignment = 1;
        gridData.grabExcessHorizontalSpace = false;
        gridData.verticalAlignment = 2;
        gridData.grabExcessVerticalSpace = false;
        label.setLayoutData((Object)gridData);
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return WorkbenchPlugin.getDefault().getPreferenceStore();
    }

    @Override
    public void init(IWorkbench iWorkbench) {
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        this.openOnSingleClick = iPreferenceStore.getBoolean("OPEN_ON_SINGLE_CLICK");
        this.selectOnHover = iPreferenceStore.getBoolean("SELECT_ON_HOVER");
        this.openAfterDelay = iPreferenceStore.getBoolean("OPEN_AFTER_DELAY");
    }

    protected void performDefaults() {
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        this.stickyCycleButton.setSelection(iPreferenceStore.getBoolean("STICKY_CYCLE"));
        this.openOnSingleClick = iPreferenceStore.getDefaultBoolean("OPEN_ON_SINGLE_CLICK");
        this.selectOnHover = iPreferenceStore.getDefaultBoolean("SELECT_ON_HOVER");
        this.openAfterDelay = iPreferenceStore.getDefaultBoolean("OPEN_AFTER_DELAY");
        this.singleClickButton.setSelection(this.openOnSingleClick);
        this.doubleClickButton.setSelection(!this.openOnSingleClick);
        this.selectOnHoverButton.setSelection(this.selectOnHover);
        this.openAfterDelayButton.setSelection(this.openAfterDelay);
        this.selectOnHoverButton.setEnabled(this.openOnSingleClick);
        this.openAfterDelayButton.setEnabled(this.openOnSingleClick);
        this.stickyCycleButton.setSelection(iPreferenceStore.getDefaultBoolean("STICKY_CYCLE"));
        this.showUserDialogButton.setSelection(iPreferenceStore.getDefaultBoolean("RUN_IN_BACKGROUND"));
        this.showHeapStatusButton.setSelection(PrefUtil.getAPIPreferenceStore().getDefaultBoolean("SHOW_MEMORY_MONITOR"));
        super.performDefaults();
    }

    public boolean performOk() {
        int n;
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        iPreferenceStore.setValue("STICKY_CYCLE", this.stickyCycleButton.getSelection());
        iPreferenceStore.setValue("OPEN_ON_SINGLE_CLICK", this.openOnSingleClick);
        iPreferenceStore.setValue("SELECT_ON_HOVER", this.selectOnHover);
        iPreferenceStore.setValue("OPEN_AFTER_DELAY", this.openAfterDelay);
        iPreferenceStore.setValue("RUN_IN_BACKGROUND", this.showUserDialogButton.getSelection());
        PrefUtil.getAPIPreferenceStore().setValue("SHOW_MEMORY_MONITOR", this.showHeapStatusButton.getSelection());
        this.updateHeapStatus(this.showHeapStatusButton.getSelection());
        int n2 = n = this.openOnSingleClick ? 1 : 0;
        if (this.openOnSingleClick) {
            if (this.selectOnHover) {
                n |= 2;
            }
            if (this.openAfterDelay) {
                n |= 4;
            }
        }
        OpenStrategy.setOpenMethod((int)n);
        PrefUtil.savePrefs();
        return true;
    }

    private void updateHeapStatus(boolean bl) {
        IWorkbenchWindow[] iWorkbenchWindowArray = PlatformUI.getWorkbench().getWorkbenchWindows();
        int n = 0;
        while (n < iWorkbenchWindowArray.length) {
            IWorkbenchWindow iWorkbenchWindow = iWorkbenchWindowArray[n];
            if (iWorkbenchWindow instanceof WorkbenchWindow) {
                ((WorkbenchWindow)iWorkbenchWindow).showHeapStatus(bl);
            }
            ++n;
        }
    }
}

