/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.dialogs.ErrorPreferencePage;
import org.eclipse.ui.internal.misc.StatusUtil;
import org.eclipse.ui.internal.preferences.WorkbenchPreferenceExtensionNode;
import org.eclipse.ui.statushandlers.StatusManager;

public class WorkbenchPreferenceNode
extends WorkbenchPreferenceExtensionNode {
    public WorkbenchPreferenceNode(String string, IConfigurationElement iConfigurationElement) {
        super(string, iConfigurationElement);
    }

    public void createPage() {
        IWorkbenchPreferencePage iWorkbenchPreferencePage;
        try {
            iWorkbenchPreferencePage = (IWorkbenchPreferencePage)WorkbenchPlugin.createExtension(this.getConfigurationElement(), "class");
        }
        catch (CoreException coreException) {
            IStatus iStatus = StatusUtil.newStatus(coreException.getStatus(), WorkbenchMessages.PreferenceNode_errorMessage);
            StatusManager.getManager().handle(iStatus, 3);
            iWorkbenchPreferencePage = new ErrorPreferencePage();
        }
        iWorkbenchPreferencePage.init(PlatformUI.getWorkbench());
        if (this.getLabelImage() != null) {
            iWorkbenchPreferencePage.setImageDescriptor(this.getImageDescriptor());
        }
        iWorkbenchPreferencePage.setTitle(this.getLabelText());
        this.setPage(iWorkbenchPreferencePage);
    }

    public String getCategory() {
        return this.getConfigurationElement().getAttribute("category");
    }
}

