/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.dynamichelpers.ExtensionTracker;
import org.eclipse.core.runtime.dynamichelpers.IExtensionChangeHandler;
import org.eclipse.core.runtime.dynamichelpers.IExtensionTracker;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.dialogs.WorkbenchPreferenceNode;
import org.eclipse.ui.internal.misc.StatusUtil;
import org.eclipse.ui.internal.preferences.WorkbenchPreferenceExpressionNode;
import org.eclipse.ui.internal.registry.PreferencePageRegistryReader;

public class WorkbenchPreferenceManager
extends PreferenceManager
implements IExtensionChangeHandler {
    public WorkbenchPreferenceManager(char c) {
        super(c, (PreferenceNode)new WorkbenchPreferenceExpressionNode(""));
        IExtensionTracker iExtensionTracker = PlatformUI.getWorkbench().getExtensionTracker();
        iExtensionTracker.registerHandler((IExtensionChangeHandler)this, ExtensionTracker.createExtensionPointFilter((IExtensionPoint)this.getExtensionPointFilter()));
        Platform.getExtensionRegistry().addRegistryChangeListener(new IRegistryChangeListener(){

            public void registryChanged(IRegistryChangeEvent iRegistryChangeEvent) {
                if (iRegistryChangeEvent.getExtensionDeltas("org.eclipse.ui", "keywords").length > 0) {
                    Iterator iterator = WorkbenchPreferenceManager.this.getElements(1).iterator();
                    while (iterator.hasNext()) {
                        ((WorkbenchPreferenceNode)iterator.next()).clearKeywords();
                    }
                }
            }
        });
    }

    public void addPages(Collection collection) {
        for (Object e : collection) {
            if (!(e instanceof WorkbenchPreferenceNode)) continue;
            WorkbenchPreferenceNode workbenchPreferenceNode = (WorkbenchPreferenceNode)e;
            this.addToRoot((IPreferenceNode)workbenchPreferenceNode);
            this.registerNode(workbenchPreferenceNode);
        }
    }

    private void registerNode(WorkbenchPreferenceNode workbenchPreferenceNode) {
        PlatformUI.getWorkbench().getExtensionTracker().registerObject(workbenchPreferenceNode.getConfigurationElement().getDeclaringExtension(), (Object)workbenchPreferenceNode, 2);
        IPreferenceNode[] iPreferenceNodeArray = workbenchPreferenceNode.getSubNodes();
        int n = 0;
        while (n < iPreferenceNodeArray.length) {
            this.registerNode((WorkbenchPreferenceNode)iPreferenceNodeArray[n]);
            ++n;
        }
    }

    public void addExtension(IExtensionTracker iExtensionTracker, IExtension iExtension) {
        IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            WorkbenchPreferenceNode workbenchPreferenceNode = PreferencePageRegistryReader.createNode(iConfigurationElementArray[n]);
            if (workbenchPreferenceNode != null) {
                this.registerNode(workbenchPreferenceNode);
                String string = workbenchPreferenceNode.getCategory();
                if (string == null) {
                    this.addToRoot((IPreferenceNode)workbenchPreferenceNode);
                } else {
                    IPreferenceNode iPreferenceNode = null;
                    for (IPreferenceNode iPreferenceNode2 : this.getElements(1)) {
                        if (!string.equals(iPreferenceNode2.getId())) continue;
                        iPreferenceNode = iPreferenceNode2;
                        break;
                    }
                    if (iPreferenceNode == null) {
                        String string2 = "Invalid preference category path: " + string + " (bundle: " + workbenchPreferenceNode.getPluginId() + ", page: " + workbenchPreferenceNode.getId() + ")";
                        WorkbenchPlugin.log(StatusUtil.newStatus(2, string2, null));
                        this.addToRoot((IPreferenceNode)workbenchPreferenceNode);
                    } else {
                        iPreferenceNode.add((IPreferenceNode)workbenchPreferenceNode);
                    }
                }
            }
            ++n;
        }
    }

    private IExtensionPoint getExtensionPointFilter() {
        return Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ui", "preferencePages");
    }

    public void removeExtension(IExtension iExtension, Object[] objectArray) {
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] instanceof IPreferenceNode) {
                IPreferenceNode iPreferenceNode = (IPreferenceNode)objectArray[n];
                iPreferenceNode.disposeResources();
                this.deepRemove(this.getRoot(), iPreferenceNode);
            }
            ++n;
        }
    }

    private boolean deepRemove(IPreferenceNode iPreferenceNode, IPreferenceNode iPreferenceNode2) {
        if (iPreferenceNode == iPreferenceNode2 && iPreferenceNode == this.getRoot()) {
            this.removeAll();
            return true;
        }
        if (iPreferenceNode.remove(iPreferenceNode2)) {
            return true;
        }
        IPreferenceNode[] iPreferenceNodeArray = iPreferenceNode.getSubNodes();
        int n = 0;
        while (n < iPreferenceNodeArray.length) {
            if (this.deepRemove(iPreferenceNodeArray[n], iPreferenceNode2)) {
                return true;
            }
            ++n;
        }
        return false;
    }
}

