/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.dialogs.FilteredPreferenceDialog;
import org.eclipse.ui.internal.dnd.SwtUtil;

public class WorkbenchPreferenceDialog
extends FilteredPreferenceDialog {
    private static WorkbenchPreferenceDialog instance = null;
    private static final String DIALOG_SETTINGS_SECTION = "WorkbenchPreferenceDialogSettings";
    private String initialPageId;

    public static final WorkbenchPreferenceDialog createDialogOn(Shell shell, String string) {
        WorkbenchPreferenceDialog workbenchPreferenceDialog;
        if (instance == null) {
            IWorkbench iWorkbench;
            Object object = shell;
            if (object == null) {
                iWorkbench = PlatformUI.getWorkbench();
                IWorkbenchWindow iWorkbenchWindow = iWorkbench.getActiveWorkbenchWindow();
                object = iWorkbenchWindow != null ? iWorkbenchWindow.getShell() : null;
            }
            iWorkbench = PlatformUI.getWorkbench().getPreferenceManager();
            workbenchPreferenceDialog = new WorkbenchPreferenceDialog((Shell)object, (PreferenceManager)iWorkbench);
            if (string != null) {
                workbenchPreferenceDialog.setSelectedNode(string);
                workbenchPreferenceDialog.setInitialPage(string);
            }
            workbenchPreferenceDialog.create();
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)workbenchPreferenceDialog.getShell(), "org.eclipse.ui.preference_dialog_context");
        } else {
            workbenchPreferenceDialog = instance;
            if (string != null) {
                workbenchPreferenceDialog.setCurrentPageId(string);
                workbenchPreferenceDialog.setInitialPage(string);
            }
        }
        return workbenchPreferenceDialog;
    }

    public WorkbenchPreferenceDialog(Shell shell, PreferenceManager preferenceManager) {
        super(shell, preferenceManager);
        Assert.isTrue((instance == null ? 1 : 0) != 0, (String)"There cannot be two preference dialogs at once in the workbench.");
        instance = this;
    }

    @Override
    public boolean close() {
        instance = null;
        return super.close();
    }

    @Override
    protected IPreferenceNode findNodeMatching(String string) {
        IPreferenceNode iPreferenceNode = super.findNodeMatching(string);
        if (WorkbenchActivityHelper.filterItem(iPreferenceNode)) {
            return null;
        }
        return iPreferenceNode;
    }

    @Override
    protected void okPressed() {
        super.okPressed();
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings iDialogSettings = WorkbenchPlugin.getDefault().getDialogSettings();
        IDialogSettings iDialogSettings2 = iDialogSettings.getSection(DIALOG_SETTINGS_SECTION);
        if (iDialogSettings2 == null) {
            iDialogSettings2 = iDialogSettings.addNewSection(DIALOG_SETTINGS_SECTION);
        }
        return iDialogSettings2;
    }

    protected int getDialogBoundsStrategy() {
        return 1;
    }

    public int open() {
        Shell shell;
        IPreferencePage iPreferencePage = this.getCurrentPage();
        if (this.initialPageId != null && iPreferencePage != null && (shell = this.getShell()) != null && !shell.isDisposed()) {
            shell.open();
            Control control = iPreferencePage.getControl();
            if (!SwtUtil.isFocusAncestor(control)) {
                control.setFocus();
            }
        }
        return super.open();
    }

    public void setInitialPage(String string) {
        this.initialPageId = string;
    }
}

