/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import com.ibm.icu.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.ISaveablesLifecycleListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.internal.EditorManager;
import org.eclipse.ui.internal.SaveablesList;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPartReference;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.layout.CellData;
import org.eclipse.ui.internal.layout.CellLayout;
import org.eclipse.ui.internal.layout.Row;

public class WorkbenchEditorsDialog
extends SelectionDialog {
    private IWorkbenchWindow window;
    private Table editorsTable;
    private Button saveSelected;
    private Button closeSelected;
    private Button selectClean;
    private Button invertSelection;
    private Button allSelection;
    private boolean showAllPersp = false;
    private int sortColumn;
    private List elements = new ArrayList();
    private HashMap imageCache = new HashMap(11);
    private HashMap disabledImageCache = new HashMap(11);
    private boolean reverse = false;
    private Collator collator = Collator.getInstance();
    private Rectangle bounds;
    private int[] columnsWidth;
    private static final String SORT = "sort";
    private static final String ALLPERSP = "allPersp";
    private static final String BOUNDS = "bounds";
    private static final String COLUMNS = "columns";
    private SelectionListener headerListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            TableColumn tableColumn = (TableColumn)selectionEvent.widget;
            int n = WorkbenchEditorsDialog.this.editorsTable.indexOf(tableColumn);
            if (n == WorkbenchEditorsDialog.this.sortColumn) {
                WorkbenchEditorsDialog.this.reverse = !WorkbenchEditorsDialog.this.reverse;
            } else {
                WorkbenchEditorsDialog.this.sortColumn = n;
            }
            WorkbenchEditorsDialog.this.editorsTable.setSortDirection(WorkbenchEditorsDialog.this.reverse ? 1024 : 128);
            WorkbenchEditorsDialog.this.editorsTable.setSortColumn(tableColumn);
            WorkbenchEditorsDialog.this.updateItems();
        }
    };

    public WorkbenchEditorsDialog(IWorkbenchWindow iWorkbenchWindow) {
        super(iWorkbenchWindow.getShell());
        this.window = iWorkbenchWindow;
        this.setTitle(WorkbenchMessages.WorkbenchEditorsDialog_title);
        IDialogSettings iDialogSettings = this.getDialogSettings();
        if (iDialogSettings.get(ALLPERSP) == null) {
            this.sortColumn = 0;
        } else {
            this.showAllPersp = iDialogSettings.getBoolean(ALLPERSP);
            this.sortColumn = iDialogSettings.getInt(SORT);
            String[] stringArray = iDialogSettings.getArray(BOUNDS);
            if (stringArray != null) {
                this.bounds = new Rectangle(0, 0, 0, 0);
                this.bounds.x = new Integer(stringArray[0]);
                this.bounds.y = new Integer(stringArray[1]);
                this.bounds.width = new Integer(stringArray[2]);
                this.bounds.height = new Integer(stringArray[3]);
            }
            if ((stringArray = iDialogSettings.getArray(COLUMNS)) != null) {
                this.columnsWidth = new int[stringArray.length];
                int n = 0;
                while (n < this.columnsWidth.length) {
                    this.columnsWidth[n] = new Integer(stringArray[n]);
                    ++n;
                }
            }
        }
        this.setShellStyle(this.getShellStyle() | 0x10000000);
    }

    @Override
    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.ui.workbench_editors_dialog");
    }

    @Override
    protected void createButtonsForButtonBar(Composite composite) {
        this.createButton(composite, 1, IDialogConstants.CANCEL_LABEL, false);
        Button button = this.getButton(1);
        if (button != null) {
            button.setText(WorkbenchMessages.WorkbenchEditorsDialog_close);
        }
    }

    protected void initializeBounds() {
        if (this.bounds != null) {
            this.getShell().setBounds(this.bounds);
        } else {
            super.initializeBounds();
        }
    }

    protected Control createDialogArea(Composite composite) {
        this.initializeDialogUnits((Control)composite);
        Font font = composite.getFont();
        Composite composite2 = new Composite(composite, 0);
        CellLayout cellLayout = new CellLayout(1).setMargins(this.convertHorizontalDLUsToPixels(7), this.convertVerticalDLUsToPixels(7)).setSpacing(this.convertHorizontalDLUsToPixels(4), this.convertVerticalDLUsToPixels(4)).setRow(1, Row.growing());
        composite2.setLayout((Layout)cellLayout);
        composite2.setLayoutData((Object)new GridData(1808));
        Label label = new Label(composite2, 0);
        label.setText(WorkbenchMessages.WorkbenchEditorsDialog_label);
        label.setFont(font);
        label.setLayoutData((Object)new CellData().align(4, 0x1000000));
        this.editorsTable = new Table(composite2, 68354);
        this.editorsTable.setLinesVisible(true);
        this.editorsTable.setHeaderVisible(true);
        this.editorsTable.setFont(font);
        final int n = 16 * this.editorsTable.getItemHeight();
        final int n2 = (int)(2.5 * (double)n);
        CellData cellData = new CellData().align(4, 4).setHint(1, n2, n);
        this.editorsTable.setLayoutData((Object)cellData);
        this.editorsTable.setLayout(new Layout(){

            protected Point computeSize(Composite composite, int n3, int n22, boolean bl) {
                return new Point(n2, n);
            }

            protected void layout(Composite composite, boolean bl) {
                TableColumn[] tableColumnArray = WorkbenchEditorsDialog.this.editorsTable.getColumns();
                if (WorkbenchEditorsDialog.this.columnsWidth == null) {
                    int n3 = ((WorkbenchEditorsDialog)WorkbenchEditorsDialog.this).editorsTable.getClientArea().width;
                    tableColumnArray[0].setWidth(n3 * 1 / 3);
                    tableColumnArray[1].setWidth(n3 - tableColumnArray[0].getWidth());
                } else {
                    tableColumnArray[0].setWidth(WorkbenchEditorsDialog.this.columnsWidth[0]);
                    tableColumnArray[1].setWidth(WorkbenchEditorsDialog.this.columnsWidth[1]);
                }
                WorkbenchEditorsDialog.this.editorsTable.setLayout(null);
            }
        });
        TableColumn tableColumn = new TableColumn(this.editorsTable, 0);
        tableColumn.setResizable(true);
        tableColumn.setText(WorkbenchMessages.WorkbenchEditorsDialog_name);
        tableColumn.addSelectionListener(this.headerListener);
        tableColumn = new TableColumn(this.editorsTable, 0);
        tableColumn.setResizable(true);
        tableColumn.setText(WorkbenchMessages.WorkbenchEditorsDialog_path);
        tableColumn.addSelectionListener(this.headerListener);
        Composite composite3 = new Composite(composite2, 0);
        Label label2 = new Label(composite3, 0);
        label2.setFont(font);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        composite3.setLayout((Layout)gridLayout);
        this.selectClean = new Button(composite3, 8);
        this.selectClean.setText(WorkbenchMessages.WorkbenchEditorsDialog_selectClean);
        this.selectClean.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                WorkbenchEditorsDialog.this.editorsTable.setSelection(WorkbenchEditorsDialog.this.selectClean(WorkbenchEditorsDialog.this.editorsTable.getItems()));
                WorkbenchEditorsDialog.this.updateButtons();
            }
        });
        this.selectClean.setFont(font);
        this.setButtonLayoutData(this.selectClean);
        this.invertSelection = new Button(composite3, 8);
        this.invertSelection.setText(WorkbenchMessages.WorkbenchEditorsDialog_invertSelection);
        this.invertSelection.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                WorkbenchEditorsDialog.this.editorsTable.setSelection(WorkbenchEditorsDialog.this.invertedSelection(WorkbenchEditorsDialog.this.editorsTable.getItems(), WorkbenchEditorsDialog.this.editorsTable.getSelection()));
                WorkbenchEditorsDialog.this.updateButtons();
            }
        });
        this.invertSelection.setFont(font);
        this.setButtonLayoutData(this.invertSelection);
        this.allSelection = new Button(composite3, 8);
        this.allSelection.setText(WorkbenchMessages.WorkbenchEditorsDialog_allSelection);
        this.allSelection.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                WorkbenchEditorsDialog.this.editorsTable.setSelection(WorkbenchEditorsDialog.this.editorsTable.getItems());
                WorkbenchEditorsDialog.this.updateButtons();
            }
        });
        this.allSelection.setFont(font);
        this.setButtonLayoutData(this.allSelection);
        Composite composite4 = new Composite(composite2, 0);
        Label label3 = new Label(composite4, 0);
        label3.setFont(font);
        GridLayout gridLayout2 = new GridLayout();
        gridLayout2.numColumns = 4;
        composite4.setLayout((Layout)gridLayout2);
        this.createButton(composite4, 0, WorkbenchMessages.WorkbenchEditorsDialog_activate, true);
        this.closeSelected = new Button(composite4, 8);
        this.closeSelected.setText(WorkbenchMessages.WorkbenchEditorsDialog_closeSelected);
        this.closeSelected.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                WorkbenchEditorsDialog.this.closeItems(WorkbenchEditorsDialog.this.editorsTable.getSelection());
            }
        });
        this.closeSelected.setFont(font);
        this.setButtonLayoutData(this.closeSelected);
        this.saveSelected = new Button(composite4, 8);
        this.saveSelected.setText(WorkbenchMessages.WorkbenchEditorsDialog_saveSelected);
        this.saveSelected.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                WorkbenchEditorsDialog.this.saveItems(WorkbenchEditorsDialog.this.editorsTable.getSelection());
            }
        });
        this.saveSelected.setFont(font);
        this.setButtonLayoutData(this.saveSelected);
        final Button button = new Button(composite2, 32);
        button.setText(WorkbenchMessages.WorkbenchEditorsDialog_showAllPersp);
        button.setSelection(this.showAllPersp);
        button.setFont(font);
        this.setButtonLayoutData(button);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                WorkbenchEditorsDialog.this.showAllPersp = button.getSelection();
                WorkbenchEditorsDialog.this.updateItems();
            }
        });
        this.updateItems();
        this.updateButtons();
        this.editorsTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                WorkbenchEditorsDialog.this.updateButtons();
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                WorkbenchEditorsDialog.this.okPressed();
            }
        });
        this.editorsTable.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                for (Image image : WorkbenchEditorsDialog.this.imageCache.values()) {
                    image.dispose();
                }
                for (Image image : WorkbenchEditorsDialog.this.disabledImageCache.values()) {
                    image.dispose();
                }
            }
        });
        this.editorsTable.setFocus();
        WorkbenchEditorsDialog.applyDialogFont((Control)composite2);
        return composite2;
    }

    private void updateButtons() {
        TableItem[] tableItemArray = this.editorsTable.getSelection();
        boolean bl = false;
        int n = 0;
        while (n < tableItemArray.length) {
            Adapter adapter = (Adapter)tableItemArray[n].getData();
            if (adapter.isDirty()) {
                bl = true;
                break;
            }
            ++n;
        }
        this.saveSelected.setEnabled(bl);
        TableItem[] tableItemArray2 = this.editorsTable.getItems();
        boolean bl2 = false;
        int n2 = 0;
        while (n2 < tableItemArray2.length) {
            Adapter adapter = (Adapter)tableItemArray2[n2].getData();
            if (!adapter.isDirty()) {
                bl2 = true;
                break;
            }
            ++n2;
        }
        this.selectClean.setEnabled(bl2);
        this.invertSelection.setEnabled(tableItemArray2.length > 0);
        this.closeSelected.setEnabled(tableItemArray.length > 0);
        Button button = this.getOkButton();
        if (button != null) {
            button.setEnabled(tableItemArray.length == 1);
        }
    }

    private void closeItems(TableItem[] tableItemArray) {
        Object object;
        if (tableItemArray.length == 0) {
            return;
        }
        ArrayList<IWorkbenchPart> arrayList = new ArrayList<IWorkbenchPart>();
        int n = 0;
        while (n < tableItemArray.length) {
            Adapter adapter = (Adapter)tableItemArray[n].getData();
            if (adapter.editorRef != null && (object = adapter.editorRef.getPart(false)) != null) {
                arrayList.add((IWorkbenchPart)object);
            }
            ++n;
        }
        SaveablesList saveablesList = (SaveablesList)this.window.getService(ISaveablesLifecycleListener.class);
        if (saveablesList.preCloseParts(arrayList, true, (IShellProvider)this, this.window) != null) {
            int n2 = 0;
            while (n2 < tableItemArray.length) {
                object = (Adapter)tableItemArray[n2].getData();
                ((Adapter)object).close();
                ++n2;
            }
            this.updateItems();
        }
    }

    private void saveItems(TableItem[] tableItemArray) {
        if (tableItemArray.length == 0) {
            return;
        }
        ArrayList<IWorkbenchPart> arrayList = new ArrayList<IWorkbenchPart>();
        int n = 0;
        while (n < tableItemArray.length) {
            IWorkbenchPart iWorkbenchPart;
            Adapter adapter = (Adapter)tableItemArray[n].getData();
            if (adapter.editorRef != null && (iWorkbenchPart = adapter.editorRef.getPart(false)) != null) {
                arrayList.add(iWorkbenchPart);
            }
            ++n;
        }
        EditorManager.saveAll(arrayList, false, false, false, this.window);
        this.updateItems();
    }

    private TableItem[] selectClean(TableItem[] tableItemArray) {
        if (tableItemArray.length == 0) {
            return new TableItem[0];
        }
        ArrayList<TableItem> arrayList = new ArrayList<TableItem>(tableItemArray.length);
        int n = 0;
        while (n < tableItemArray.length) {
            Adapter adapter = (Adapter)tableItemArray[n].getData();
            if (!adapter.isDirty()) {
                arrayList.add(tableItemArray[n]);
            }
            ++n;
        }
        TableItem[] tableItemArray2 = new TableItem[arrayList.size()];
        arrayList.toArray(tableItemArray2);
        return tableItemArray2;
    }

    private TableItem[] invertedSelection(TableItem[] tableItemArray, TableItem[] tableItemArray2) {
        if (tableItemArray.length == 0) {
            return tableItemArray;
        }
        ArrayList<TableItem> arrayList = new ArrayList<TableItem>(tableItemArray.length - tableItemArray2.length);
        int n = 0;
        while (n < tableItemArray.length) {
            block4: {
                int n2 = 0;
                while (n2 < tableItemArray2.length) {
                    if (tableItemArray[n] != tableItemArray2[n2]) {
                        ++n2;
                        continue;
                    }
                    break block4;
                }
                arrayList.add(tableItemArray[n]);
            }
            ++n;
        }
        TableItem[] tableItemArray3 = new TableItem[arrayList.size()];
        arrayList.toArray(tableItemArray3);
        return tableItemArray3;
    }

    private void updateItem(TableItem tableItem, Adapter adapter) {
        tableItem.setData((Object)adapter);
        tableItem.setText(adapter.getText());
        Image image = adapter.getImage();
        if (image != null) {
            tableItem.setImage(0, image);
        }
    }

    private void updateEditors(IWorkbenchPage[] iWorkbenchPageArray) {
        int n = 0;
        while (n < iWorkbenchPageArray.length) {
            IEditorReference[] iEditorReferenceArray = iWorkbenchPageArray[n].getEditorReferences();
            int n2 = 0;
            while (n2 < iEditorReferenceArray.length) {
                this.elements.add(new Adapter(iEditorReferenceArray[n2]));
                ++n2;
            }
            ++n;
        }
    }

    private void updateItems() {
        Object object;
        TableItem[] tableItemArray = this.editorsTable.getSelection();
        Adapter[] adapterArray = new Adapter[tableItemArray.length];
        int n = 0;
        while (n < tableItemArray.length) {
            adapterArray[n] = (Adapter)tableItemArray[n].getData();
            ++n;
        }
        this.editorsTable.removeAll();
        this.elements = new ArrayList();
        if (this.showAllPersp) {
            object = this.window.getWorkbench().getWorkbenchWindows();
            int n2 = 0;
            while (n2 < ((IWorkbenchWindow[])object).length) {
                this.updateEditors(object[n2].getPages());
                ++n2;
            }
        } else {
            object = this.window.getActivePage();
            if (object != null) {
                this.updateEditors(new IWorkbenchPage[]{object});
            }
        }
        this.sort();
        object = new ArrayList(tableItemArray.length);
        for (Adapter adapter : this.elements) {
            TableItem tableItem = new TableItem(this.editorsTable, 0);
            this.updateItem(tableItem, adapter);
            int n3 = 0;
            while (n3 < adapterArray.length) {
                if (adapterArray[n3].editorRef == adapter.editorRef) {
                    object.add(tableItem);
                }
                ++n3;
            }
        }
        this.editorsTable.setSelection(object.toArray(new TableItem[object.size()]));
        this.updateButtons();
    }

    private void sort() {
        if (this.sortColumn > this.editorsTable.getColumnCount() - 1) {
            this.sortColumn = 0;
        }
        Object[] objectArray = new Adapter[this.elements.size()];
        this.elements.toArray(objectArray);
        Arrays.sort(objectArray);
        this.elements = Arrays.asList(objectArray);
    }

    protected void okPressed() {
        TableItem[] tableItemArray = this.editorsTable.getSelection();
        if (tableItemArray.length != 1) {
            super.okPressed();
            return;
        }
        Adapter adapter = (Adapter)tableItemArray[0].getData();
        super.okPressed();
        adapter.activate();
    }

    public boolean close() {
        this.saveDialogSettings();
        return super.close();
    }

    private void saveDialogSettings() {
        IDialogSettings iDialogSettings = this.getDialogSettings();
        iDialogSettings.put(ALLPERSP, this.showAllPersp);
        iDialogSettings.put(SORT, this.sortColumn);
        this.bounds = this.getShell().getBounds();
        String[] stringArray = new String[]{String.valueOf(this.bounds.x), String.valueOf(this.bounds.y), String.valueOf(this.bounds.width), String.valueOf(this.bounds.height)};
        iDialogSettings.put(BOUNDS, stringArray);
        stringArray = new String[this.editorsTable.getColumnCount()];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = String.valueOf(this.editorsTable.getColumn(n).getWidth());
            ++n;
        }
        iDialogSettings.put(COLUMNS, stringArray);
    }

    private IDialogSettings getDialogSettings() {
        IDialogSettings iDialogSettings = WorkbenchPlugin.getDefault().getDialogSettings();
        IDialogSettings iDialogSettings2 = iDialogSettings.getSection(((Object)((Object)this)).getClass().getName());
        if (iDialogSettings2 == null) {
            iDialogSettings2 = iDialogSettings.addNewSection(((Object)((Object)this)).getClass().getName());
        }
        return iDialogSettings2;
    }

    private class Adapter
    implements Comparable {
        IEditorReference editorRef;
        IEditorInput input;
        IEditorDescriptor desc;
        String[] text;
        Image image;

        Adapter(IEditorReference iEditorReference) {
            this.editorRef = iEditorReference;
        }

        boolean isDirty() {
            if (this.editorRef == null) {
                return false;
            }
            return this.editorRef.isDirty();
        }

        void close() {
            if (this.editorRef == null) {
                return;
            }
            WorkbenchPage workbenchPage = ((WorkbenchPartReference)((Object)this.editorRef)).getPane().getPage();
            workbenchPage.closeEditor(this.editorRef, false);
        }

        String[] getText() {
            if (this.text != null) {
                return this.text;
            }
            this.text = new String[2];
            if (this.editorRef != null) {
                this.text[0] = this.editorRef.isDirty() ? "*" + this.editorRef.getTitle() : this.editorRef.getTitle();
                this.text[1] = this.editorRef.getTitleToolTip();
            } else {
                this.text[0] = this.input.getName();
                this.text[1] = this.input.getToolTipText();
            }
            if (this.text[0] != null) {
                this.text[0] = TextProcessor.process((String)this.text[0]);
            }
            if (this.text[1] != null) {
                this.text[1] = TextProcessor.process((String)this.text[1]);
            }
            return this.text;
        }

        Image getImage() {
            if (this.image != null) {
                return this.image;
            }
            if (this.editorRef != null) {
                this.image = this.editorRef.getTitleImage();
            } else {
                IEditorRegistry iEditorRegistry;
                ImageDescriptor imageDescriptor = null;
                if (this.desc != null) {
                    imageDescriptor = this.desc.getImageDescriptor();
                }
                if (imageDescriptor == null) {
                    iEditorRegistry = WorkbenchPlugin.getDefault().getEditorRegistry();
                    imageDescriptor = iEditorRegistry.getImageDescriptor(this.input.getName());
                }
                if (imageDescriptor != null) {
                    this.image = (Image)WorkbenchEditorsDialog.this.disabledImageCache.get(imageDescriptor);
                    if (this.image == null) {
                        iEditorRegistry = imageDescriptor.createImage();
                        Image image = new Image((Device)WorkbenchEditorsDialog.this.editorsTable.getDisplay(), (Image)iEditorRegistry, 1);
                        iEditorRegistry.dispose();
                        WorkbenchEditorsDialog.this.disabledImageCache.put(imageDescriptor, image);
                        this.image = image;
                    }
                }
            }
            return this.image;
        }

        private void activate() {
            if (this.editorRef != null) {
                IEditorPart iEditorPart = this.editorRef.getEditor(true);
                WorkbenchPage workbenchPage = (WorkbenchPage)iEditorPart.getEditorSite().getPage();
                Shell shell = workbenchPage.getWorkbenchWindow().getShell();
                if (shell.getMinimized()) {
                    shell.setMinimized(false);
                }
                shell.moveAbove(null);
                workbenchPage.getWorkbenchWindow().setActivePage(workbenchPage);
                workbenchPage.activate(iEditorPart);
            } else {
                IWorkbenchPage iWorkbenchPage = WorkbenchEditorsDialog.this.window.getActivePage();
                if (iWorkbenchPage != null) {
                    try {
                        iWorkbenchPage.openEditor(this.input, this.desc.getId(), true);
                    }
                    catch (PartInitException partInitException) {}
                }
            }
        }

        public int compareTo(Object object) {
            Adapter adapter = (Adapter)object;
            int n = WorkbenchEditorsDialog.this.collator.compare(this.getText()[WorkbenchEditorsDialog.this.sortColumn], adapter.getText()[WorkbenchEditorsDialog.this.sortColumn]);
            if (n == 0) {
                int n2 = WorkbenchEditorsDialog.this.sortColumn == 0 ? 1 : 0;
                n = WorkbenchEditorsDialog.this.collator.compare(this.getText()[n2], adapter.getText()[n2]);
            }
            if (WorkbenchEditorsDialog.this.reverse) {
                return n * -1;
            }
            return n;
        }
    }
}

