/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import java.util.ArrayList;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.dialogs.WorkbenchWizardElement;
import org.eclipse.ui.model.AdaptableList;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.model.WorkbenchAdapter;
import org.eclipse.ui.wizards.IWizardCategory;
import org.eclipse.ui.wizards.IWizardDescriptor;

public class WizardCollectionElement
extends AdaptableList
implements IPluginContribution,
IWizardCategory {
    private String id;
    private String pluginId;
    private String name;
    private WizardCollectionElement parent;
    private AdaptableList wizards = new AdaptableList();
    private IConfigurationElement configElement;

    public WizardCollectionElement(String string, String string2, String string3, WizardCollectionElement wizardCollectionElement) {
        this.name = string3;
        this.id = string;
        this.pluginId = string2;
        this.parent = wizardCollectionElement;
    }

    public WizardCollectionElement(IConfigurationElement iConfigurationElement, WizardCollectionElement wizardCollectionElement) {
        this.configElement = iConfigurationElement;
        this.id = this.configElement.getAttribute("id");
        this.parent = wizardCollectionElement;
    }

    @Override
    public AdaptableList add(IAdaptable iAdaptable) {
        if (iAdaptable instanceof WorkbenchWizardElement) {
            this.wizards.add(iAdaptable);
        } else {
            super.add(iAdaptable);
        }
        return this;
    }

    @Override
    public void remove(IAdaptable iAdaptable) {
        if (iAdaptable instanceof WorkbenchWizardElement) {
            this.wizards.remove(iAdaptable);
        } else {
            super.remove(iAdaptable);
        }
    }

    public WizardCollectionElement findChildCollection(IPath iPath) {
        Object[] objectArray = this.getChildren(null);
        String string = iPath.segment(0);
        int n = 0;
        while (n < objectArray.length) {
            WizardCollectionElement wizardCollectionElement = (WizardCollectionElement)objectArray[n];
            if (wizardCollectionElement.getId().equals(string)) {
                if (iPath.segmentCount() == 1) {
                    return wizardCollectionElement;
                }
                return wizardCollectionElement.findChildCollection(iPath.removeFirstSegments(1));
            }
            ++n;
        }
        return null;
    }

    public WizardCollectionElement findCategory(String string) {
        Object[] objectArray = this.getChildren(null);
        int n = 0;
        while (n < objectArray.length) {
            WizardCollectionElement wizardCollectionElement = (WizardCollectionElement)objectArray[n];
            if (string.equals(wizardCollectionElement.getId())) {
                return wizardCollectionElement;
            }
            WizardCollectionElement wizardCollectionElement2 = wizardCollectionElement.findCategory(string);
            if (wizardCollectionElement2 != null) {
                return wizardCollectionElement2;
            }
            ++n;
        }
        return null;
    }

    public WorkbenchWizardElement findWizard(String string, boolean bl) {
        IWizardDescriptor[] iWizardDescriptorArray = this.getWizards();
        int n = 0;
        while (n < iWizardDescriptorArray.length) {
            WorkbenchAdapter workbenchAdapter = (WorkbenchWizardElement)iWizardDescriptorArray[n];
            if (((WorkbenchWizardElement)workbenchAdapter).getId().equals(string)) {
                return workbenchAdapter;
            }
            ++n;
        }
        if (!bl) {
            return null;
        }
        for (WorkbenchAdapter workbenchAdapter : this.children) {
            WorkbenchWizardElement workbenchWizardElement = ((WizardCollectionElement)workbenchAdapter).findWizard(string, true);
            if (workbenchWizardElement == null) continue;
            return workbenchWizardElement;
        }
        return null;
    }

    @Override
    public Object getAdapter(Class clazz) {
        if (clazz == IWorkbenchAdapter.class) {
            return this;
        }
        return Platform.getAdapterManager().getAdapter((Object)this, clazz);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getLabel(Object object) {
        return this.configElement != null ? this.configElement.getAttribute("name") : this.name;
    }

    @Override
    public Object getParent(Object object) {
        return this.parent;
    }

    @Override
    public IPath getPath() {
        if (this.parent == null) {
            return new Path("");
        }
        return this.parent.getPath().append(this.getId());
    }

    @Override
    public IWizardDescriptor[] getWizards() {
        return this.getWizardsExpression((IWizardDescriptor[])this.wizards.getTypedChildren(IWizardDescriptor.class));
    }

    private IWizardDescriptor[] getWizardsExpression(IWizardDescriptor[] iWizardDescriptorArray) {
        int n = iWizardDescriptorArray.length;
        ArrayList<IWizardDescriptor> arrayList = new ArrayList<IWizardDescriptor>(n);
        int n2 = 0;
        while (n2 < n) {
            if (!WorkbenchActivityHelper.restrictUseOf((WorkbenchWizardElement)iWizardDescriptorArray[n2])) {
                arrayList.add(iWizardDescriptorArray[n2]);
            }
            ++n2;
        }
        return arrayList.toArray(new IWizardDescriptor[arrayList.size()]);
    }

    public WorkbenchWizardElement[] getWorkbenchWizardElements() {
        return this.getWorkbenchWizardElementsExpression((WorkbenchWizardElement[])this.wizards.getTypedChildren(WorkbenchWizardElement.class));
    }

    private WorkbenchWizardElement[] getWorkbenchWizardElementsExpression(WorkbenchWizardElement[] workbenchWizardElementArray) {
        int n = workbenchWizardElementArray.length;
        ArrayList<WorkbenchWizardElement> arrayList = new ArrayList<WorkbenchWizardElement>(n);
        int n2 = 0;
        while (n2 < n) {
            WorkbenchWizardElement workbenchWizardElement = workbenchWizardElementArray[n2];
            if (!WorkbenchActivityHelper.restrictUseOf(workbenchWizardElement)) {
                arrayList.add(workbenchWizardElement);
            }
            ++n2;
        }
        return arrayList.toArray(new WorkbenchWizardElement[arrayList.size()]);
    }

    public boolean isEmpty() {
        return this.size() == 0 && this.wizards.size() == 0;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("WizardCollection, ");
        stringBuffer.append(this.children.size());
        stringBuffer.append(" children, ");
        stringBuffer.append(this.wizards.size());
        stringBuffer.append(" wizards");
        return stringBuffer.toString();
    }

    @Override
    public ImageDescriptor getImageDescriptor(Object object) {
        return WorkbenchImages.getImageDescriptor("IMG_OBJ_FOLDER");
    }

    @Override
    public String getLocalId() {
        return this.getId();
    }

    @Override
    public String getPluginId() {
        return this.configElement != null ? this.configElement.getNamespace() : this.pluginId;
    }

    @Override
    public IWizardCategory getParent() {
        return this.parent;
    }

    @Override
    public IWizardCategory[] getCategories() {
        return (IWizardCategory[])this.getTypedChildren(IWizardCategory.class);
    }

    public WizardCollectionElement[] getCollectionElements() {
        return (WizardCollectionElement[])this.getTypedChildren(WizardCollectionElement.class);
    }

    public AdaptableList getWizardAdaptableList() {
        return this.wizards;
    }

    @Override
    public String getLabel() {
        return this.getLabel(this);
    }

    public IConfigurationElement getConfigurationElement() {
        return this.configElement;
    }

    public WizardCollectionElement getParentCollection() {
        return this.parent;
    }

    @Override
    public IWizardDescriptor findWizard(String string) {
        return this.findWizard(string, true);
    }

    @Override
    public IWizardCategory findCategory(IPath iPath) {
        return this.findChildCollection(iPath);
    }
}

