/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import com.ibm.icu.text.Collator;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Locale;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.themes.IThemeDescriptor;
import org.eclipse.ui.internal.util.PrefUtil;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.themes.ITheme;

public class ViewsPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Button showTextOnPerspectiveBar;
    private Button showTraditionalStyleTabs;
    private Button enableAnimations;
    private Button useColoredLabels;
    private Button editorTopButton;
    private Button editorBottomButton;
    private Button viewTopButton;
    private Button viewBottomButton;
    private Button perspLeftButton;
    private Button perspTopLeftButton;
    private Button perspTopRightButton;
    static final String EDITORS_TITLE = WorkbenchMessages.ViewsPreference_editors;
    private static final String EDITORS_TOP_TITLE = WorkbenchMessages.ViewsPreference_editors_top;
    private static final String EDITORS_BOTTOM_TITLE = WorkbenchMessages.ViewsPreference_editors_bottom;
    private static final String VIEWS_TITLE = WorkbenchMessages.ViewsPreference_views;
    private static final String VIEWS_TOP_TITLE = WorkbenchMessages.ViewsPreference_views_top;
    private static final String VIEWS_BOTTOM_TITLE = WorkbenchMessages.ViewsPreference_views_bottom;
    private static final String PERSP_TITLE = WorkbenchMessages.ViewsPreference_perspectiveBar;
    private static final String PERSP_LEFT_TITLE = WorkbenchMessages.ViewsPreference_perspectiveBar_left;
    private static final String PERSP_TOP_LEFT_TITLE = WorkbenchMessages.ViewsPreference_perspectiveBar_topLeft;
    private static final String PERSP_TOP_RIGHT_TITLE = WorkbenchMessages.ViewsPreference_perspectiveBar_topRight;
    private static final String R21PRESENTATION_ID = "org.eclipse.ui.internal.r21presentationFactory";
    private static final String DEFAULT_PRESENTATION_ID = "org.eclipse.ui.presentations.default";
    private static final String R30_PRESENTATION_ID = "org.eclipse.ui.presentations.r30";
    private static final String INITIAL_VAL = new String();
    private static final int INITIAL_LOC_INT = -1;
    private String fastViewLoc = INITIAL_VAL;
    private String showTextOnPerspBar = INITIAL_VAL;
    private int editorAlignment;
    private boolean editorAlignmentChanged = false;
    private int viewAlignment;
    private boolean viewAlignmentChanged = false;
    private String perspBarLocation;
    private Combo themeCombo;
    private Combo presentationCombo;
    private IConfigurationElement[] presentationFactories;
    private String currentPresentationFactoryId;
    private Button overridePresButton;
    private IPropertyChangeListener overrideListener;
    private boolean restartPosted = false;
    private Group editorTabGroup;
    private Group viewTabGroup;
    private Group perspBarTabGroup;
    private Text themeDescriptionText;

    private Group createButtonGroup(Composite composite, String string) {
        Group group = new Group(composite, 0);
        group.setText(string);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        group.setLayout((Layout)formLayout);
        group.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        return group;
    }

    protected Control createContents(Composite composite) {
        this.initializeDialogUnits((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.ui.views_preference_page_context");
        IPreferenceStore iPreferenceStore = PrefUtil.getAPIPreferenceStore();
        this.editorAlignment = iPreferenceStore.getInt("EDITOR_TAB_POSITION");
        this.viewAlignment = iPreferenceStore.getInt("VIEW_TAB_POSITION");
        this.perspBarLocation = iPreferenceStore.getString("DOCK_PERSPECTIVE_BAR");
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        composite2.setLayout((Layout)gridLayout);
        this.createPresentationCombo(composite2);
        this.createPresentationOverride(composite2);
        this.createEditorTabButtonGroup(composite2);
        this.createViewTabButtonGroup(composite2);
        this.createPerspBarTabButtonGroup(composite2);
        this.createShowTextOnPerspectiveBarPref(composite2);
        this.createThemeCombo(composite2);
        this.createThemeDescriptionText(composite2);
        this.createShowTraditionalStyleTabsPref(composite2);
        this.createEnableAnimationsPref(composite2);
        this.createColoredLabelsPref(composite2);
        this.updateOverride();
        this.hookOverrideListener();
        this.applyDialogFont(composite2);
        return composite2;
    }

    private void createColoredLabelsPref(Composite composite) {
        IPreferenceStore iPreferenceStore = PrefUtil.getAPIPreferenceStore();
        this.useColoredLabels = this.createCheckButton(composite, WorkbenchMessages.ViewsPreference_useColoredLabels, iPreferenceStore.getBoolean("USE_COLORED_LABELS"));
    }

    private void createThemeCombo(Composite composite) {
        new Label(composite, 0).setText(WorkbenchMessages.ViewsPreference_currentTheme);
        this.themeCombo = new Combo(composite, 8);
        this.themeCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.themeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ViewsPreferencePage.this.refreshThemeDescriptionText();
            }
        });
        this.refreshThemeCombo(PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getId());
    }

    private void createThemeDescriptionText(Composite composite) {
        new Label(composite, 0).setText(WorkbenchMessages.ViewsPreference_currentThemeDescription);
        this.themeDescriptionText = new Text(composite, 2888);
        GridData gridData = new GridData(4, 4, true, true);
        GC gC = new GC((Drawable)composite);
        gridData.heightHint = Dialog.convertHeightInCharsToPixels((FontMetrics)gC.getFontMetrics(), (int)2);
        gC.dispose();
        this.themeDescriptionText.setLayoutData((Object)gridData);
        this.refreshThemeDescriptionText();
    }

    private void refreshThemeDescriptionText() {
        String string = null;
        int n = this.themeCombo.getSelectionIndex();
        if (n > 0) {
            IThemeDescriptor iThemeDescriptor = WorkbenchPlugin.getDefault().getThemeRegistry().getThemes()[n - 1];
            string = iThemeDescriptor.getDescription();
        }
        if (string == null) {
            string = "";
        }
        this.themeDescriptionText.setText(string);
    }

    private Button createCheckButton(Composite composite, String string, boolean bl) {
        Button button = new Button(composite, 32);
        button.setText(string);
        button.setSelection(bl);
        return button;
    }

    private void createPresentationOverride(Composite composite) {
        String string;
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        boolean bl = iPreferenceStore.getBoolean("overridepresentation");
        boolean bl2 = PrefUtil.getAPIPreferenceStore().getBoolean("SHOW_TEXT_ON_PERSPECTIVE_BAR");
        if ((bl2 && this.isR21(this.currentPresentationFactoryId) || !bl2 && this.isR30(this.currentPresentationFactoryId)) && !bl) {
            iPreferenceStore.setValue("overridepresentation", true);
            bl = true;
        }
        if ((!(string = PrefUtil.getAPIPreferenceStore().getString("DOCK_PERSPECTIVE_BAR")).equals("left") && this.isR21(this.currentPresentationFactoryId) || !string.equals("topRight") && this.isR30(this.currentPresentationFactoryId)) && !bl) {
            iPreferenceStore.setValue("overridepresentation", true);
            bl = true;
        }
        this.overridePresButton = this.createCheckButton(composite, WorkbenchMessages.ViewsPreference_override, bl);
        this.overridePresButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ViewsPreferencePage.this.updateOverrideState(ViewsPreferencePage.this.overridePresButton.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                ViewsPreferencePage.this.updateOverrideState(ViewsPreferencePage.this.overridePresButton.getSelection());
            }
        });
    }

    private void updateOverrideState(boolean bl) {
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        if (iPreferenceStore.getBoolean("overridepresentation") != bl) {
            iPreferenceStore.setValue("overridepresentation", bl);
        }
        if (!bl) {
            this.setPresentationPrefs(this.getSelectedPresentationID());
        }
    }

    private void createPresentationCombo(Composite composite) {
        new Label(composite, 0).setText(WorkbenchMessages.ViewsPreference_currentPresentation);
        this.presentationCombo = new Combo(composite, 8);
        this.presentationCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.presentationCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                this.updateSettings();
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                this.updateSettings();
            }

            private void updateSettings() {
                if (!ViewsPreferencePage.this.overridePresButton.getSelection()) {
                    ViewsPreferencePage.this.setPresentationPrefs(ViewsPreferencePage.this.getSelectedPresentationID());
                }
            }
        });
        this.refreshPresentationCombo();
        this.setPresentationSelection();
    }

    private void attachControls(Control control, Control control2) {
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        FormData formData2 = new FormData();
        formData2.left = new FormAttachment(control, this.convertHorizontalDLUsToPixels(4));
        control.setLayoutData((Object)formData);
        control2.setLayoutData((Object)formData2);
    }

    private void createEditorTabButtonGroup(Composite composite) {
        this.editorTabGroup = this.createButtonGroup(composite, EDITORS_TITLE);
        this.editorTopButton = new Button((Composite)this.editorTabGroup, 16);
        this.editorTopButton.setText(EDITORS_TOP_TITLE);
        this.editorTopButton.setSelection(this.editorAlignment == 128);
        this.editorTopButton.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent accessibleEvent) {
                accessibleEvent.result = EDITORS_TITLE;
            }
        });
        this.editorBottomButton = new Button((Composite)this.editorTabGroup, 16);
        this.editorBottomButton.setText(EDITORS_BOTTOM_TITLE);
        this.editorBottomButton.setSelection(this.editorAlignment == 1024);
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (selectionEvent.widget.equals(ViewsPreferencePage.this.editorTopButton)) {
                    if (ViewsPreferencePage.this.editorAlignment != 128) {
                        ViewsPreferencePage.this.editorAlignment = 128;
                        ViewsPreferencePage.this.editorAlignmentChanged = true;
                    }
                } else if (selectionEvent.widget.equals(ViewsPreferencePage.this.editorBottomButton) && ViewsPreferencePage.this.editorAlignment != 1024) {
                    ViewsPreferencePage.this.editorAlignment = 1024;
                    ViewsPreferencePage.this.editorAlignmentChanged = true;
                }
            }
        };
        this.editorTopButton.addSelectionListener((SelectionListener)selectionAdapter);
        this.editorBottomButton.addSelectionListener((SelectionListener)selectionAdapter);
        this.attachControls((Control)this.editorTopButton, (Control)this.editorBottomButton);
    }

    private void createViewTabButtonGroup(Composite composite) {
        this.viewTabGroup = this.createButtonGroup(composite, VIEWS_TITLE);
        this.viewTopButton = new Button((Composite)this.viewTabGroup, 16);
        this.viewTopButton.setText(VIEWS_TOP_TITLE);
        this.viewTopButton.setSelection(this.viewAlignment == 128);
        this.viewBottomButton = new Button((Composite)this.viewTabGroup, 16);
        this.viewBottomButton.setText(VIEWS_BOTTOM_TITLE);
        this.viewBottomButton.setSelection(this.viewAlignment == 1024);
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (selectionEvent.widget.equals(ViewsPreferencePage.this.viewTopButton)) {
                    if (ViewsPreferencePage.this.viewAlignment != 128) {
                        ViewsPreferencePage.this.viewAlignment = 128;
                        ViewsPreferencePage.this.viewAlignmentChanged = true;
                    }
                } else if (selectionEvent.widget.equals(ViewsPreferencePage.this.viewBottomButton) && ViewsPreferencePage.this.viewAlignment != 1024) {
                    ViewsPreferencePage.this.viewAlignment = 1024;
                    ViewsPreferencePage.this.viewAlignmentChanged = true;
                }
            }
        };
        this.viewTopButton.addSelectionListener((SelectionListener)selectionAdapter);
        this.viewBottomButton.addSelectionListener((SelectionListener)selectionAdapter);
        this.attachControls((Control)this.viewTopButton, (Control)this.viewBottomButton);
    }

    private void createPerspBarTabButtonGroup(Composite composite) {
        this.perspBarTabGroup = this.createButtonGroup(composite, PERSP_TITLE);
        this.perspLeftButton = new Button((Composite)this.perspBarTabGroup, 16);
        this.perspLeftButton.setText(PERSP_LEFT_TITLE);
        this.perspLeftButton.setSelection("left".equals(this.perspBarLocation));
        this.perspLeftButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ViewsPreferencePage.this.perspBarLocation = "left";
            }
        });
        this.perspTopLeftButton = new Button((Composite)this.perspBarTabGroup, 16);
        this.perspTopLeftButton.setText(PERSP_TOP_LEFT_TITLE);
        this.perspTopLeftButton.setSelection("topLeft".equals(this.perspBarLocation));
        this.perspTopLeftButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ViewsPreferencePage.this.perspBarLocation = "topLeft";
            }
        });
        this.perspTopRightButton = new Button((Composite)this.perspBarTabGroup, 16);
        this.perspTopRightButton.setText(PERSP_TOP_RIGHT_TITLE);
        this.perspTopRightButton.setSelection("topRight".equals(this.perspBarLocation));
        this.perspTopRightButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ViewsPreferencePage.this.perspBarLocation = "topRight";
            }
        });
        int n = this.convertHorizontalDLUsToPixels(4);
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        FormData formData2 = new FormData();
        formData2.left = new FormAttachment((Control)this.perspLeftButton, n);
        FormData formData3 = new FormData();
        formData3.left = new FormAttachment((Control)this.perspTopLeftButton, n);
        this.perspLeftButton.setLayoutData((Object)formData);
        this.perspTopLeftButton.setLayoutData((Object)formData2);
        this.perspTopRightButton.setLayoutData((Object)formData3);
    }

    private void hookOverrideListener() {
        if (this.overrideListener != null) {
            return;
        }
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        this.overrideListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getProperty().equals("overridepresentation")) {
                    ViewsPreferencePage.this.updateOverride();
                }
            }
        };
        iPreferenceStore.addPropertyChangeListener(this.overrideListener);
    }

    public void dispose() {
        super.dispose();
        if (this.overrideListener != null) {
            this.getPreferenceStore().removePropertyChangeListener(this.overrideListener);
            this.overrideListener = null;
        }
    }

    private void updateOverride() {
        boolean bl = this.getPreferenceStore().getBoolean("overridepresentation");
        this.editorTabGroup.setEnabled(bl);
        this.editorTopButton.setEnabled(bl);
        this.editorBottomButton.setEnabled(bl);
        this.viewTabGroup.setEnabled(bl);
        this.viewTopButton.setEnabled(bl);
        this.viewBottomButton.setEnabled(bl);
        this.perspBarTabGroup.setEnabled(bl);
        this.perspTopLeftButton.setEnabled(bl);
        this.perspLeftButton.setEnabled(bl);
        this.perspTopRightButton.setEnabled(bl);
        this.showTextOnPerspectiveBar.setEnabled(bl);
    }

    private void refreshPresentationCombo() {
        this.presentationCombo.removeAll();
        this.refreshPresentationFactories();
        int n = 0;
        while (n < this.presentationFactories.length) {
            IConfigurationElement iConfigurationElement = this.presentationFactories[n];
            String string = iConfigurationElement.getAttribute("name");
            if (!this.currentPresentationFactoryId.equals(iConfigurationElement.getAttribute("id"))) {
                this.presentationCombo.add(string);
            } else {
                this.presentationCombo.add(NLS.bind((String)WorkbenchMessages.ViewsPreference_currentPresentationFormat, (Object)string));
            }
            ++n;
        }
    }

    private void setPresentationSelection() {
        int n = 0;
        while (n < this.presentationFactories.length) {
            if (this.currentPresentationFactoryId.equals(this.presentationFactories[n].getAttribute("id"))) {
                this.presentationCombo.select(n);
                return;
            }
            ++n;
        }
    }

    private void refreshPresentationFactories() {
        this.currentPresentationFactoryId = PrefUtil.getAPIPreferenceStore().getString("presentationFactoryId");
        this.presentationFactories = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.ui", "presentationFactories");
        Arrays.sort(this.presentationFactories, new Comparator(){
            Collator collator = Collator.getInstance((Locale)Locale.getDefault());

            public int compare(Object object, Object object2) {
                IConfigurationElement iConfigurationElement = (IConfigurationElement)object;
                IConfigurationElement iConfigurationElement2 = (IConfigurationElement)object2;
                return this.collator.compare(iConfigurationElement.getAttribute("name"), iConfigurationElement2.getAttribute("name"));
            }
        });
    }

    private boolean updatePresentationPreferences() {
        if (this.presentationCombo == null) {
            return false;
        }
        String string = this.getSelectedPresentationID();
        if (string.equals(this.currentPresentationFactoryId)) {
            return false;
        }
        this.currentPresentationFactoryId = string;
        this.setPresentationPrefs(string);
        PrefUtil.getAPIPreferenceStore().putValue("presentationFactoryId", string);
        return true;
    }

    private void setPresentationPrefs(String string) {
        if (this.isR21(string)) {
            this.setR21Preferences();
        } else if (this.isR30(string)) {
            this.setR30Preferences();
        } else if (this.isR33(string)) {
            this.setR33Preferences();
        }
    }

    private boolean isR33(String string) {
        return DEFAULT_PRESENTATION_ID.equals(string);
    }

    private boolean isR30(String string) {
        return R30_PRESENTATION_ID.equals(string);
    }

    private boolean isR21(String string) {
        return R21PRESENTATION_ID.equals(string);
    }

    private String getSelectedPresentationID() {
        int n = this.presentationCombo.getSelectionIndex();
        IConfigurationElement iConfigurationElement = this.presentationFactories[n];
        String string = iConfigurationElement.getAttribute("id");
        return string;
    }

    private void setR33Preferences() {
        this.setR30Preferences();
        IPreferenceStore iPreferenceStore = PrefUtil.getAPIPreferenceStore();
        iPreferenceStore.setValue("ENABLE_MIN_MAX", true);
    }

    private void setR30Preferences() {
        IPreferenceStore iPreferenceStore = PrefUtil.getAPIPreferenceStore();
        iPreferenceStore.setValue("ENABLE_MIN_MAX", false);
        this.setEditorAlignDefault(iPreferenceStore);
        this.setViewAlignDefault(iPreferenceStore);
        this.perspBarLocation = iPreferenceStore.getDefaultString("DOCK_PERSPECTIVE_BAR");
        this.perspLeftButton.setSelection(this.perspBarLocation.equals("left"));
        this.perspTopLeftButton.setSelection(this.perspBarLocation.equals("topLeft"));
        this.perspTopRightButton.setSelection(this.perspBarLocation.equals("topRight"));
        this.perspBarLocation = INITIAL_VAL;
        this.showTextOnPerspectiveBar.setSelection(iPreferenceStore.getDefaultBoolean("SHOW_TEXT_ON_PERSPECTIVE_BAR"));
        this.showTextOnPerspBar = INITIAL_VAL;
        this.fastViewLoc = INITIAL_VAL;
    }

    private void setViewAlignDefault(IPreferenceStore iPreferenceStore) {
        int n = this.viewAlignment;
        this.viewAlignment = iPreferenceStore.getDefaultInt("VIEW_TAB_POSITION");
        this.viewTopButton.setSelection(this.viewAlignment == 128);
        this.viewBottomButton.setSelection(this.viewAlignment == 1024);
        if (n != this.viewAlignment) {
            this.viewAlignmentChanged = true;
        }
        this.viewAlignment = -1;
    }

    private void setEditorAlignDefault(IPreferenceStore iPreferenceStore) {
        int n = this.editorAlignment;
        this.editorAlignment = iPreferenceStore.getDefaultInt("EDITOR_TAB_POSITION");
        this.editorTopButton.setSelection(this.editorAlignment == 128);
        this.editorBottomButton.setSelection(this.editorAlignment == 1024);
        if (n != this.editorAlignment) {
            this.editorAlignmentChanged = true;
        }
        this.editorAlignment = -1;
    }

    private void setR21Preferences() {
        int n = this.editorAlignment;
        this.editorAlignment = 128;
        this.editorTopButton.setSelection(this.editorAlignment == 128);
        this.editorBottomButton.setSelection(this.editorAlignment == 1024);
        if (n != this.editorAlignment) {
            this.editorAlignmentChanged = true;
        }
        n = this.viewAlignment;
        this.viewAlignment = 1024;
        this.viewTopButton.setSelection(this.viewAlignment == 128);
        this.viewBottomButton.setSelection(this.viewAlignment == 1024);
        if (n != this.viewAlignment) {
            this.viewAlignmentChanged = true;
        }
        this.perspBarLocation = "left";
        this.perspLeftButton.setSelection(this.perspBarLocation.equals("left"));
        this.perspTopLeftButton.setSelection(this.perspBarLocation.equals("topLeft"));
        this.perspTopRightButton.setSelection(this.perspBarLocation.equals("topRight"));
        this.showTextOnPerspectiveBar.setSelection(false);
        this.showTextOnPerspBar = String.valueOf(false);
        this.fastViewLoc = "left";
        IPreferenceStore iPreferenceStore = PrefUtil.getAPIPreferenceStore();
        iPreferenceStore.setValue("ENABLE_MIN_MAX", false);
    }

    private void refreshThemeCombo(String string) {
        this.themeCombo.removeAll();
        ITheme iTheme = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme();
        IThemeDescriptor[] iThemeDescriptorArray = WorkbenchPlugin.getDefault().getThemeRegistry().getThemes();
        String string2 = PlatformUI.getWorkbench().getThemeManager().getTheme("org.eclipse.ui.defaultTheme").getLabel();
        if (iTheme.getId().equals("org.eclipse.ui.defaultTheme")) {
            string2 = NLS.bind((String)WorkbenchMessages.ViewsPreference_currentThemeFormat, (Object[])new Object[]{string2});
        }
        this.themeCombo.add(string2);
        int n = 0;
        int n2 = 0;
        while (n2 < iThemeDescriptorArray.length) {
            String string3 = iThemeDescriptorArray[n2].getName();
            if (iThemeDescriptorArray[n2].getId().equals(iTheme.getId())) {
                string3 = NLS.bind((String)WorkbenchMessages.ViewsPreference_currentThemeFormat, (Object[])new Object[]{string3});
            }
            if (string.equals(iThemeDescriptorArray[n2].getId())) {
                n = n2 + 1;
            }
            this.themeCombo.add(string3);
            ++n2;
        }
        this.themeCombo.select(n);
    }

    protected void createShowTextOnPerspectiveBarPref(Composite composite) {
        IPreferenceStore iPreferenceStore = PrefUtil.getAPIPreferenceStore();
        this.showTextOnPerspectiveBar = this.createCheckButton(composite, WorkbenchMessages.WorkbenchPreference_showTextOnPerspectiveBar, iPreferenceStore.getBoolean("SHOW_TEXT_ON_PERSPECTIVE_BAR"));
    }

    protected void createShowTraditionalStyleTabsPref(Composite composite) {
        IPreferenceStore iPreferenceStore = PrefUtil.getAPIPreferenceStore();
        this.showTraditionalStyleTabs = this.createCheckButton(composite, WorkbenchMessages.ViewsPreference_traditionalTabs, iPreferenceStore.getBoolean("SHOW_TRADITIONAL_STYLE_TABS"));
    }

    protected void createEnableAnimationsPref(Composite composite) {
        IPreferenceStore iPreferenceStore = PrefUtil.getAPIPreferenceStore();
        this.enableAnimations = this.createCheckButton(composite, WorkbenchMessages.ViewsPreference_enableAnimations, iPreferenceStore.getBoolean("ENABLE_ANIMATIONS"));
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return WorkbenchPlugin.getDefault().getPreferenceStore();
    }

    @Override
    public void init(IWorkbench iWorkbench) {
        this.currentPresentationFactoryId = PrefUtil.getAPIPreferenceStore().getString("presentationFactoryId");
    }

    protected void performDefaults() {
        String string;
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        IPreferenceStore iPreferenceStore2 = PrefUtil.getAPIPreferenceStore();
        this.showTextOnPerspectiveBar.setSelection(iPreferenceStore2.getDefaultBoolean("SHOW_TEXT_ON_PERSPECTIVE_BAR"));
        this.showTraditionalStyleTabs.setSelection(iPreferenceStore2.getDefaultBoolean("SHOW_TRADITIONAL_STYLE_TABS"));
        this.enableAnimations.setSelection(iPreferenceStore2.getDefaultBoolean("ENABLE_ANIMATIONS"));
        this.useColoredLabels.setSelection(iPreferenceStore2.getDefaultBoolean("USE_COLORED_LABELS"));
        this.currentPresentationFactoryId = string = iPreferenceStore2.getDefaultString("presentationFactoryId");
        this.setPresentationSelection();
        boolean bl = iPreferenceStore.getDefaultBoolean("overridepresentation");
        this.overridePresButton.setSelection(bl);
        this.updateOverrideState(bl);
        this.setEditorAlignDefault(iPreferenceStore2);
        this.setViewAlignDefault(iPreferenceStore2);
        this.perspBarLocation = iPreferenceStore2.getDefaultString("DOCK_PERSPECTIVE_BAR");
        this.perspLeftButton.setSelection("left".equals(this.perspBarLocation));
        this.perspTopLeftButton.setSelection("topLeft".equals(this.perspBarLocation));
        this.perspTopRightButton.setSelection("topRight".equals(this.perspBarLocation));
        this.refreshThemeCombo(PlatformUI.getWorkbench().getThemeManager().getTheme("org.eclipse.ui.defaultTheme").getId());
        this.refreshThemeDescriptionText();
        WorkbenchPlugin.getDefault().savePluginPreferences();
        super.performDefaults();
    }

    public boolean performOk() {
        Object object;
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        IPreferenceStore iPreferenceStore2 = PrefUtil.getAPIPreferenceStore();
        boolean bl = iPreferenceStore.getBoolean("overridepresentation");
        boolean bl2 = this.updatePresentationPreferences();
        if (this.showTextOnPerspBar.equals(INITIAL_VAL) && !bl) {
            iPreferenceStore2.setToDefault("SHOW_TEXT_ON_PERSPECTIVE_BAR");
        } else {
            iPreferenceStore2.setValue("SHOW_TEXT_ON_PERSPECTIVE_BAR", this.showTextOnPerspectiveBar.getSelection());
        }
        if (this.editorAlignmentChanged) {
            if (this.editorAlignment == -1) {
                iPreferenceStore2.setToDefault("EDITOR_TAB_POSITION");
            } else if (!bl) {
                iPreferenceStore2.setValue("EDITOR_TAB_POSITION", this.editorAlignment);
            } else {
                iPreferenceStore2.setValue("EDITOR_TAB_POSITION", this.editorAlignment);
            }
            bl2 = true;
        }
        if (this.viewAlignmentChanged) {
            if (this.viewAlignment == -1) {
                iPreferenceStore2.setToDefault("VIEW_TAB_POSITION");
            } else if (!bl) {
                iPreferenceStore2.setValue("VIEW_TAB_POSITION", this.viewAlignment);
            } else {
                iPreferenceStore2.setValue("VIEW_TAB_POSITION", this.viewAlignment);
            }
            bl2 = true;
        }
        if (this.perspBarLocation.equals(INITIAL_VAL)) {
            iPreferenceStore2.setToDefault("DOCK_PERSPECTIVE_BAR");
        } else if (!bl) {
            iPreferenceStore2.setValue("DOCK_PERSPECTIVE_BAR", this.perspBarLocation);
        } else {
            iPreferenceStore2.setValue("DOCK_PERSPECTIVE_BAR", this.perspBarLocation);
        }
        if (this.fastViewLoc.equals(INITIAL_VAL)) {
            iPreferenceStore2.setToDefault("initialFastViewBarLocation");
        } else {
            iPreferenceStore2.setValue("initialFastViewBarLocation", this.fastViewLoc);
        }
        int n = this.themeCombo.getSelectionIndex();
        if (n <= 0) {
            PlatformUI.getWorkbench().getThemeManager().setCurrentTheme("org.eclipse.ui.defaultTheme");
            this.refreshThemeCombo("org.eclipse.ui.defaultTheme");
        } else {
            object = WorkbenchPlugin.getDefault().getThemeRegistry().getThemes()[n - 1];
            PlatformUI.getWorkbench().getThemeManager().setCurrentTheme(object.getId());
            this.refreshThemeCombo(object.getId());
        }
        this.refreshThemeDescriptionText();
        iPreferenceStore2.setValue("SHOW_TRADITIONAL_STYLE_TABS", this.showTraditionalStyleTabs.getSelection());
        iPreferenceStore2.setValue("ENABLE_ANIMATIONS", this.enableAnimations.getSelection());
        iPreferenceStore2.setValue("USE_COLORED_LABELS", this.useColoredLabels.getSelection());
        PrefUtil.savePrefs();
        if (bl2 && !this.restartPosted && this.getContainer() instanceof IWorkbenchPreferenceContainer) {
            object = (IWorkbenchPreferenceContainer)this.getContainer();
            UIJob uIJob = new UIJob(WorkbenchMessages.ViewsPreference_restartRequestJobName){

                @Override
                public IStatus runInUIThread(IProgressMonitor iProgressMonitor) {
                    int n = new MessageDialog(null, WorkbenchMessages.ViewsPreference_presentationConfirm_title, null, WorkbenchMessages.ViewsPreference_presentationConfirm_message, 3, new String[]{WorkbenchMessages.ViewsPreference_presentationConfirm_yes, WorkbenchMessages.ViewsPreference_presentationConfirm_no}, 1).open();
                    if (n == 0) {
                        PlatformUI.getWorkbench().restart();
                    }
                    return Status.OK_STATUS;
                }
            };
            uIJob.setSystem(true);
            object.registerUpdateJob(uIJob);
            this.restartPosted = true;
        }
        return true;
    }
}

