/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ViewerColumn;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.dialogs.DialogUtil;
import org.eclipse.ui.views.IViewCategory;
import org.eclipse.ui.views.IViewDescriptor;

public class ViewLabelProvider
extends ColumnLabelProvider {
    private HashMap images;
    private final IWorkbenchWindow window;
    private final Color dimmedForeground;

    public ViewLabelProvider(IWorkbenchWindow iWorkbenchWindow, Color color) {
        this.window = iWorkbenchWindow;
        this.dimmedForeground = color;
    }

    protected void initialize(ColumnViewer columnViewer, ViewerColumn viewerColumn) {
        super.initialize(columnViewer, viewerColumn);
    }

    Image cacheImage(ImageDescriptor imageDescriptor) {
        Image image;
        if (this.images == null) {
            this.images = new HashMap(21);
        }
        if ((image = (Image)this.images.get(imageDescriptor)) == null) {
            image = imageDescriptor.createImage();
            this.images.put(imageDescriptor, image);
        }
        return image;
    }

    public void dispose() {
        if (this.images != null) {
            Iterator iterator = this.images.values().iterator();
            while (iterator.hasNext()) {
                ((Image)iterator.next()).dispose();
            }
            this.images = null;
        }
        super.dispose();
    }

    public Image getImage(Object object) {
        if (object instanceof IViewDescriptor) {
            ImageDescriptor imageDescriptor = ((IViewDescriptor)object).getImageDescriptor();
            if (imageDescriptor != null) {
                return this.cacheImage(imageDescriptor);
            }
        } else if (object instanceof IViewCategory) {
            ImageDescriptor imageDescriptor = WorkbenchImages.getImageDescriptor("IMG_OBJ_FOLDER");
            return this.cacheImage(imageDescriptor);
        }
        return null;
    }

    public String getText(Object object) {
        String string = WorkbenchMessages.ViewLabel_unknown;
        if (object instanceof IViewCategory) {
            string = ((IViewCategory)object).getLabel();
        } else if (object instanceof IViewDescriptor) {
            string = ((IViewDescriptor)object).getLabel();
        }
        return DialogUtil.removeAccel(string);
    }

    public Color getBackground(Object object) {
        return null;
    }

    public Color getForeground(Object object) {
        IWorkbenchPage iWorkbenchPage;
        if (object instanceof IViewDescriptor && (iWorkbenchPage = this.window.getActivePage()) != null && iWorkbenchPage.findViewReference(((IViewDescriptor)object).getId()) != null) {
            return this.dimmedForeground;
        }
        return null;
    }
}

