/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.views.IViewCategory;
import org.eclipse.ui.views.IViewDescriptor;
import org.eclipse.ui.views.IViewRegistry;

public class ViewContentProvider
implements ITreeContentProvider {
    private Map childMap = new HashMap();

    public void dispose() {
        this.childMap.clear();
    }

    public Object[] getChildren(Object object) {
        Object[] objectArray = (Object[])this.childMap.get(object);
        if (objectArray == null) {
            objectArray = this.createChildren(object);
            this.childMap.put(object, objectArray);
        }
        return objectArray;
    }

    private Object[] createChildren(Object object) {
        IViewDescriptor[] iViewDescriptorArray;
        if (object instanceof IViewRegistry) {
            IViewRegistry iViewRegistry = (IViewRegistry)object;
            Object[] objectArray = iViewRegistry.getCategories();
            ArrayList<IViewCategory> arrayList = new ArrayList<IViewCategory>();
            int n = 0;
            while (n < objectArray.length) {
                if (this.hasChildren(objectArray[n])) {
                    arrayList.add(objectArray[n]);
                }
                ++n;
            }
            objectArray = arrayList.toArray(new IViewCategory[arrayList.size()]);
            if (objectArray.length == 1) {
                return this.getChildren(objectArray[0]);
            }
            return objectArray;
        }
        if (object instanceof IViewCategory && (iViewDescriptorArray = ((IViewCategory)object).getViews()) != null) {
            ArrayList<IViewDescriptor> arrayList = new ArrayList<IViewDescriptor>();
            int n = 0;
            while (n < iViewDescriptorArray.length) {
                IViewDescriptor iViewDescriptor = iViewDescriptorArray[n];
                if (!WorkbenchActivityHelper.filterItem(iViewDescriptor)) {
                    arrayList.add(iViewDescriptor);
                }
                ++n;
            }
            return this.removeIntroView(arrayList).toArray();
        }
        return new Object[0];
    }

    private ArrayList removeIntroView(ArrayList arrayList) {
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            IViewDescriptor iViewDescriptor = (IViewDescriptor)iterator.next();
            if (!iViewDescriptor.getId().equals("org.eclipse.ui.internal.introview")) continue;
            iterator.remove();
        }
        return arrayList;
    }

    public Object[] getElements(Object object) {
        return this.getChildren(object);
    }

    public Object getParent(Object object) {
        return null;
    }

    public boolean hasChildren(Object object) {
        if (object instanceof IViewRegistry) {
            return true;
        }
        return object instanceof IViewCategory && this.getChildren(object).length > 0;
    }

    public void inputChanged(Viewer viewer, Object object, Object object2) {
        this.childMap.clear();
    }
}

