/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.ICheckable;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;

public class TreeManager {
    static final int CHECKSTATE_UNCHECKED = 0;
    static final int CHECKSTATE_GRAY = 1;
    static final int CHECKSTATE_CHECKED = 2;
    private static ICheckStateProvider checkStateProvider = null;
    private static IBaseLabelProvider labelProvider = null;
    private static ICheckStateListener viewerCheckListener = null;
    private static ITreeContentProvider treeContentProvider = null;
    private List listeners = new ArrayList();
    private LocalResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources());

    public static ICheckStateProvider getCheckStateProvider() {
        if (checkStateProvider == null) {
            checkStateProvider = new CheckStateProvider();
        }
        return checkStateProvider;
    }

    public static IBaseLabelProvider getLabelProvider() {
        if (labelProvider == null) {
            labelProvider = new TreeItemLabelProvider();
        }
        return labelProvider;
    }

    public static ITreeContentProvider getTreeContentProvider() {
        if (treeContentProvider == null) {
            treeContentProvider = new TreeItemContentProvider();
        }
        return treeContentProvider;
    }

    public ICheckStateListener getViewerCheckStateListener() {
        if (viewerCheckListener == null) {
            viewerCheckListener = new ViewerCheckStateListener();
        }
        return viewerCheckListener;
    }

    public TreeManager() {
        this.listeners = new ArrayList();
    }

    public void addListener(CheckListener checkListener) {
        this.listeners.add(checkListener);
    }

    public CheckListener getCheckListener(ICheckable iCheckable) {
        if (iCheckable instanceof CheckboxTreeViewer) {
            return new ModelListenerForCheckboxTree(this, (CheckboxTreeViewer)iCheckable);
        }
        if (iCheckable instanceof CheckboxTableViewer) {
            return new ModelListenerForCheckboxTable(this, (CheckboxTableViewer)iCheckable);
        }
        return null;
    }

    public void attachAll(CheckboxTreeViewer checkboxTreeViewer) {
        checkboxTreeViewer.setLabelProvider(TreeManager.getLabelProvider());
        checkboxTreeViewer.setCheckStateProvider(TreeManager.getCheckStateProvider());
        checkboxTreeViewer.setContentProvider((IContentProvider)TreeManager.getTreeContentProvider());
        checkboxTreeViewer.addCheckStateListener(this.getViewerCheckStateListener());
        this.getCheckListener((ICheckable)checkboxTreeViewer);
    }

    public void attachAll(CheckboxTableViewer checkboxTableViewer) {
        checkboxTableViewer.setLabelProvider(TreeManager.getLabelProvider());
        checkboxTableViewer.setCheckStateProvider(TreeManager.getCheckStateProvider());
        checkboxTableViewer.setContentProvider((IContentProvider)TreeManager.getTreeContentProvider());
        checkboxTableViewer.addCheckStateListener(this.getViewerCheckStateListener());
        this.getCheckListener((ICheckable)checkboxTableViewer);
    }

    public void removeListener(CheckListener checkListener) {
        this.listeners.remove(checkListener);
    }

    private void fireListeners(TreeItem treeItem) {
        for (CheckListener checkListener : this.listeners) {
            checkListener.checkChanged(treeItem);
        }
    }

    public void dispose() {
        this.resourceManager.dispose();
        this.resourceManager = null;
        this.listeners.clear();
        this.listeners = null;
    }

    public static interface CheckListener {
        public void checkChanged(TreeItem var1);
    }

    public static class CheckStateProvider
    implements ICheckStateProvider {
        public boolean isChecked(Object object) {
            return ((TreeItem)object).checkState != 0;
        }

        public boolean isGrayed(Object object) {
            return ((TreeItem)object).checkState == 1;
        }
    }

    public static class ModelListenerForCheckboxTable
    implements CheckListener {
        private CheckboxTableViewer tableViewer;

        public ModelListenerForCheckboxTable(TreeManager treeManager, CheckboxTableViewer checkboxTableViewer) {
            this.tableViewer = checkboxTableViewer;
            treeManager.addListener(this);
        }

        @Override
        public void checkChanged(TreeItem treeItem) {
            this.tableViewer.update((Object)treeItem, null);
        }
    }

    public static class ModelListenerForCheckboxTree
    implements CheckListener {
        private CheckboxTreeViewer treeViewer;

        public ModelListenerForCheckboxTree(TreeManager treeManager, CheckboxTreeViewer checkboxTreeViewer) {
            this.treeViewer = checkboxTreeViewer;
            treeManager.addListener(this);
        }

        @Override
        public void checkChanged(TreeItem treeItem) {
            this.treeViewer.update((Object)treeItem, null);
        }
    }

    public class TreeItem {
        private String label;
        private ImageDescriptor imageDescriptor;
        private Image image;
        private TreeItem parent;
        private List children;
        private int checkState;
        private boolean changedByUser = false;

        public TreeItem(String string) {
            this.label = string;
            this.children = new ArrayList();
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String string) {
            this.label = string;
        }

        public Image getImage() {
            if (this.image == null) {
                if (this.imageDescriptor == null) {
                    return null;
                }
                this.image = TreeManager.this.resourceManager.createImage(this.imageDescriptor);
            }
            return this.image;
        }

        public void setImageDescriptor(ImageDescriptor imageDescriptor) {
            this.imageDescriptor = imageDescriptor;
        }

        public void addChild(TreeItem treeItem) {
            treeItem.parent = this;
            this.children.add(treeItem);
            this.synchParents(treeItem);
        }

        public List getChildren() {
            return this.children;
        }

        public TreeItem getParent() {
            return this.parent;
        }

        private void internalSetCheckState(int n) {
            if (n == this.checkState) {
                return;
            }
            this.checkState = n;
            TreeManager.this.fireListeners(this);
        }

        public void setCheckState(boolean bl) {
            int n;
            int n2 = n = bl ? 2 : 0;
            if (this.checkState == n) {
                return;
            }
            this.internalSetCheckState(n);
            this.synchChildren(this);
            this.synchParents(this);
        }

        public boolean getState() {
            return this.checkState != 0;
        }

        int getCheckState() {
            return this.checkState;
        }

        private void synchChildren(TreeItem treeItem) {
            int n = treeItem.checkState;
            if (n != 1) {
                for (TreeItem treeItem2 : treeItem.children) {
                    treeItem2.internalSetCheckState(n);
                    treeItem2.setChangedByUser(treeItem.isChangedByUser());
                    this.synchChildren(treeItem2);
                }
            }
        }

        private void synchParents(TreeItem treeItem) {
            if (treeItem.parent == null) {
                return;
            }
            int n = treeItem.checkState;
            if (n == 1) {
                while (treeItem.parent != null && treeItem.parent.checkState != 1) {
                    treeItem.parent.internalSetCheckState(1);
                    treeItem = treeItem.parent;
                }
            } else {
                boolean bl = n == 2;
                boolean bl2 = n == 0;
                Iterator iterator = treeItem.parent.children.iterator();
                while (!(!iterator.hasNext() || bl && bl2)) {
                    TreeItem treeItem2 = (TreeItem)iterator.next();
                    switch (treeItem2.checkState) {
                        case 2: {
                            bl = true;
                            break;
                        }
                        case 1: {
                            bl2 = true;
                            bl = true;
                            break;
                        }
                        case 0: {
                            bl2 = true;
                        }
                    }
                }
                int n2 = treeItem.parent.checkState;
                if (bl && bl2) {
                    treeItem.parent.internalSetCheckState(1);
                } else if (bl) {
                    treeItem.parent.internalSetCheckState(2);
                } else {
                    treeItem.parent.internalSetCheckState(0);
                }
                if (n2 != treeItem.parent.checkState) {
                    this.synchParents(treeItem.parent);
                }
            }
        }

        public void setChangedByUser(boolean bl) {
            this.changedByUser = bl;
        }

        public boolean isChangedByUser() {
            return this.changedByUser;
        }
    }

    public static class TreeItemContentProvider
    implements ITreeContentProvider {
        public Object[] getChildren(Object object) {
            return ((TreeItem)object).getChildren().toArray();
        }

        public Object getParent(Object object) {
            return ((TreeItem)object).getParent();
        }

        public boolean hasChildren(Object object) {
            return this.getChildren(object).length > 0;
        }

        public Object[] getElements(Object object) {
            return this.getChildren(object);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }
    }

    public static class TreeItemLabelProvider
    extends LabelProvider {
        public String getText(Object object) {
            return ((TreeItem)object).getLabel();
        }

        public Image getImage(Object object) {
            return ((TreeItem)object).getImage();
        }
    }

    public static class ViewerCheckStateListener
    implements ICheckStateListener {
        public void checkStateChanged(CheckStateChangedEvent checkStateChangedEvent) {
            Object object = checkStateChangedEvent.getElement();
            if (object instanceof TreeItem) {
                ((TreeItem)object).setChangedByUser(true);
                ((TreeItem)object).setCheckState(checkStateChangedEvent.getChecked());
            }
        }
    }
}

