/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.util.PrefUtil;
import org.eclipse.ui.testing.ContributionInfo;

public class StartupPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Table pluginsList;
    private Workbench workbench;

    protected Control createContents(Composite composite) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.ui.startup_preference_page_context");
        Composite composite2 = this.createComposite(composite);
        this.createEarlyStartupSelection(composite2);
        return composite2;
    }

    protected Composite createComposite(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(1808);
        composite2.setLayoutData((Object)gridData);
        composite2.setFont(composite.getFont());
        return composite2;
    }

    protected void createEarlyStartupSelection(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText(WorkbenchMessages.StartupPreferencePage_label);
        label.setFont(composite.getFont());
        GridData gridData = new GridData(768);
        label.setLayoutData((Object)gridData);
        this.pluginsList = new Table(composite, 2848);
        gridData = new GridData(1808);
        this.pluginsList.setFont(composite.getFont());
        this.pluginsList.setLayoutData((Object)gridData);
        TableViewer tableViewer = new TableViewer(this.pluginsList);
        tableViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object object) {
                return (String)Platform.getBundle((String)((ContributionInfo)object).getBundleId()).getHeaders().get("Bundle-Name");
            }
        });
        tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        tableViewer.setInput((Object)this.workbench.getEarlyActivatedPlugins());
        tableViewer.setFilters(new ViewerFilter[]{this.createPlatformUIFilter()});
        this.updateCheckState();
    }

    private ViewerFilter createPlatformUIFilter() {
        return new ViewerFilter(){

            public boolean select(Viewer viewer, Object object, Object object2) {
                if (object2 instanceof ContributionInfo) {
                    ContributionInfo contributionInfo = (ContributionInfo)object2;
                    return !"org.eclipse.ui".equals(contributionInfo.getBundleId());
                }
                return true;
            }
        };
    }

    private void updateCheckState() {
        HashSet<String> hashSet = new HashSet<String>(Arrays.asList(this.workbench.getDisabledEarlyActivatedPlugins()));
        int n = 0;
        while (n < this.pluginsList.getItemCount()) {
            TableItem tableItem;
            String string = ((ContributionInfo)(tableItem = this.pluginsList.getItem(n)).getData()).getBundleId();
            tableItem.setChecked(!hashSet.contains(string));
            ++n;
        }
    }

    @Override
    public void init(IWorkbench iWorkbench) {
        this.workbench = (Workbench)iWorkbench;
    }

    protected void performDefaults() {
        IPreferenceStore iPreferenceStore = PrefUtil.getInternalPreferenceStore();
        iPreferenceStore.setToDefault("PLUGINS_NOT_ACTIVATED_ON_STARTUP");
        this.updateCheckState();
    }

    public boolean performOk() {
        StringBuffer stringBuffer = new StringBuffer();
        TableItem[] tableItemArray = this.pluginsList.getItems();
        int n = 0;
        while (n < tableItemArray.length) {
            if (!tableItemArray[n].getChecked()) {
                stringBuffer.append(((ContributionInfo)tableItemArray[n].getData()).getBundleId());
                stringBuffer.append(';');
            }
            ++n;
        }
        String string = stringBuffer.toString();
        IPreferenceStore iPreferenceStore = PrefUtil.getInternalPreferenceStore();
        iPreferenceStore.putValue("PLUGINS_NOT_ACTIVATED_ON_STARTUP", string);
        PrefUtil.savePrefs();
        return true;
    }
}

