/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import java.util.List;
import java.util.Set;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.dialogs.AbstractWorkingSetDialog;
import org.eclipse.ui.internal.dialogs.WorkingSetFilter;
import org.eclipse.ui.internal.dialogs.WorkingSetLabelProvider;

public class SimpleWorkingSetSelectionDialog
extends AbstractWorkingSetDialog {
    private static final int SIZING_SELECTION_WIDGET_HEIGHT = 200;
    private static final int SIZING_SELECTION_WIDGET_WIDTH = 50;
    private CheckboxTableViewer viewer;
    private IWorkingSet[] initialSelection;

    public SimpleWorkingSetSelectionDialog(Shell shell, String[] stringArray, IWorkingSet[] iWorkingSetArray, boolean bl) {
        super(shell, stringArray, bl);
        this.initialSelection = iWorkingSetArray;
        this.setTitle(WorkbenchMessages.WorkingSetSelectionDialog_title_multiSelect);
        this.setMessage(WorkbenchMessages.WorkingSetSelectionDialog_message_multiSelect);
    }

    protected Control createDialogArea(Composite composite) {
        this.initializeDialogUnits((Control)composite);
        Composite composite2 = (Composite)super.createDialogArea(composite);
        Composite composite3 = new Composite(composite2, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        gridLayout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        composite3.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(1808);
        gridData.heightHint = 200;
        gridData.widthHint = 350;
        composite3.setLayoutData((Object)gridData);
        this.viewer = CheckboxTableViewer.newCheckList((Composite)composite3, (int)2048);
        this.viewer.getControl().setLayoutData((Object)new GridData(1808));
        this.viewer.setLabelProvider((IBaseLabelProvider)new WorkingSetLabelProvider());
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.addFilter((ViewerFilter)new WorkingSetFilter(null));
        this.viewer.setInput((Object)PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSets());
        this.viewer.setFilters(new ViewerFilter[]{new Filter()});
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                SimpleWorkingSetSelectionDialog.this.handleSelectionChanged();
            }
        });
        this.viewer.setCheckedElements((Object[])this.initialSelection);
        gridData = new GridData(1808);
        gridData.heightHint = 200;
        gridData.widthHint = 50;
        this.viewer.getControl().setLayoutData((Object)gridData);
        this.addModifyButtons(composite3);
        this.addSelectionButtons(composite2);
        this.availableWorkingSetsChanged();
        Dialog.applyDialogFont((Control)composite2);
        return composite2;
    }

    protected void okPressed() {
        Object[] objectArray = this.viewer.getCheckedElements();
        IWorkingSet[] iWorkingSetArray = new IWorkingSet[objectArray.length];
        System.arraycopy(objectArray, 0, iWorkingSetArray, 0, objectArray.length);
        this.setSelection(iWorkingSetArray);
        super.okPressed();
    }

    @Override
    protected List getSelectedWorkingSets() {
        ISelection iSelection = this.viewer.getSelection();
        if (iSelection instanceof IStructuredSelection) {
            return ((IStructuredSelection)iSelection).toList();
        }
        return null;
    }

    @Override
    protected void availableWorkingSetsChanged() {
        this.viewer.setInput((Object)PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSets());
        super.availableWorkingSetsChanged();
    }

    void handleSelectionChanged() {
        this.updateButtonAvailability();
    }

    @Override
    protected void selectAllSets() {
        this.viewer.setCheckedElements((Object[])PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSets());
        this.updateButtonAvailability();
    }

    @Override
    protected void deselectAllSets() {
        this.viewer.setCheckedElements(new Object[0]);
        this.updateButtonAvailability();
    }

    private class Filter
    extends ViewerFilter {
        private Filter() {
        }

        public boolean select(Viewer viewer, Object object, Object object2) {
            return this.isCompatible((IWorkingSet)object2);
        }

        private boolean isCompatible(IWorkingSet iWorkingSet) {
            if (iWorkingSet.isAggregateWorkingSet()) {
                return false;
            }
            if (!iWorkingSet.isVisible()) {
                return false;
            }
            if (!iWorkingSet.isEditable()) {
                return false;
            }
            Set set = SimpleWorkingSetSelectionDialog.this.getSupportedWorkingSetIds();
            if (set == null) {
                return true;
            }
            for (String string : set) {
                if (!string.equals(iWorkingSet.getId())) continue;
                return true;
            }
            return false;
        }
    }
}

