/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import java.util.ArrayList;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.dialogs.CapabilityFilter;
import org.eclipse.ui.internal.dialogs.ViewComparator;
import org.eclipse.ui.internal.dialogs.ViewContentProvider;
import org.eclipse.ui.internal.dialogs.ViewLabelProvider;
import org.eclipse.ui.internal.dialogs.ViewPatternFilter;
import org.eclipse.ui.internal.registry.ViewRegistry;
import org.eclipse.ui.views.IViewCategory;
import org.eclipse.ui.views.IViewDescriptor;
import org.eclipse.ui.views.IViewRegistry;

public class ShowViewDialog
extends Dialog
implements ISelectionChangedListener,
IDoubleClickListener {
    private static final String DIALOG_SETTING_SECTION_NAME = "ShowViewDialog";
    private static final int LIST_HEIGHT = 300;
    private static final int LIST_WIDTH = 250;
    private static final String STORE_EXPANDED_CATEGORIES_ID = "ShowViewDialog.STORE_EXPANDED_CATEGORIES_ID";
    private static final String STORE_SELECTED_VIEW_ID = "ShowViewDialog.STORE_SELECTED_VIEW_ID";
    private FilteredTree filteredTree;
    private Button okButton;
    private IViewDescriptor[] viewDescs = new IViewDescriptor[0];
    private IViewRegistry viewReg;
    private IWorkbenchWindow window;
    private Color dimmedForeground;
    private Label descriptionHint;

    public ShowViewDialog(IWorkbenchWindow iWorkbenchWindow, IViewRegistry iViewRegistry) {
        super(iWorkbenchWindow.getShell());
        this.window = iWorkbenchWindow;
        this.viewReg = iViewRegistry;
    }

    protected void buttonPressed(int n) {
        if (n == 0) {
            this.saveWidgetValues();
        }
        super.buttonPressed(n);
    }

    protected void cancelPressed() {
        this.viewDescs = new IViewDescriptor[0];
        super.cancelPressed();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(WorkbenchMessages.ShowView_shellTitle);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.ui.show_view_dialog_context");
    }

    protected void createButtonsForButtonBar(Composite composite) {
        this.okButton = this.createButton(composite, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(composite, 1, IDialogConstants.CANCEL_LABEL, false);
        this.updateButtons();
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        composite2.setFont(composite.getFont());
        this.createFilteredTreeViewer(composite2);
        this.layoutTopControl((Control)this.filteredTree);
        this.descriptionHint = new Label(composite2, 64);
        this.descriptionHint.setText(WorkbenchMessages.ShowView_selectViewHelp);
        this.descriptionHint.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.descriptionHint.setVisible(false);
        this.restoreWidgetValues();
        ShowViewDialog.applyDialogFont((Control)composite2);
        return composite2;
    }

    private static RGB blend(RGB rGB, RGB rGB2, int n) {
        int n2 = ShowViewDialog.blend(rGB.red, rGB2.red, n);
        int n3 = ShowViewDialog.blend(rGB.green, rGB2.green, n);
        int n4 = ShowViewDialog.blend(rGB.blue, rGB2.blue, n);
        return new RGB(n2, n3, n4);
    }

    private static int blend(int n, int n2, int n3) {
        int n4 = (n3 * n + (100 - n3) * n2) / 100;
        return Math.min(255, n4);
    }

    private void createFilteredTreeViewer(Composite composite) {
        Text text;
        ViewPatternFilter viewPatternFilter = new ViewPatternFilter();
        int n = 2818;
        this.filteredTree = new FilteredTree(composite, n, viewPatternFilter, true);
        this.filteredTree.setBackground(composite.getDisplay().getSystemColor(22));
        TreeViewer treeViewer = this.filteredTree.getViewer();
        Control control = treeViewer.getControl();
        RGB rGB = ShowViewDialog.blend(control.getForeground().getRGB(), control.getBackground().getRGB(), 60);
        this.dimmedForeground = new Color((Device)control.getDisplay(), rGB);
        control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                ShowViewDialog.this.dimmedForeground.dispose();
            }
        });
        treeViewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider(this.window, this.dimmedForeground));
        treeViewer.setContentProvider((IContentProvider)new ViewContentProvider());
        treeViewer.setComparator((ViewerComparator)new ViewComparator((ViewRegistry)this.viewReg));
        treeViewer.setInput((Object)this.viewReg);
        treeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        treeViewer.addDoubleClickListener((IDoubleClickListener)this);
        treeViewer.addFilter((ViewerFilter)new CapabilityFilter());
        treeViewer.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                ShowViewDialog.this.handleTreeViewerKeyPressed(keyEvent);
            }
        });
        if (this.hasAtMostOneView(this.filteredTree.getViewer()) && (text = this.filteredTree.getFilterControl()) != null) {
            text.setEnabled(false);
        }
    }

    private boolean hasAtMostOneView(TreeViewer treeViewer) {
        ITreeContentProvider iTreeContentProvider = (ITreeContentProvider)treeViewer.getContentProvider();
        Object[] objectArray = iTreeContentProvider.getElements(treeViewer.getInput());
        if (objectArray.length <= 1) {
            if (objectArray.length == 0) {
                return true;
            }
            return !iTreeContentProvider.hasChildren(objectArray[0]);
        }
        return false;
    }

    public void doubleClick(DoubleClickEvent doubleClickEvent) {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)doubleClickEvent.getSelection();
        Object object = iStructuredSelection.getFirstElement();
        if (this.filteredTree.getViewer().isExpandable(object)) {
            this.filteredTree.getViewer().setExpandedState(object, !this.filteredTree.getViewer().getExpandedState(object));
        } else if (this.viewDescs.length > 0) {
            this.saveWidgetValues();
            this.setReturnCode(0);
            this.close();
        }
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings iDialogSettings = WorkbenchPlugin.getDefault().getDialogSettings();
        IDialogSettings iDialogSettings2 = iDialogSettings.getSection(DIALOG_SETTING_SECTION_NAME);
        if (iDialogSettings2 == null) {
            iDialogSettings2 = iDialogSettings.addNewSection(DIALOG_SETTING_SECTION_NAME);
        }
        return iDialogSettings2;
    }

    public IViewDescriptor[] getSelection() {
        return this.viewDescs;
    }

    private void layoutTopControl(Control control) {
        GridData gridData = new GridData(1808);
        gridData.widthHint = 250;
        gridData.heightHint = 300;
        control.setLayoutData((Object)gridData);
    }

    protected void restoreWidgetValues() {
        Object object = null;
        IDialogSettings iDialogSettings = this.getDialogSettings();
        String[] stringArray = iDialogSettings.getArray(STORE_EXPANDED_CATEGORIES_ID);
        if (stringArray != null) {
            String string;
            ViewRegistry viewRegistry = (ViewRegistry)this.viewReg;
            ArrayList<IViewCategory> arrayList = new ArrayList<IViewCategory>(stringArray.length);
            int n = 0;
            while (n < stringArray.length) {
                IViewCategory iViewCategory = viewRegistry.findCategory(stringArray[n]);
                if (iViewCategory != null) {
                    arrayList.add(iViewCategory);
                }
                ++n;
            }
            if (!arrayList.isEmpty()) {
                this.filteredTree.getViewer().setExpandedElements(arrayList.toArray());
            }
            if ((string = iDialogSettings.get(STORE_SELECTED_VIEW_ID)) != null) {
                object = viewRegistry.find(string);
            }
        }
        if (object == null) {
            object = this.filteredTree.getViewer().getTree().getItem(0).getData();
        }
        this.filteredTree.getViewer().setSelection((ISelection)new StructuredSelection(object), true);
    }

    protected void saveWidgetValues() {
        IDialogSettings iDialogSettings = this.getDialogSettings();
        Object[] objectArray = this.filteredTree.getViewer().getExpandedElements();
        String[] stringArray = new String[objectArray.length];
        int n = 0;
        while (n < objectArray.length) {
            stringArray[n] = ((IViewCategory)objectArray[n]).getId();
            ++n;
        }
        iDialogSettings.put(STORE_EXPANDED_CATEGORIES_ID, stringArray);
        String string = "";
        if (this.viewDescs.length > 0) {
            string = this.viewDescs[0].getId();
        }
        iDialogSettings.put(STORE_SELECTED_VIEW_ID, string);
    }

    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        this.updateSelection(selectionChangedEvent);
        this.updateButtons();
        this.descriptionHint.setVisible(this.viewDescs.length == 1 && this.viewDescs[0].getDescription().length() > 0);
    }

    protected void updateButtons() {
        if (this.okButton != null) {
            this.okButton.setEnabled(this.getSelection().length > 0);
        }
    }

    protected void updateSelection(SelectionChangedEvent selectionChangedEvent) {
        ArrayList arrayList = new ArrayList();
        IStructuredSelection iStructuredSelection = (IStructuredSelection)selectionChangedEvent.getSelection();
        for (Object e : iStructuredSelection) {
            if (!(e instanceof IViewDescriptor)) continue;
            arrayList.add(e);
        }
        this.viewDescs = new IViewDescriptor[arrayList.size()];
        arrayList.toArray(this.viewDescs);
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return this.getDialogSettings();
    }

    void handleTreeViewerKeyPressed(KeyEvent keyEvent) {
        Object object;
        ITreeSelection iTreeSelection;
        if (this.descriptionHint.isVisible() && keyEvent.keyCode == 0x100000B && keyEvent.stateMask == 0 && (iTreeSelection = (ITreeSelection)this.filteredTree.getViewer().getSelection()).size() == 1 && (object = iTreeSelection.getFirstElement()) instanceof IViewDescriptor) {
            String string = ((IViewDescriptor)object).getDescription();
            if (string.length() == 0) {
                string = WorkbenchMessages.ShowView_noDesc;
            }
            this.popUp(string);
        }
    }

    private void popUp(final String string) {
        new PopupDialog(this.filteredTree.getShell(), 540676, true, false, false, false, false, null, null){
            private static final int CURSOR_SIZE = 15;

            protected Point getInitialLocation(Point point) {
                Display display = this.getShell().getDisplay();
                Point point2 = display.getCursorLocation();
                point2.x += 15;
                point2.y += 15;
                return point2;
            }

            protected Control createDialogArea(Composite composite) {
                Label label = new Label(composite, 64);
                label.setText(string);
                label.addFocusListener((FocusListener)new FocusAdapter(){

                    public void focusLost(FocusEvent focusEvent) {
                        this.close();
                    }
                });
                GridData gridData = new GridData(1809);
                gridData.horizontalIndent = 1;
                gridData.verticalIndent = 1;
                label.setLayoutData((Object)gridData);
                return label;
            }
        }.open();
    }

    protected boolean isResizable() {
        return true;
    }
}

