/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.ITriggerPoint;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.activities.ws.ActivityMessages;
import org.eclipse.ui.internal.activities.ws.ActivityViewerFilter;
import org.eclipse.ui.internal.dialogs.PerspContentProvider;
import org.eclipse.ui.model.PerspectiveLabelProvider;

public class SelectPerspectiveDialog
extends Dialog
implements ISelectionChangedListener {
    private static final int LIST_HEIGHT = 300;
    private static final int LIST_WIDTH = 300;
    private TableViewer list;
    private Button okButton;
    private IPerspectiveDescriptor perspDesc;
    private IPerspectiveRegistry perspReg;
    private ActivityViewerFilter activityViewerFilter = new ActivityViewerFilter();
    private Button showAllButton;

    public SelectPerspectiveDialog(Shell shell, IPerspectiveRegistry iPerspectiveRegistry) {
        super(shell);
        this.perspReg = iPerspectiveRegistry;
        this.setShellStyle(this.getShellStyle() | 0x10000000);
    }

    protected void cancelPressed() {
        this.perspDesc = null;
        super.cancelPressed();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(WorkbenchMessages.SelectPerspective_shellTitle);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.ui.select_perspective_dialog_context");
    }

    protected void createButtonsForButtonBar(Composite composite) {
        this.okButton = this.createButton(composite, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(composite, 1, IDialogConstants.CANCEL_LABEL, false);
        this.updateButtons();
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        composite2.setFont(composite.getFont());
        this.createViewer(composite2);
        this.layoutTopControl(this.list.getControl());
        if (this.needsShowAllButton()) {
            this.createShowAllButton(composite2);
        }
        return composite2;
    }

    private boolean needsShowAllButton() {
        return this.activityViewerFilter.getHasEncounteredFilteredItem();
    }

    private void createShowAllButton(Composite composite) {
        this.showAllButton = new Button(composite, 32);
        this.showAllButton.setText(ActivityMessages.Perspective_showAll);
        this.showAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (SelectPerspectiveDialog.this.showAllButton.getSelection()) {
                    SelectPerspectiveDialog.this.list.resetFilters();
                } else {
                    SelectPerspectiveDialog.this.list.addFilter((ViewerFilter)SelectPerspectiveDialog.this.activityViewerFilter);
                }
            }
        });
    }

    private void createViewer(Composite composite) {
        this.list = new TableViewer(composite, 2820);
        this.list.getTable().setFont(composite.getFont());
        this.list.setLabelProvider((IBaseLabelProvider)new PerspectiveLabelProvider());
        this.list.setContentProvider((IContentProvider)new PerspContentProvider());
        this.list.addFilter((ViewerFilter)this.activityViewerFilter);
        this.list.setComparator(new ViewerComparator());
        this.list.setInput((Object)this.perspReg);
        this.list.addSelectionChangedListener((ISelectionChangedListener)this);
        this.list.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent doubleClickEvent) {
                SelectPerspectiveDialog.this.handleDoubleClickEvent();
            }
        });
    }

    public IPerspectiveDescriptor getSelection() {
        return this.perspDesc;
    }

    protected void handleDoubleClickEvent() {
        this.okPressed();
    }

    private void layoutTopControl(Control control) {
        GridData gridData = new GridData(1808);
        gridData.widthHint = 300;
        gridData.heightHint = 300;
        control.setLayoutData((Object)gridData);
    }

    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        this.updateSelection(selectionChangedEvent);
        this.updateButtons();
    }

    protected void updateButtons() {
        this.okButton.setEnabled(this.getSelection() != null);
    }

    protected void updateSelection(SelectionChangedEvent selectionChangedEvent) {
        Object object;
        this.perspDesc = null;
        IStructuredSelection iStructuredSelection = (IStructuredSelection)selectionChangedEvent.getSelection();
        if (!iStructuredSelection.isEmpty() && (object = iStructuredSelection.getFirstElement()) instanceof IPerspectiveDescriptor) {
            this.perspDesc = (IPerspectiveDescriptor)object;
        }
    }

    protected void okPressed() {
        ITriggerPoint iTriggerPoint = PlatformUI.getWorkbench().getActivitySupport().getTriggerPointManager().getTriggerPoint("org.eclipse.ui.openPerspectiveDialog");
        if (WorkbenchActivityHelper.allowUseOf(iTriggerPoint, this.getSelection())) {
            super.okPressed();
        }
    }

    protected boolean isResizable() {
        return true;
    }
}

