/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.activities.ws.ActivityViewerFilter;
import org.eclipse.ui.internal.dialogs.PerspContentProvider;
import org.eclipse.ui.internal.registry.PerspectiveRegistry;
import org.eclipse.ui.model.PerspectiveLabelProvider;

public class SavePerspectiveDialog
extends Dialog
implements ISelectionChangedListener,
ModifyListener {
    private Text text;
    private TableViewer list;
    private Button okButton;
    private PerspectiveRegistry perspReg;
    private String perspName;
    private IPerspectiveDescriptor persp;
    private IPerspectiveDescriptor initialSelection;
    private boolean ignoreSelection = false;
    private static final int LIST_WIDTH = 40;
    private static final int TEXT_WIDTH = 40;
    private static final int LIST_HEIGHT = 14;

    public SavePerspectiveDialog(Shell shell, PerspectiveRegistry perspectiveRegistry) {
        super(shell);
        this.perspReg = perspectiveRegistry;
        this.setShellStyle(this.getShellStyle() | 0x10000000);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(WorkbenchMessages.SavePerspective_shellTitle);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.ui.save_perspective_dialog_context");
    }

    protected void createButtonsForButtonBar(Composite composite) {
        this.okButton = this.createButton(composite, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(composite, 1, IDialogConstants.CANCEL_LABEL, false);
        this.updateButtons();
        this.text.setFocus();
    }

    protected Control createDialogArea(Composite composite) {
        Font font = composite.getFont();
        Composite composite2 = (Composite)super.createDialogArea(composite);
        Label label = new Label(composite2, 64);
        label.setText(WorkbenchMessages.SavePerspectiveDialog_description);
        label.setFont(composite.getFont());
        Label label2 = new Label(composite2, 0);
        GridData gridData = new GridData();
        gridData.heightHint = 8;
        label2.setLayoutData((Object)gridData);
        Composite composite3 = new Composite(composite2, 0);
        composite3.setLayoutData((Object)new GridData(768));
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite3.setLayout((Layout)gridLayout);
        label2 = new Label(composite3, 0);
        label2.setText(WorkbenchMessages.SavePerspective_name);
        label2.setFont(font);
        this.text = new Text(composite3, 2048);
        this.text.setFocus();
        gridData = new GridData(768);
        gridData.widthHint = this.convertWidthInCharsToPixels(40);
        this.text.setLayoutData((Object)gridData);
        this.text.setFont(font);
        this.text.addModifyListener((ModifyListener)this);
        label2 = new Label(composite2, 0);
        gridData = new GridData();
        gridData.heightHint = 5;
        label2.setLayoutData((Object)gridData);
        label2 = new Label(composite2, 0);
        label2.setText(WorkbenchMessages.SavePerspective_existing);
        label2.setFont(font);
        this.list = new TableViewer(composite2, 2816);
        this.list.setLabelProvider((IBaseLabelProvider)new PerspectiveLabelProvider());
        this.list.setContentProvider((IContentProvider)new PerspContentProvider());
        this.list.addFilter((ViewerFilter)new ActivityViewerFilter());
        this.list.setComparator(new ViewerComparator());
        this.list.setInput((Object)this.perspReg);
        this.list.addSelectionChangedListener((ISelectionChangedListener)this);
        this.list.getTable().setFont(font);
        Control control = this.list.getControl();
        GridData gridData2 = new GridData(1808);
        gridData2.widthHint = this.convertWidthInCharsToPixels(40);
        gridData2.heightHint = this.convertHeightInCharsToPixels(14);
        control.setLayoutData((Object)gridData2);
        if (this.initialSelection != null) {
            StructuredSelection structuredSelection = new StructuredSelection((Object)this.initialSelection);
            this.list.setSelection((ISelection)structuredSelection, true);
        }
        this.text.selectAll();
        return composite2;
    }

    public IPerspectiveDescriptor getPersp() {
        return this.persp;
    }

    public String getPerspName() {
        return this.perspName;
    }

    public void modifyText(ModifyEvent modifyEvent) {
        this.perspName = this.text.getText();
        this.ignoreSelection = true;
        this.persp = this.perspReg.findPerspectiveWithLabel(this.perspName);
        if (this.persp == null) {
            StructuredSelection structuredSelection = new StructuredSelection();
            this.list.setSelection((ISelection)structuredSelection);
        } else {
            StructuredSelection structuredSelection = new StructuredSelection((Object)this.persp);
            this.list.setSelection((ISelection)structuredSelection);
        }
        this.ignoreSelection = false;
        this.updateButtons();
    }

    protected void okPressed() {
        this.perspName = this.text.getText();
        this.persp = this.perspReg.findPerspectiveWithLabel(this.perspName);
        if (this.persp != null) {
            String string = NLS.bind((String)WorkbenchMessages.SavePerspective_overwriteQuestion, (Object)this.perspName);
            String[] stringArray = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL};
            MessageDialog messageDialog = new MessageDialog(this.getShell(), WorkbenchMessages.SavePerspective_overwriteTitle, null, string, 3, stringArray, 0){

                protected int getShellStyle() {
                    return super.getShellStyle() | 0x10000000;
                }
            };
            switch (messageDialog.open()) {
                case 0: {
                    break;
                }
                case 1: {
                    return;
                }
                case 2: {
                    this.cancelPressed();
                    return;
                }
                default: {
                    return;
                }
            }
        }
        super.okPressed();
    }

    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        if (this.ignoreSelection) {
            return;
        }
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.list.getSelection();
        this.persp = null;
        if (!iStructuredSelection.isEmpty()) {
            this.persp = (IPerspectiveDescriptor)iStructuredSelection.getFirstElement();
        }
        if (this.persp != null) {
            this.perspName = this.persp.getLabel();
            this.text.setText(this.perspName);
        }
        this.updateButtons();
    }

    public void setInitialSelection(IPerspectiveDescriptor iPerspectiveDescriptor) {
        this.initialSelection = iPerspectiveDescriptor;
    }

    private void updateButtons() {
        if (this.okButton != null) {
            String string = this.text.getText();
            this.okButton.setEnabled(this.perspReg.validateLabel(string));
        }
    }
}

