/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IActionFilter;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.IWorkbenchPropertyPageMulti;
import org.eclipse.ui.SelectionEnabler;
import org.eclipse.ui.internal.LegacyResourceSupport;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.dialogs.AdaptableForwarder;
import org.eclipse.ui.internal.dialogs.IPropertyPageContributor;
import org.eclipse.ui.internal.dialogs.PropertyPageManager;
import org.eclipse.ui.internal.dialogs.PropertyPageNode;
import org.eclipse.ui.internal.util.Util;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class RegistryPageContributor
implements IPropertyPageContributor,
IAdaptable,
IPluginContribution {
    private static final String CHILD_ENABLED_WHEN = "enabledWhen";
    private String pageId;
    private Collection subPages = new ArrayList();
    private boolean adaptable = false;
    private final boolean supportsMultiSelect;
    private IConfigurationElement pageElement;
    private SoftReference filterProperties;
    private Expression enablementExpression;

    public RegistryPageContributor(String string, IConfigurationElement iConfigurationElement) {
        this.pageId = string;
        this.pageElement = iConfigurationElement;
        this.adaptable = Boolean.valueOf(this.pageElement.getAttribute("adaptable"));
        this.supportsMultiSelect = "multi".equals(this.pageElement.getAttribute("selectionFilter"));
        this.initializeEnablement(iConfigurationElement);
    }

    @Override
    public PreferenceNode contributePropertyPage(PropertyPageManager propertyPageManager, Object object) {
        PropertyPageNode propertyPageNode = new PropertyPageNode(this, object);
        if ("org.eclipse.ui.propertypages.info.file".equals(propertyPageNode.getId())) {
            propertyPageNode.setPriority(-1);
        }
        return propertyPageNode;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IPreferencePage createPage(Object object) throws CoreException {
        IPreferencePage iPreferencePage = null;
        iPreferencePage = (IPreferencePage)WorkbenchPlugin.createExtension(this.pageElement, "class");
        iPreferencePage.setTitle(this.getPageName());
        Object[] objectArray = this.getObjects(object);
        IAdaptable[] iAdaptableArray = new IAdaptable[objectArray.length];
        int n = 0;
        while (n < objectArray.length) {
            Object object2 = objectArray[n];
            if (this.adaptable && (object2 = this.getAdaptedElement(object2)) == null) {
                String string = "Error adapting selection to Property page " + this.pageId + " is being ignored";
                throw new CoreException((IStatus)new Status(4, WorkbenchPlugin.PI_WORKBENCH, 4, string, null));
            }
            iAdaptableArray[n] = (IAdaptable)(object2 instanceof IAdaptable ? object2 : new AdaptableForwarder(object2));
            ++n;
        }
        if (this.supportsMultiSelect) {
            if (!(iPreferencePage instanceof IWorkbenchPropertyPageMulti)) throw new CoreException((IStatus)new Status(4, WorkbenchPlugin.PI_WORKBENCH, 4, "Property page must implement IWorkbenchPropertyPageMulti: " + this.getPageName(), null));
            ((IWorkbenchPropertyPageMulti)iPreferencePage).setElements(iAdaptableArray);
            return iPreferencePage;
        } else {
            ((IWorkbenchPropertyPage)iPreferencePage).setElement(iAdaptableArray[0]);
        }
        return iPreferencePage;
    }

    private Object getAdaptedElement(Object object) {
        Object object2 = LegacyResourceSupport.getAdapter(object, this.getObjectClass());
        if (object2 != null) {
            return object2;
        }
        return null;
    }

    public String getObjectClass() {
        return this.pageElement.getAttribute("objectClass");
    }

    public ImageDescriptor getPageIcon() {
        String string = this.pageElement.getAttribute("icon");
        if (string == null) {
            return null;
        }
        return AbstractUIPlugin.imageDescriptorFromPlugin(this.pageElement.getNamespaceIdentifier(), string);
    }

    public String getPageId() {
        return this.pageId;
    }

    public String getPageName() {
        return this.pageElement.getAttribute("name");
    }

    @Override
    public boolean isApplicableTo(Object object) {
        Object[] objectArray = this.getObjects(object);
        if (objectArray.length > 1 && !this.supportsMultiSelect) {
            return false;
        }
        if (this.failsEnablement(objectArray)) {
            return false;
        }
        String string = this.pageElement.getAttribute("nameFilter");
        int n = 0;
        while (n < objectArray.length) {
            Object object2;
            Object object3;
            object = objectArray[n];
            if (string != null) {
                String string2;
                object3 = object.toString();
                object2 = (IWorkbenchAdapter)Util.getAdapter(object, IWorkbenchAdapter.class);
                if (object2 != null && (string2 = object2.getLabel(object)) != null) {
                    object3 = string2;
                }
                if (!SelectionEnabler.verifyNameMatch((String)object3, string)) {
                    return false;
                }
            }
            if (this.getFilterProperties() == null) {
                return true;
            }
            object3 = null;
            object2 = LegacyResourceSupport.getAdaptedResource(object);
            if (object2 != null) {
                object = object2;
            }
            if ((object3 = (IActionFilter)Util.getAdapter(object, IActionFilter.class)) != null && !this.testCustom(object, (IActionFilter)object3)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private boolean failsEnablement(Object[] objectArray) {
        if (this.enablementExpression == null) {
            return false;
        }
        try {
            Object object = this.supportsMultiSelect ? Arrays.asList(objectArray) : objectArray[0];
            EvaluationContext evaluationContext = new EvaluationContext(null, object);
            evaluationContext.setAllowPluginActivation(true);
            return this.enablementExpression.evaluate((IEvaluationContext)evaluationContext).equals(EvaluationResult.FALSE);
        }
        catch (CoreException coreException) {
            WorkbenchPlugin.log(coreException);
            return false;
        }
    }

    private Object[] getObjects(Object object) {
        if (object instanceof IStructuredSelection) {
            return ((IStructuredSelection)object).toArray();
        }
        return new Object[]{object};
    }

    protected void initializeEnablement(IConfigurationElement iConfigurationElement) {
        IConfigurationElement[] iConfigurationElementArray = iConfigurationElement.getChildren(CHILD_ENABLED_WHEN);
        if (iConfigurationElementArray.length == 0) {
            return;
        }
        try {
            IConfigurationElement[] iConfigurationElementArray2 = iConfigurationElementArray[0].getChildren();
            if (iConfigurationElementArray2.length == 0) {
                return;
            }
            this.enablementExpression = ExpressionConverter.getDefault().perform(iConfigurationElementArray2[0]);
        }
        catch (CoreException coreException) {
            WorkbenchPlugin.log(coreException);
        }
    }

    private boolean testCustom(Object object, IActionFilter iActionFilter) {
        Map map = this.getFilterProperties();
        if (map == null) {
            return false;
        }
        for (String string : map.keySet()) {
            String string2;
            if (iActionFilter.testAttribute(object, string, string2 = (String)map.get(string))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean canAdapt() {
        return this.adaptable;
    }

    public String getCategory() {
        return this.pageElement.getAttribute("category");
    }

    public Collection getSubPages() {
        return this.subPages;
    }

    public void addSubPage(RegistryPageContributor registryPageContributor) {
        this.subPages.add(registryPageContributor);
    }

    private Map getFilterProperties() {
        if (this.filterProperties == null || this.filterProperties.get() == null) {
            HashMap hashMap = new HashMap();
            this.filterProperties = new SoftReference(hashMap);
            IConfigurationElement[] iConfigurationElementArray = this.pageElement.getChildren();
            int n = 0;
            while (n < iConfigurationElementArray.length) {
                this.processChildElement(hashMap, iConfigurationElementArray[n]);
                ++n;
            }
        }
        return (Map)this.filterProperties.get();
    }

    public Object getChild(String string) {
        for (RegistryPageContributor registryPageContributor : this.subPages) {
            if (!registryPageContributor.getPageId().equals(string)) continue;
            return registryPageContributor;
        }
        return null;
    }

    private void processChildElement(Map map, IConfigurationElement iConfigurationElement) {
        String string = iConfigurationElement.getName();
        if (string.equals("filter")) {
            String string2 = iConfigurationElement.getAttribute("name");
            String string3 = iConfigurationElement.getAttribute("value");
            if (string2 == null || string3 == null) {
                return;
            }
            map.put(string2, string3);
        }
    }

    public Object getAdapter(Class clazz) {
        if (clazz.equals(IConfigurationElement.class)) {
            return this.getConfigurationElement();
        }
        return null;
    }

    boolean supportsMultipleSelection() {
        return this.supportsMultiSelect;
    }

    IConfigurationElement getConfigurationElement() {
        return this.pageElement;
    }

    @Override
    public String getLocalId() {
        return this.pageId;
    }

    @Override
    public String getPluginId() {
        return this.pageElement.getContributor().getName();
    }
}

