/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.dialogs.EmptyPropertyPage;
import org.eclipse.ui.internal.dialogs.RegistryPageContributor;
import org.eclipse.ui.internal.misc.StatusUtil;
import org.eclipse.ui.internal.preferences.WorkbenchPreferenceExtensionNode;
import org.eclipse.ui.statushandlers.StatusManager;

public class PropertyPageNode
extends WorkbenchPreferenceExtensionNode {
    private RegistryPageContributor contributor;
    private IPreferencePage page;
    private Image icon;
    private Object element;

    public PropertyPageNode(RegistryPageContributor registryPageContributor, Object object) {
        super(registryPageContributor.getPageId(), registryPageContributor.getConfigurationElement());
        this.contributor = registryPageContributor;
        this.element = object;
    }

    public void createPage() {
        try {
            this.page = this.contributor.createPage(this.element);
        }
        catch (CoreException coreException) {
            IStatus iStatus = StatusUtil.newStatus(coreException.getStatus(), WorkbenchMessages.PropertyPageNode_errorMessage);
            StatusManager.getManager().handle(iStatus, 2);
            this.page = new EmptyPropertyPage();
        }
        this.setPage(this.page);
    }

    @Override
    public void disposeResources() {
        if (this.page != null) {
            this.page.dispose();
            this.page = null;
        }
        if (this.icon != null) {
            this.icon.dispose();
            this.icon = null;
        }
    }

    @Override
    public Image getLabelImage() {
        ImageDescriptor imageDescriptor;
        if (this.icon == null && (imageDescriptor = this.contributor.getPageIcon()) != null) {
            this.icon = imageDescriptor.createImage();
        }
        return this.icon;
    }

    @Override
    public String getLabelText() {
        return this.contributor.getPageName();
    }
}

