/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.SequencedCollection;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.dynamichelpers.IExtensionTracker;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.internal.ObjectContributorManager;
import org.eclipse.ui.internal.dialogs.PropertyPageManager;
import org.eclipse.ui.internal.dialogs.RegistryPageContributor;
import org.eclipse.ui.internal.registry.PropertyPagesRegistryReader;

public class PropertyPageContributorManager
extends ObjectContributorManager {
    private static PropertyPageContributorManager sharedInstance = null;

    public PropertyPageContributorManager() {
        this.loadContributors();
    }

    public boolean contribute(PropertyPageManager propertyPageManager, Object object) {
        PreferenceNode preferenceNode;
        RegistryPageContributor registryPageContributor;
        CategorizedPageNode categorizedPageNode;
        Object object2;
        Object object3;
        SequencedCollection sequencedCollection = null;
        if (object instanceof IStructuredSelection) {
            object3 = ((IStructuredSelection)object).toArray();
            int n = 0;
            while (n < ((Object[])object3).length) {
                object2 = this.getContributors(object3[n]);
                if (sequencedCollection == null) {
                    sequencedCollection = new LinkedHashSet(object2);
                } else {
                    sequencedCollection.retainAll((Collection<?>)object2);
                }
                ++n;
            }
        } else {
            sequencedCollection = this.getContributors(object);
        }
        if (sequencedCollection == null || sequencedCollection.size() == 0) {
            return false;
        }
        object3 = this.buildNodeList(sequencedCollection);
        Iterator iterator = object3.iterator();
        object2 = new HashMap();
        boolean bl = false;
        while (iterator.hasNext()) {
            categorizedPageNode = (CategorizedPageNode)iterator.next();
            registryPageContributor = categorizedPageNode.contributor;
            if (!registryPageContributor.isApplicableTo(object) || (preferenceNode = registryPageContributor.contributePropertyPage(propertyPageManager, object)) == null) continue;
            object2.put(categorizedPageNode, preferenceNode);
            bl = true;
        }
        if (bl) {
            iterator = object3.iterator();
            while (iterator.hasNext()) {
                categorizedPageNode = (CategorizedPageNode)iterator.next();
                registryPageContributor = (PreferenceNode)object2.get(categorizedPageNode);
                if (registryPageContributor == null) continue;
                preferenceNode = null;
                if (categorizedPageNode.parent != null) {
                    preferenceNode = (PreferenceNode)object2.get(categorizedPageNode.parent);
                }
                if (preferenceNode == null) {
                    propertyPageManager.addToRoot((IPreferenceNode)registryPageContributor);
                    continue;
                }
                preferenceNode.add((IPreferenceNode)registryPageContributor);
            }
        }
        return bl;
    }

    private List buildNodeList(Collection collection) {
        Object object2;
        Hashtable<String, CategorizedPageNode> hashtable = new Hashtable<String, CategorizedPageNode>();
        for (Object object2 : collection) {
            hashtable.put(((RegistryPageContributor)object2).getPageId(), new CategorizedPageNode((RegistryPageContributor)object2));
        }
        object2 = hashtable.values().iterator();
        ArrayList<CategorizedPageNode> arrayList = new ArrayList<CategorizedPageNode>();
        while (object2.hasNext()) {
            Object v;
            CategorizedPageNode categorizedPageNode = (CategorizedPageNode)object2.next();
            arrayList.add(categorizedPageNode);
            if (categorizedPageNode.contributor.getCategory() == null || (v = hashtable.get(categorizedPageNode.contributor.getCategory())) == null) continue;
            categorizedPageNode.setParent((CategorizedPageNode)v);
        }
        return arrayList;
    }

    public static PropertyPageContributorManager getManager() {
        if (sharedInstance == null) {
            sharedInstance = new PropertyPageContributorManager();
        }
        return sharedInstance;
    }

    private void loadContributors() {
        PropertyPagesRegistryReader propertyPagesRegistryReader = new PropertyPagesRegistryReader(this);
        propertyPagesRegistryReader.registerPropertyPages(Platform.getExtensionRegistry());
    }

    public void addExtension(IExtensionTracker iExtensionTracker, IExtension iExtension) {
        IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            PropertyPagesRegistryReader propertyPagesRegistryReader = new PropertyPagesRegistryReader(this);
            propertyPagesRegistryReader.readElement(iConfigurationElementArray[n]);
            ++n;
        }
    }

    public Collection getApplicableContributors(Object object) {
        if (object instanceof IStructuredSelection) {
            return this.getApplicableContributors((IStructuredSelection)object);
        }
        List list = this.getContributors(object);
        ArrayList<RegistryPageContributor> arrayList = new ArrayList<RegistryPageContributor>();
        for (RegistryPageContributor registryPageContributor : list) {
            if (!registryPageContributor.isApplicableTo(object)) continue;
            arrayList.add(registryPageContributor);
        }
        return arrayList;
    }

    public Collection getApplicableContributors(IStructuredSelection iStructuredSelection) {
        Object object;
        Iterator iterator = iStructuredSelection.iterator();
        LinkedHashSet linkedHashSet = null;
        while (iterator.hasNext()) {
            object = iterator.next();
            Collection collection = this.getApplicableContributors(object);
            if (linkedHashSet == null) {
                linkedHashSet = new LinkedHashSet(collection);
                continue;
            }
            linkedHashSet.retainAll(collection);
        }
        if (linkedHashSet != null && !linkedHashSet.isEmpty() && iStructuredSelection.size() > 1) {
            iterator = linkedHashSet.iterator();
            while (iterator.hasNext()) {
                object = (RegistryPageContributor)iterator.next();
                if (((RegistryPageContributor)object).supportsMultipleSelection()) continue;
                iterator.remove();
            }
        }
        return linkedHashSet;
    }

    @Override
    protected String getExtensionPointFilter() {
        return "propertyPages";
    }

    private class CategorizedPageNode {
        RegistryPageContributor contributor;
        CategorizedPageNode parent;

        CategorizedPageNode(RegistryPageContributor registryPageContributor) {
            this.contributor = registryPageContributor;
        }

        void setParent(CategorizedPageNode categorizedPageNode) {
            this.parent = categorizedPageNode;
        }
    }
}

