/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import java.util.Iterator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.dialogs.FilteredPreferenceDialog;
import org.eclipse.ui.internal.dialogs.PropertyPageContributorManager;
import org.eclipse.ui.internal.dialogs.PropertyPageManager;
import org.eclipse.ui.internal.util.Util;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class PropertyDialog
extends FilteredPreferenceDialog {
    private ISelection selection;
    private static String lastPropertyId = null;

    public static PropertyDialog createDialogOn(Shell shell, String string, Object object) {
        PropertyPageManager propertyPageManager = new PropertyPageManager();
        String string2 = "";
        if (object == null) {
            return null;
        }
        PropertyPageContributorManager.getManager().contribute(propertyPageManager, object);
        Iterator iterator = propertyPageManager.getElements(0).iterator();
        String string3 = PropertyDialog.getName(object);
        if (!iterator.hasNext()) {
            MessageDialog.openInformation((Shell)shell, (String)WorkbenchMessages.PropertyDialog_messageTitle, (String)NLS.bind((String)WorkbenchMessages.PropertyDialog_noPropertyMessage, (Object)string3));
            return null;
        }
        string2 = NLS.bind((String)WorkbenchMessages.PropertyDialog_propertyMessage, (Object)string3);
        PropertyDialog propertyDialog = new PropertyDialog(shell, propertyPageManager, (ISelection)new StructuredSelection(object));
        if (string != null) {
            propertyDialog.setSelectedNode(string);
        }
        propertyDialog.create();
        propertyDialog.getShell().setText(string2);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)propertyDialog.getShell(), "org.eclipse.ui.property_dialog_context");
        return propertyDialog;
    }

    private static String getName(Object object) {
        Object[] objectArray = object instanceof IStructuredSelection ? ((IStructuredSelection)object).toArray() : new Object[]{object};
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < objectArray.length) {
            object = objectArray[n];
            if (n > 2) {
                stringBuffer.append(" ...");
                break;
            }
            IWorkbenchAdapter iWorkbenchAdapter = (IWorkbenchAdapter)Util.getAdapter(object, IWorkbenchAdapter.class);
            if (iWorkbenchAdapter != null) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(iWorkbenchAdapter.getLabel(object));
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public PropertyDialog(Shell shell, PreferenceManager preferenceManager, ISelection iSelection) {
        super(shell, preferenceManager);
        this.setSelection(iSelection);
    }

    public ISelection getSelection() {
        return this.selection;
    }

    public void setSelection(ISelection iSelection) {
        this.selection = iSelection;
    }

    protected String getSelectedNodePreference() {
        return lastPropertyId;
    }

    protected void setSelectedNodePreference(String string) {
        lastPropertyId = string;
    }

    @Override
    protected String getContributionType() {
        return "property";
    }
}

