/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePageContainer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class PreferencesPageContainer
implements IPreferencePageContainer {
    private Composite control;
    private ScrolledComposite scrolled;

    void createContents(Composite composite, int n) {
        this.scrolled = new ScrolledComposite(composite, 768);
        GridData gridData = new GridData(1808);
        this.scrolled.setLayoutData((Object)gridData);
        this.control = new Composite((Composite)this.scrolled, n);
        this.scrolled.setContent((Control)this.control);
        this.scrolled.setExpandVertical(true);
        this.scrolled.setExpandHorizontal(true);
        GridData gridData2 = new GridData(1808);
        this.control.setLayoutData((Object)gridData2);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 1;
        this.control.setLayout((Layout)gridLayout);
    }

    Control getControl() {
        return this.control;
    }

    boolean show(IPreferenceNode iPreferenceNode) {
        this.createGeneralEntry(iPreferenceNode);
        this.control.layout(true);
        return true;
    }

    private void createGeneralEntry(IPreferenceNode iPreferenceNode) {
        PreferenceEntry preferenceEntry = this.createEntry(iPreferenceNode, "General", 0);
        preferenceEntry.addSubNodes();
    }

    private PreferenceEntry createEntry(IPreferenceNode iPreferenceNode, String string, int n) {
        PreferenceEntry preferenceEntry = new PreferenceEntry(iPreferenceNode, string);
        preferenceEntry.createContents(n);
        return preferenceEntry;
    }

    public IPreferenceStore getPreferenceStore() {
        return null;
    }

    public void updateButtons() {
    }

    public void updateMessage() {
    }

    public void updateTitle() {
    }

    private void adjustScrollbars(Point point) {
        Point point2 = this.control.getSize();
        this.scrolled.setMinHeight(point2.y + point.y);
        this.scrolled.setMinWidth(Math.max(point2.x, point.x));
    }

    private class PreferenceEntry {
        Composite composite;
        IPreferenceNode node;
        String title;
        int offset;
        Label expandImage;
        Label titleLabel;
        Composite pageContainer;

        PreferenceEntry(IPreferenceNode iPreferenceNode, String string) {
            this.node = iPreferenceNode;
            this.title = string;
        }

        private void addSubNodes() {
            IPreferenceNode[] iPreferenceNodeArray = this.node.getSubNodes();
            PreferenceEntry preferenceEntry = null;
            int n = 0;
            while (n < iPreferenceNodeArray.length) {
                PreferenceEntry preferenceEntry2 = PreferencesPageContainer.this.createEntry(iPreferenceNodeArray[n], iPreferenceNodeArray[n].getLabelText(), this.offset + 1);
                if (preferenceEntry == null) {
                    preferenceEntry2.composite.moveBelow((Control)this.composite);
                } else {
                    preferenceEntry2.composite.moveBelow((Control)preferenceEntry.composite);
                }
                preferenceEntry = preferenceEntry2;
                ++n;
            }
        }

        void createContents(int n) {
            this.composite = new Composite(PreferencesPageContainer.this.control, 0);
            GridData gridData = new GridData(768);
            gridData.horizontalIndent = 7 * n;
            this.composite.setLayoutData((Object)gridData);
            FormLayout formLayout = new FormLayout();
            formLayout.marginHeight = 0;
            formLayout.marginWidth = 0;
            this.composite.setLayout((Layout)formLayout);
            Font font = JFaceResources.getBannerFont();
            this.expandImage = new Label(this.composite, 131072);
            this.expandImage.setText("+");
            this.expandImage.setFont(font);
            FormData formData = new FormData();
            formData.top = new FormAttachment(0);
            formData.left = new FormAttachment(0, 4);
            this.expandImage.setLayoutData((Object)formData);
            this.titleLabel = new Label(this.composite, 16384);
            this.titleLabel.setText(this.title);
            this.titleLabel.setFont(font);
            FormData formData2 = new FormData();
            formData2.right = new FormAttachment(100);
            formData2.top = new FormAttachment(0);
            formData2.left = new FormAttachment((Control)this.expandImage, 4);
            this.titleLabel.setLayoutData((Object)formData2);
            this.titleLabel.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent mouseEvent) {
                    if (PreferenceEntry.this.pageContainer == null) {
                        boolean bl = false;
                        PreferenceEntry.this.pageContainer = new Composite(PreferenceEntry.this.composite, 2048);
                        FormData formData = new FormData();
                        formData.top = new FormAttachment((Control)PreferenceEntry.this.titleLabel, 0);
                        formData.left = new FormAttachment(0);
                        formData.right = new FormAttachment(100);
                        PreferenceEntry.this.pageContainer.setLayoutData((Object)formData);
                        PreferenceEntry.this.pageContainer.setLayout((Layout)new GridLayout());
                        PreferenceEntry.this.node.createPage();
                        PreferenceEntry.this.node.getPage().createControl(PreferenceEntry.this.pageContainer);
                        PreferenceEntry.this.node.getPage().setContainer((IPreferencePageContainer)PreferencesPageContainer.this);
                        PreferenceEntry.this.node.getPage().getControl().setLayoutData((Object)new GridData(1808));
                        bl = true;
                        Point point = PreferenceEntry.this.node.getPage().computeSize();
                        Rectangle rectangle = PreferenceEntry.this.composite.getClientArea();
                        if (point.x < rectangle.width) {
                            point.x = rectangle.width;
                        }
                        PreferenceEntry.this.node.getPage().setSize(point);
                        if (bl) {
                            PreferencesPageContainer.this.adjustScrollbars(point);
                        }
                        PreferenceEntry.this.expandImage.setText("-");
                        PreferenceEntry.this.addSubNodes();
                        PreferenceEntry.this.setSelectionColors(PreferenceEntry.this.composite.getDisplay().getSystemColor(29));
                    } else {
                        PreferenceEntry.this.setSelectionColors(null);
                        PreferenceEntry.this.pageContainer.dispose();
                        PreferenceEntry.this.pageContainer = null;
                        PreferenceEntry.this.expandImage.setText("+");
                    }
                    PreferencesPageContainer.this.control.layout(true);
                }
            });
            this.offset = n;
        }

        private void setSelectionColors(Color color) {
            this.composite.setBackground(color);
            this.titleLabel.setBackground(color);
            this.expandImage.setBackground(color);
        }
    }
}

