/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.internal.preferences.WorkbenchPreferenceExtensionNode;

public class PreferencePatternFilter
extends PatternFilter {
    private Map keywordCache = new HashMap();

    private String[] getKeywords(Object object) {
        ArrayList arrayList = new ArrayList();
        if (object instanceof WorkbenchPreferenceExtensionNode) {
            WorkbenchPreferenceExtensionNode workbenchPreferenceExtensionNode = (WorkbenchPreferenceExtensionNode)object;
            Collection collection = (Collection)this.keywordCache.get(object);
            if (collection == null) {
                collection = workbenchPreferenceExtensionNode.getKeywordLabels();
                this.keywordCache.put(object, collection);
            }
            if (!collection.isEmpty()) {
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    arrayList.add(iterator.next());
                }
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    @Override
    public boolean isElementSelectable(Object object) {
        return object instanceof WorkbenchPreferenceExtensionNode;
    }

    @Override
    public boolean isElementVisible(Viewer viewer, Object object) {
        IPreferenceNode iPreferenceNode;
        if (WorkbenchActivityHelper.restrictUseOf(object)) {
            return false;
        }
        if (this.isLeafMatch(viewer, object)) {
            return true;
        }
        ITreeContentProvider iTreeContentProvider = (ITreeContentProvider)((TreeViewer)viewer).getContentProvider();
        Object[] objectArray = iTreeContentProvider.getChildren((Object)(iPreferenceNode = (IPreferenceNode)object));
        return this.filter(viewer, object, objectArray).length > 0;
    }

    @Override
    protected boolean isLeafMatch(Viewer viewer, Object object) {
        IPreferenceNode iPreferenceNode = (IPreferenceNode)object;
        String string = iPreferenceNode.getLabelText();
        if (this.wordMatches(string)) {
            return true;
        }
        String[] stringArray = this.getKeywords(iPreferenceNode);
        int n = 0;
        while (n < stringArray.length) {
            if (this.wordMatches(stringArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }
}

