/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.ActiveShellExpression;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.dialogs.FilteredPreferenceDialog;
import org.eclipse.ui.internal.dialogs.PreferenceHistoryEntry;

class PreferencePageHistory {
    private ToolBarManager historyToolbar;
    private List history = new ArrayList();
    private int historyIndex = -1;
    private final FilteredPreferenceDialog dialog;
    private Set activations = new HashSet();

    public PreferencePageHistory(FilteredPreferenceDialog filteredPreferenceDialog) {
        this.dialog = filteredPreferenceDialog;
    }

    private PreferenceHistoryEntry getHistoryEntry(int n) {
        if (n >= 0 && n < this.history.size()) {
            return (PreferenceHistoryEntry)this.history.get(n);
        }
        return null;
    }

    public void addHistoryEntry(PreferenceHistoryEntry preferenceHistoryEntry) {
        if (this.historyIndex == -1 || !this.history.get(this.historyIndex).equals(preferenceHistoryEntry)) {
            this.history.subList(this.historyIndex + 1, this.history.size()).clear();
            this.history.add(preferenceHistoryEntry);
            ++this.historyIndex;
            this.updateHistoryControls();
        }
    }

    private void jumpToHistory(int n) {
        if (n >= 0 && n < this.history.size()) {
            this.historyIndex = n;
            this.dialog.setCurrentPageId(this.getHistoryEntry(n).getId());
        }
        this.updateHistoryControls();
    }

    private void updateHistoryControls() {
        this.historyToolbar.update(false);
        IContributionItem[] iContributionItemArray = this.historyToolbar.getItems();
        int n = 0;
        while (n < iContributionItemArray.length) {
            iContributionItemArray[n].update("enabled");
            iContributionItemArray[n].update("toolTipText");
            ++n;
        }
    }

    public ToolBar createHistoryControls(ToolBar toolBar, ToolBarManager toolBarManager) {
        this.historyToolbar = toolBarManager;
        abstract class HistoryNavigationAction
        extends Action
        implements IMenuCreator {
            private Menu lastMenu;
            protected static final int MAX_ENTRIES = 5;

            HistoryNavigationAction() {
                super("", 4);
            }

            public IMenuCreator getMenuCreator() {
                return this;
            }

            public void dispose() {
                if (this.lastMenu != null) {
                    this.lastMenu.dispose();
                    this.lastMenu = null;
                }
            }

            public Menu getMenu(Control control) {
                if (this.lastMenu != null) {
                    this.lastMenu.dispose();
                }
                this.lastMenu = new Menu(control);
                this.createEntries(this.lastMenu);
                return this.lastMenu;
            }

            public Menu getMenu(Menu menu) {
                return null;
            }

            protected void addActionToMenu(Menu menu, IAction iAction) {
                ActionContributionItem actionContributionItem = new ActionContributionItem(iAction);
                actionContributionItem.fill(menu, -1);
            }

            protected abstract void createEntries(Menu var1);
        }
        HistoryNavigationAction historyNavigationAction = new HistoryNavigationAction(){
            {
            }

            public void run() {
                PreferencePageHistory.this.jumpToHistory(PreferencePageHistory.this.historyIndex - 1);
            }

            public boolean isEnabled() {
                boolean bl;
                boolean bl2 = bl = PreferencePageHistory.this.historyIndex > 0;
                if (bl) {
                    this.setToolTipText(NLS.bind((String)WorkbenchMessages.NavigationHistoryAction_backward_toolTipName, (Object)PreferencePageHistory.this.getHistoryEntry(PreferencePageHistory.this.historyIndex - 1).getLabel()));
                }
                return bl;
            }

            @Override
            protected void createEntries(Menu menu) {
                int n = Math.max(0, PreferencePageHistory.this.historyIndex - 5);
                int n2 = PreferencePageHistory.this.historyIndex - 1;
                while (n2 >= n) {
                    class HistoryItemAction
                    extends Action {
                        private final int index;

                        HistoryItemAction(int n, String string) {
                            super(string, 1);
                            this.index = n;
                        }

                        public void run() {
                            PreferencePageHistory.this.jumpToHistory(this.index);
                        }
                    }
                    HistoryItemAction historyItemAction = new HistoryItemAction(n2, PreferencePageHistory.this.getHistoryEntry(n2).getLabel());
                    this.addActionToMenu(menu, (IAction)historyItemAction);
                    --n2;
                }
            }
        };
        historyNavigationAction.setText(WorkbenchMessages.NavigationHistoryAction_backward_text);
        historyNavigationAction.setActionDefinitionId("org.eclipse.ui.navigate.backwardHistory");
        historyNavigationAction.setImageDescriptor(WorkbenchPlugin.getDefault().getSharedImages().getImageDescriptor("IMG_TOOL_BACK"));
        historyNavigationAction.setDisabledImageDescriptor(WorkbenchPlugin.getDefault().getSharedImages().getImageDescriptor("IMG_TOOL_BACK_DISABLED"));
        this.registerKeybindings((IAction)historyNavigationAction);
        this.historyToolbar.add((IAction)historyNavigationAction);
        HistoryNavigationAction historyNavigationAction2 = new HistoryNavigationAction(){
            {
            }

            public void run() {
                PreferencePageHistory.this.jumpToHistory(PreferencePageHistory.this.historyIndex + 1);
            }

            public boolean isEnabled() {
                boolean bl;
                boolean bl2 = bl = PreferencePageHistory.this.historyIndex < PreferencePageHistory.this.history.size() - 1;
                if (bl) {
                    this.setToolTipText(NLS.bind((String)WorkbenchMessages.NavigationHistoryAction_forward_toolTipName, (Object)PreferencePageHistory.this.getHistoryEntry(PreferencePageHistory.this.historyIndex + 1).getLabel()));
                }
                return bl;
            }

            @Override
            protected void createEntries(Menu menu) {
                int n = Math.min(PreferencePageHistory.this.history.size(), PreferencePageHistory.this.historyIndex + 5 + 1);
                int n2 = PreferencePageHistory.this.historyIndex + 1;
                while (n2 < n) {
                    HistoryItemAction historyItemAction = new HistoryItemAction(n2, PreferencePageHistory.this.getHistoryEntry(n2).getLabel());
                    this.addActionToMenu(menu, (IAction)historyItemAction);
                    ++n2;
                }
            }
        };
        historyNavigationAction2.setText(WorkbenchMessages.NavigationHistoryAction_forward_text);
        historyNavigationAction2.setActionDefinitionId("org.eclipse.ui.navigate.forwardHistory");
        historyNavigationAction2.setImageDescriptor(WorkbenchPlugin.getDefault().getSharedImages().getImageDescriptor("IMG_TOOL_FORWARD"));
        historyNavigationAction2.setDisabledImageDescriptor(WorkbenchPlugin.getDefault().getSharedImages().getImageDescriptor("IMG_TOOL_FORWARD_DISABLED"));
        this.registerKeybindings((IAction)historyNavigationAction2);
        this.historyToolbar.add((IAction)historyNavigationAction2);
        return toolBar;
    }

    private void registerKeybindings(IAction iAction) {
        ActionHandler actionHandler = new ActionHandler(iAction);
        IHandlerService iHandlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
        IHandlerActivation iHandlerActivation = iHandlerService.activateHandler(iAction.getActionDefinitionId(), (IHandler)actionHandler, new ActiveShellExpression(this.dialog.getShell()));
        this.activations.add(iHandlerActivation);
    }

    public void dispose() {
        IHandlerService iHandlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
        Iterator iterator = this.activations.iterator();
        while (iterator.hasNext()) {
            iHandlerService.deactivateHandler((IHandlerActivation)iterator.next());
        }
        this.activations.clear();
    }
}

